/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.mongo.entities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.keycloak.authorization.model.Policy;
import org.keycloak.connections.mongo.api.MongoCollection;
import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.entities.AbstractIdentifiableEntity;

@MongoCollection(collectionName="policies")
public class PolicyEntity
extends AbstractIdentifiableEntity
implements MongoIdentifiableEntity {
    private String name;
    private String description;
    private String type;
    private Policy.DecisionStrategy decisionStrategy = Policy.DecisionStrategy.UNANIMOUS;
    private Policy.Logic logic = Policy.Logic.POSITIVE;
    private Map<String, String> config = new HashMap<String, String>();
    private String resourceServerId;
    private Set<String> associatedPolicies = new HashSet<String>();
    private Set<String> resources = new HashSet<String>();
    private Set<String> scopes = new HashSet<String>();

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Policy.DecisionStrategy getDecisionStrategy() {
        return this.decisionStrategy;
    }

    public void setDecisionStrategy(Policy.DecisionStrategy decisionStrategy) {
        this.decisionStrategy = decisionStrategy;
    }

    public Policy.Logic getLogic() {
        return this.logic;
    }

    public void setLogic(Policy.Logic logic) {
        this.logic = logic;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getResourceServerId() {
        return this.resourceServerId;
    }

    public void setResourceServerId(String resourceServerId) {
        this.resourceServerId = resourceServerId;
    }

    public Set<String> getAssociatedPolicies() {
        return this.associatedPolicies;
    }

    public void setAssociatedPolicies(Set<String> associatedPolicies) {
        this.associatedPolicies = associatedPolicies;
    }

    public Set<String> getResources() {
        return this.resources;
    }

    public void setResources(Set<String> resources) {
        this.resources = resources;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<String> scopes) {
        this.scopes = scopes;
    }

    public void addScope(String scopeId) {
        this.getScopes().add(scopeId);
    }

    public void removeScope(String scopeId) {
        this.getScopes().remove(scopeId);
    }

    public void addAssociatedPolicy(String policyId) {
        this.getAssociatedPolicies().add(policyId);
    }

    public void removeAssociatedPolicy(String policyId) {
        this.getAssociatedPolicies().remove(policyId);
    }

    public void addResource(String resourceId) {
        this.getResources().add(resourceId);
    }

    public void removeResource(String resourceId) {
        this.getResources().remove(resourceId);
    }

    @Override
    public void afterRemove(MongoStoreInvocationContext invocationContext) {
    }
}

