/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.AttributeConverter;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.cfg.AttributeConverterDefinition;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.converter.AttributeConverterSqlTypeDescriptorAdapter;
import org.hibernate.type.descriptor.converter.AttributeConverterTypeAdapter;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptorRegistry;
import org.hibernate.type.descriptor.sql.JdbcTypeJavaClassMappings;
import org.hibernate.type.descriptor.sql.NationalizedTypeMappings;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptorRegistry;
import org.hibernate.usertype.DynamicParameterizedType;

public class SimpleValue
implements KeyValue {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(SimpleValue.class);
    public static final String DEFAULT_ID_GEN_STRATEGY = "assigned";
    private final MetadataImplementor metadata;
    private final List<Selectable> columns = new ArrayList<Selectable>();
    private String typeName;
    private Properties typeParameters;
    private boolean isNationalized;
    private Properties identifierGeneratorProperties;
    private String identifierGeneratorStrategy = "assigned";
    private String nullValue;
    private Table table;
    private String foreignKeyName;
    private boolean alternateUniqueKey;
    private boolean cascadeDeleteEnabled;
    private AttributeConverterDefinition attributeConverterDefinition;
    private Type type;
    private IdentifierGenerator identifierGenerator;

    public SimpleValue(MetadataImplementor metadata) {
        this.metadata = metadata;
    }

    public SimpleValue(MetadataImplementor metadata, Table table) {
        this(metadata);
        this.table = table;
    }

    public MetadataImplementor getMetadata() {
        return this.metadata;
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.getMetadata().getMetadataBuildingOptions().getServiceRegistry();
    }

    @Override
    public boolean isCascadeDeleteEnabled() {
        return this.cascadeDeleteEnabled;
    }

    public void setCascadeDeleteEnabled(boolean cascadeDeleteEnabled) {
        this.cascadeDeleteEnabled = cascadeDeleteEnabled;
    }

    public void addColumn(Column column) {
        if (!this.columns.contains(column)) {
            this.columns.add(column);
        }
        column.setValue(this);
        column.setTypeIndex(this.columns.size() - 1);
    }

    public void addFormula(Formula formula) {
        this.columns.add(formula);
    }

    @Override
    public boolean hasFormula() {
        Iterator<Selectable> iter = this.getColumnIterator();
        while (iter.hasNext()) {
            Selectable o = iter.next();
            if (!(o instanceof Formula)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getColumnSpan() {
        return this.columns.size();
    }

    @Override
    public Iterator<Selectable> getColumnIterator() {
        return this.columns.iterator();
    }

    public List getConstraintColumns() {
        return this.columns;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        if (typeName != null && typeName.startsWith("converted::")) {
            String converterClassName = typeName.substring("converted::".length());
            ClassLoaderService cls = this.getMetadata().getMetadataBuildingOptions().getServiceRegistry().getService(ClassLoaderService.class);
            try {
                Class converterClass = cls.classForName(converterClassName);
                this.attributeConverterDefinition = new AttributeConverterDefinition((AttributeConverter)converterClass.newInstance(), false);
                return;
            }
            catch (Exception e) {
                log.logBadHbmAttributeConverterType(typeName, e.getMessage());
            }
        }
        this.typeName = typeName;
    }

    public void makeNationalized() {
        this.isNationalized = true;
    }

    public boolean isNationalized() {
        return this.isNationalized;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    @Override
    public void createForeignKey() throws MappingException {
    }

    @Override
    public void createForeignKeyOfEntity(String entityName) {
        if (!this.hasFormula() && !"none".equals(this.getForeignKeyName())) {
            ForeignKey fk = this.table.createForeignKey(this.getForeignKeyName(), this.getConstraintColumns(), entityName);
            fk.setCascadeDeleteEnabled(this.cascadeDeleteEnabled);
        }
    }

    @Override
    public IdentifierGenerator createIdentifierGenerator(IdentifierGeneratorFactory identifierGeneratorFactory, Dialect dialect, String defaultCatalog, String defaultSchema, RootClass rootClass) throws MappingException {
        if (this.identifierGenerator != null) {
            return this.identifierGenerator;
        }
        Properties params = new Properties();
        if (defaultSchema != null) {
            params.setProperty("schema", defaultSchema);
        }
        if (defaultCatalog != null) {
            params.setProperty("catalog", defaultCatalog);
        }
        if (rootClass != null) {
            params.setProperty("entity_name", rootClass.getEntityName());
            params.setProperty("jpa_entity_name", rootClass.getJpaEntityName());
        }
        String tableName = this.getTable().getQuotedName(dialect);
        params.setProperty("target_table", tableName);
        String columnName = ((Column)this.getColumnIterator().next()).getQuotedName(dialect);
        params.setProperty("target_column", columnName);
        if (rootClass != null) {
            StringBuilder tables = new StringBuilder();
            Iterator<Table> iter = rootClass.getIdentityTables().iterator();
            while (iter.hasNext()) {
                Table table = iter.next();
                tables.append(table.getQuotedName(dialect));
                if (!iter.hasNext()) continue;
                tables.append(", ");
            }
            params.setProperty("identity_tables", tables.toString());
        } else {
            params.setProperty("identity_tables", tableName);
        }
        if (this.identifierGeneratorProperties != null) {
            params.putAll((Map<?, ?>)this.identifierGeneratorProperties);
        }
        ConfigurationService cs = this.metadata.getMetadataBuildingOptions().getServiceRegistry().getService(ConfigurationService.class);
        params.put("hibernate.id.optimizer.pooled.prefer_lo", cs.getSetting("hibernate.id.optimizer.pooled.prefer_lo", StandardConverters.BOOLEAN, Boolean.valueOf(false)));
        if (cs.getSettings().get("hibernate.id.optimizer.pooled.preferred") != null) {
            params.put("hibernate.id.optimizer.pooled.preferred", cs.getSettings().get("hibernate.id.optimizer.pooled.preferred"));
        }
        identifierGeneratorFactory.setDialect(dialect);
        this.identifierGenerator = identifierGeneratorFactory.createIdentifierGenerator(this.identifierGeneratorStrategy, this.getType(), params);
        return this.identifierGenerator;
    }

    @Override
    public boolean isUpdateable() {
        return true;
    }

    @Override
    public FetchMode getFetchMode() {
        return FetchMode.SELECT;
    }

    public Properties getIdentifierGeneratorProperties() {
        return this.identifierGeneratorProperties;
    }

    @Override
    public String getNullValue() {
        return this.nullValue;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    public String getIdentifierGeneratorStrategy() {
        return this.identifierGeneratorStrategy;
    }

    @Override
    public boolean isIdentityColumn(IdentifierGeneratorFactory identifierGeneratorFactory, Dialect dialect) {
        identifierGeneratorFactory.setDialect(dialect);
        return identifierGeneratorFactory.getIdentifierGeneratorClass(this.identifierGeneratorStrategy).equals(IdentityGenerator.class);
    }

    public void setIdentifierGeneratorProperties(Properties identifierGeneratorProperties) {
        this.identifierGeneratorProperties = identifierGeneratorProperties;
    }

    public void setIdentifierGeneratorStrategy(String identifierGeneratorStrategy) {
        this.identifierGeneratorStrategy = identifierGeneratorStrategy;
    }

    public void setNullValue(String nullValue) {
        this.nullValue = nullValue;
    }

    public String getForeignKeyName() {
        return this.foreignKeyName;
    }

    public void setForeignKeyName(String foreignKeyName) {
        this.foreignKeyName = foreignKeyName;
    }

    @Override
    public boolean isAlternateUniqueKey() {
        return this.alternateUniqueKey;
    }

    public void setAlternateUniqueKey(boolean unique) {
        this.alternateUniqueKey = unique;
    }

    @Override
    public boolean isNullable() {
        Iterator<Selectable> itr = this.getColumnIterator();
        while (itr.hasNext()) {
            Selectable selectable = itr.next();
            if (selectable instanceof Formula) {
                return true;
            }
            if (((Column)selectable).isNullable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSimpleValue() {
        return true;
    }

    @Override
    public boolean isValid(Mapping mapping) throws MappingException {
        return this.getColumnSpan() == this.getType().getColumnSpan(mapping);
    }

    @Override
    public Type getType() throws MappingException {
        Type result;
        if (this.type != null) {
            return this.type;
        }
        if (this.typeName == null) {
            throw new MappingException("No type name");
        }
        if (this.typeParameters != null && Boolean.valueOf(this.typeParameters.getProperty("org.hibernate.type.ParameterType.dynamic")).booleanValue() && this.typeParameters.get("org.hibernate.type.ParameterType") == null) {
            this.createParameterImpl();
        }
        if ((result = this.metadata.getTypeResolver().heuristicType(this.typeName, this.typeParameters)) == null) {
            String msg = "Could not determine type for: " + this.typeName;
            if (this.table != null) {
                msg = msg + ", at table: " + this.table.getName();
            }
            if (this.columns != null && this.columns.size() > 0) {
                msg = msg + ", for columns: " + this.columns;
            }
            throw new MappingException(msg);
        }
        return result;
    }

    @Override
    public void setTypeUsingReflection(String className, String propertyName) throws MappingException {
        if (this.typeName != null) {
            return;
        }
        if (this.type != null) {
            return;
        }
        if (this.attributeConverterDefinition == null) {
            if (className == null) {
                throw new MappingException("Attribute types for a dynamic entity must be explicitly specified: " + propertyName);
            }
            this.typeName = ReflectHelper.reflectedPropertyClass(className, propertyName, this.metadata.getMetadataBuildingOptions().getServiceRegistry().getService(ClassLoaderService.class)).getName();
            return;
        }
        this.type = this.buildAttributeConverterTypeAdapter();
    }

    private Type buildAttributeConverterTypeAdapter() {
        Class entityAttributeJavaType = this.attributeConverterDefinition.getEntityAttributeType();
        Class databaseColumnJavaType = this.attributeConverterDefinition.getDatabaseColumnType();
        JavaTypeDescriptor entityAttributeJavaTypeDescriptor = JavaTypeDescriptorRegistry.INSTANCE.getDescriptor(entityAttributeJavaType);
        int jdbcTypeCode = JdbcTypeJavaClassMappings.INSTANCE.determineJdbcTypeCodeForJavaClass(databaseColumnJavaType);
        if (this.isNationalized()) {
            jdbcTypeCode = NationalizedTypeMappings.INSTANCE.getCorrespondingNationalizedCode(jdbcTypeCode);
        }
        SqlTypeDescriptor sqlTypeDescriptor = SqlTypeDescriptorRegistry.INSTANCE.getDescriptor(jdbcTypeCode);
        JavaTypeDescriptor intermediateJavaTypeDescriptor = JavaTypeDescriptorRegistry.INSTANCE.getDescriptor(databaseColumnJavaType);
        AttributeConverterSqlTypeDescriptorAdapter sqlTypeDescriptorAdapter = new AttributeConverterSqlTypeDescriptorAdapter(this.attributeConverterDefinition.getAttributeConverter(), sqlTypeDescriptor, intermediateJavaTypeDescriptor);
        String name = "converted::" + this.attributeConverterDefinition.getAttributeConverter().getClass().getName();
        String description = String.format("BasicType adapter for AttributeConverter<%s,%s>", entityAttributeJavaType.getSimpleName(), databaseColumnJavaType.getSimpleName());
        return new AttributeConverterTypeAdapter(name, description, this.attributeConverterDefinition.getAttributeConverter(), sqlTypeDescriptorAdapter, entityAttributeJavaType, databaseColumnJavaType, entityAttributeJavaTypeDescriptor);
    }

    public boolean isTypeSpecified() {
        return this.typeName != null;
    }

    public void setTypeParameters(Properties parameterMap) {
        this.typeParameters = parameterMap;
    }

    public Properties getTypeParameters() {
        return this.typeParameters;
    }

    public void copyTypeFrom(SimpleValue sourceValue) {
        this.setTypeName(sourceValue.getTypeName());
        this.setTypeParameters(sourceValue.getTypeParameters());
        this.type = sourceValue.type;
        this.attributeConverterDefinition = sourceValue.attributeConverterDefinition;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.columns.toString() + ')';
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    @Override
    public boolean[] getColumnInsertability() {
        boolean[] result = new boolean[this.getColumnSpan()];
        int i = 0;
        Iterator<Selectable> iter = this.getColumnIterator();
        while (iter.hasNext()) {
            Selectable s = iter.next();
            result[i++] = !s.isFormula();
        }
        return result;
    }

    @Override
    public boolean[] getColumnUpdateability() {
        return this.getColumnInsertability();
    }

    public void setJpaAttributeConverterDefinition(AttributeConverterDefinition attributeConverterDefinition) {
        this.attributeConverterDefinition = attributeConverterDefinition;
    }

    private void createParameterImpl() {
        try {
            String[] columnsNames = new String[this.columns.size()];
            for (int i = 0; i < this.columns.size(); ++i) {
                Selectable column = this.columns.get(i);
                if (!(column instanceof Column)) continue;
                columnsNames[i] = ((Column)column).getName();
            }
            XProperty xProperty = (XProperty)this.typeParameters.get("org.hibernate.type.ParameterType.xproperty");
            Annotation[] annotations = xProperty == null ? null : xProperty.getAnnotations();
            ClassLoaderService classLoaderService = this.getMetadata().getMetadataBuildingOptions().getServiceRegistry().getService(ClassLoaderService.class);
            this.typeParameters.put("org.hibernate.type.ParameterType", new ParameterTypeImpl(classLoaderService.classForName(this.typeParameters.getProperty("org.hibernate.type.ParameterType.returnedClass")), annotations, this.table.getCatalog(), this.table.getSchema(), this.table.getName(), Boolean.valueOf(this.typeParameters.getProperty("org.hibernate.type.ParameterType.primaryKey")), columnsNames));
        }
        catch (ClassLoadingException e) {
            throw new MappingException("Could not create DynamicParameterizedType for type: " + this.typeName, e);
        }
    }

    private static final class ParameterTypeImpl
    implements DynamicParameterizedType.ParameterType {
        private final Class returnedClass;
        private final Annotation[] annotationsMethod;
        private final String catalog;
        private final String schema;
        private final String table;
        private final boolean primaryKey;
        private final String[] columns;

        private ParameterTypeImpl(Class returnedClass, Annotation[] annotationsMethod, String catalog, String schema, String table, boolean primaryKey, String[] columns) {
            this.returnedClass = returnedClass;
            this.annotationsMethod = annotationsMethod;
            this.catalog = catalog;
            this.schema = schema;
            this.table = table;
            this.primaryKey = primaryKey;
            this.columns = columns;
        }

        @Override
        public Class getReturnedClass() {
            return this.returnedClass;
        }

        @Override
        public Annotation[] getAnnotationsMethod() {
            return this.annotationsMethod;
        }

        @Override
        public String getCatalog() {
            return this.catalog;
        }

        @Override
        public String getSchema() {
            return this.schema;
        }

        @Override
        public String getTable() {
            return this.table;
        }

        @Override
        public boolean isPrimaryKey() {
            return this.primaryKey;
        }

        @Override
        public String[] getColumns() {
            return this.columns;
        }
    }
}

