/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.util.Collection;
import java.util.Collections;
import org.apache.qpid.proton.codec.AbstractPrimitiveType;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FixedSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeEncoding;

public class ByteType
extends AbstractPrimitiveType<Byte> {
    private ByteEncoding _byteEncoding;

    ByteType(EncoderImpl encoder, DecoderImpl decoder) {
        this._byteEncoding = new ByteEncoding(encoder, decoder);
        encoder.register(Byte.class, this);
        decoder.register(this);
    }

    @Override
    public Class<Byte> getTypeClass() {
        return Byte.class;
    }

    public ByteEncoding getEncoding(Byte val) {
        return this._byteEncoding;
    }

    public ByteEncoding getCanonicalEncoding() {
        return this._byteEncoding;
    }

    @Override
    public Collection<ByteEncoding> getAllEncodings() {
        return Collections.singleton(this._byteEncoding);
    }

    public void writeType(byte b) {
        this._byteEncoding.write(b);
    }

    public class ByteEncoding
    extends FixedSizePrimitiveTypeEncoding<Byte> {
        public ByteEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected int getFixedSize() {
            return 1;
        }

        @Override
        public byte getEncodingCode() {
            return 81;
        }

        public ByteType getType() {
            return ByteType.this;
        }

        @Override
        public void writeValue(Byte val) {
            this.getEncoder().writeRaw(val);
        }

        public void write(byte val) {
            this.writeConstructor();
            this.getEncoder().writeRaw(val);
        }

        @Override
        public void writeValue(byte val) {
            this.getEncoder().writeRaw(val);
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Byte> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public Byte readValue() {
            return this.readPrimitiveValue();
        }

        public byte readPrimitiveValue() {
            return this.getDecoder().readRawByte();
        }

        @Override
        public boolean encodesJavaPrimitive() {
            return true;
        }
    }
}

