/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.notification.Notification;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.ContentServitor;
import org.jboss.as.server.deployment.DeployerChains;
import org.jboss.as.server.deployment.DeploymentHandlerUtils;
import org.jboss.as.server.deployment.DeploymentMountProvider;
import org.jboss.as.server.deployment.DeploymentResourceSupport;
import org.jboss.as.server.deployment.PathContentServitor;
import org.jboss.as.server.deployment.RootDeploymentUnitService;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayIndex;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.vfs.VirtualFile;

public class DeploymentHandlerUtil {
    private DeploymentHandlerUtil() {
    }

    public static void deploy(OperationContext context, ModelNode operation, final String deploymentUnitName, final String managementName, final AbstractVaultReader vaultReader, final ContentItem ... contents) throws OperationFailedException {
        assert (contents != null) : "contents is null";
        if (context.isNormalServer()) {
            final Resource deployment = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            final ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
            final ManagementResourceRegistration mutableRegistration = context.getResourceRegistrationForUpdate();
            DeploymentResourceSupport.cleanup(deployment);
            ModelNode notificationData = new ModelNode();
            notificationData.get("name").set(managementName);
            notificationData.get("server-booting").set(context.isBooting());
            if (operation.hasDefined(DeploymentAttributes.OWNER.getName())) {
                try {
                    notificationData.get(DeploymentAttributes.OWNER.getName()).set(DeploymentAttributes.OWNER.resolveModelAttribute(context, operation));
                }
                catch (OperationFailedException operationFailedException) {
                    // empty catch block
                }
            }
            notificationData.get("deployment").set(deploymentUnitName);
            context.emit(new Notification("deployment-deployed", context.getCurrentAddress(), ServerLogger.ROOT_LOGGER.deploymentDeployedNotification(managementName, deploymentUnitName), notificationData));
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) {
                    ServiceName deploymentUnitServiceName = Services.deploymentUnitName(deploymentUnitName);
                    ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
                    final ServiceController deploymentController = serviceRegistry.getService(deploymentUnitServiceName);
                    if (deploymentController != null) {
                        deploymentController.setMode(ServiceController.Mode.ACTIVE);
                        context.completeStep(new OperationContext.RollbackHandler(){

                            public void handleRollback(OperationContext context, ModelNode operation) {
                                deploymentController.setMode(ServiceController.Mode.NEVER);
                            }
                        });
                    } else {
                        DeploymentHandlerUtil.doDeploy(context, deploymentUnitName, managementName, deployment, registration, mutableRegistration, vaultReader, contents);
                        context.completeStep(new OperationContext.ResultHandler(){

                            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                                if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                                    if (context.hasFailureDescription()) {
                                        ServerLogger.ROOT_LOGGER.deploymentRolledBack(deploymentUnitName, DeploymentHandlerUtil.getFormattedFailureDescription(context));
                                    } else {
                                        ServerLogger.ROOT_LOGGER.deploymentRolledBackWithNoMessage(deploymentUnitName);
                                    }
                                } else {
                                    ServerLogger.ROOT_LOGGER.deploymentDeployed(managementName, deploymentUnitName);
                                }
                            }
                        });
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    public static void doDeploy(OperationContext context, String deploymentUnitName, String managementName, Resource deploymentResource, ImmutableManagementResourceRegistration registration, ManagementResourceRegistration mutableRegistration, AbstractVaultReader vaultReader, ContentItem ... contents) {
        ServiceController<VirtualFile> contentService;
        ServiceName deploymentUnitServiceName = Services.deploymentUnitName(deploymentUnitName);
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceName contentsServiceName = deploymentUnitServiceName.append(new String[]{"contents"});
        if (contents[0].hash != null) {
            contentService = ContentServitor.addService(serviceTarget, contentsServiceName, contents[0].hash);
        } else {
            String path = contents[0].path;
            String relativeTo = contents[0].relativeTo;
            contentService = PathContentServitor.addService(serviceTarget, contentsServiceName, path, relativeTo);
        }
        DeploymentOverlayIndex overlays = DeploymentOverlayIndex.createDeploymentOverlayIndex(context);
        RootDeploymentUnitService service = new RootDeploymentUnitService(deploymentUnitName, managementName, null, registration, mutableRegistration, deploymentResource, context.getCapabilityServiceSupport(), vaultReader, overlays);
        final ServiceController deploymentUnitController = serviceTarget.addService(deploymentUnitServiceName, (Service)service).addDependency(Services.JBOSS_DEPLOYMENT_CHAINS, DeployerChains.class, service.getDeployerChainsInjector()).addDependency(DeploymentMountProvider.SERVICE_NAME, DeploymentMountProvider.class, service.getServerDeploymentRepositoryInjector()).addDependency(PathManagerService.SERVICE_NAME, PathManager.class, service.getPathManagerInjector()).addDependency(contentsServiceName, VirtualFile.class, service.contentsInjector).setInitialMode(ServiceController.Mode.ACTIVE).install();
        contentService.addListener((ServiceListener)new AbstractServiceListener<Object>(){

            public void transition(ServiceController<?> controller, ServiceController.Transition transition) {
                if (transition == ServiceController.Transition.REMOVING_to_REMOVED) {
                    deploymentUnitController.setMode(ServiceController.Mode.REMOVE);
                }
            }
        });
    }

    public static void redeploy(OperationContext context, final String deploymentUnitName, final String managementName, final AbstractVaultReader vaultReader, final ContentItem ... contents) throws OperationFailedException {
        assert (contents != null) : "contents is null";
        if (context.isNormalServer()) {
            final Resource deployment = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            final ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
            final ManagementResourceRegistration mutableRegistration = context.getResourceRegistrationForUpdate();
            DeploymentResourceSupport.cleanup(deployment);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceName deploymentUnitServiceName = Services.deploymentUnitName(deploymentUnitName);
                    context.removeService(deploymentUnitServiceName);
                    context.removeService(deploymentUnitServiceName.append(new String[]{"contents"}));
                    final AtomicBoolean logged = new AtomicBoolean(false);
                    context.addStep(new OperationStepHandler(){

                        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                            DeploymentHandlerUtil.doDeploy(context, deploymentUnitName, managementName, deployment, registration, mutableRegistration, vaultReader, contents);
                            context.completeStep(new OperationContext.ResultHandler(){

                                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                                    if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                                        if (context.hasFailureDescription()) {
                                            ServerLogger.ROOT_LOGGER.redeployRolledBack(deploymentUnitName, DeploymentHandlerUtil.getFormattedFailureDescription(context));
                                            logged.set(true);
                                        } else {
                                            ServerLogger.ROOT_LOGGER.redeployRolledBackWithNoMessage(deploymentUnitName);
                                            logged.set(true);
                                        }
                                    } else {
                                        ServerLogger.ROOT_LOGGER.deploymentRedeployed(deploymentUnitName);
                                    }
                                }
                            });
                        }
                    }, OperationContext.Stage.RUNTIME, true);
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            DeploymentHandlerUtil.doDeploy(context, deploymentUnitName, managementName, deployment, registration, mutableRegistration, vaultReader, contents);
                            if (!logged.get()) {
                                if (context.hasFailureDescription()) {
                                    ServerLogger.ROOT_LOGGER.undeploymentRolledBack(deploymentUnitName, context.getFailureDescription().asString());
                                } else {
                                    ServerLogger.ROOT_LOGGER.undeploymentRolledBackWithNoMessage(deploymentUnitName);
                                }
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    public static void replace(OperationContext context, final ModelNode originalDeployment, final String deploymentUnitName, final String managementName, final String replacedDeploymentUnitName, final AbstractVaultReader vaultReader, final ContentItem ... contents) throws OperationFailedException {
        assert (contents != null) : "contents is null";
        if (context.isNormalServer()) {
            PathElement path = PathElement.pathElement((String)"deployment", (String)managementName);
            final Resource deployment = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{path}));
            final ImmutableManagementResourceRegistration registration = context.getResourceRegistration().getSubModel(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{path}));
            final ManagementResourceRegistration mutableRegistration = context.getResourceRegistrationForUpdate().getSubModel(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{path}));
            DeploymentResourceSupport.cleanup(deployment);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceName replacedDeploymentUnitServiceName = Services.deploymentUnitName(replacedDeploymentUnitName);
                    ServiceName replacedContentsServiceName = replacedDeploymentUnitServiceName.append(new String[]{"contents"});
                    context.removeService(replacedContentsServiceName);
                    context.removeService(replacedDeploymentUnitServiceName);
                    DeploymentHandlerUtil.doDeploy(context, deploymentUnitName, managementName, deployment, registration, mutableRegistration, vaultReader, contents);
                    context.completeStep(new OperationContext.ResultHandler(){

                        public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                            if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                                DeploymentResourceSupport.cleanup(deployment);
                                String name = originalDeployment.require("name").asString();
                                String runtimeName = originalDeployment.require("runtime-name").asString();
                                ContentItem[] contents = DeploymentHandlerUtils.getContents(originalDeployment.require("content"));
                                DeploymentHandlerUtil.doDeploy(context, runtimeName, name, deployment, registration, mutableRegistration, vaultReader, contents);
                                if (context.hasFailureDescription()) {
                                    ServerLogger.ROOT_LOGGER.replaceRolledBack(replacedDeploymentUnitName, deploymentUnitName, DeploymentHandlerUtil.getFormattedFailureDescription(context));
                                } else {
                                    ServerLogger.ROOT_LOGGER.replaceRolledBackWithNoMessage(replacedDeploymentUnitName, deploymentUnitName);
                                }
                            } else {
                                ServerLogger.ROOT_LOGGER.deploymentReplaced(replacedDeploymentUnitName, deploymentUnitName);
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    public static void undeploy(OperationContext context, ModelNode operation, final String managementName, final String runtimeName, final AbstractVaultReader vaultReader) {
        if (context.isNormalServer()) {
            final Resource deployment = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            final ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
            final ManagementResourceRegistration mutableRegistration = context.getResourceRegistrationForUpdate();
            DeploymentResourceSupport.cleanup(deployment);
            ModelNode notificationData = new ModelNode();
            notificationData.get("name").set(managementName);
            notificationData.get("server-booting").set(context.isBooting());
            if (operation.hasDefined(DeploymentAttributes.OWNER.getName())) {
                try {
                    notificationData.get(DeploymentAttributes.OWNER.getName()).set(DeploymentAttributes.OWNER.resolveModelAttribute(context, operation));
                }
                catch (OperationFailedException operationFailedException) {
                    // empty catch block
                }
            }
            notificationData.get("deployment").set(runtimeName);
            context.emit(new Notification("deployment-undeployed", context.getCurrentAddress(), ServerLogger.ROOT_LOGGER.deploymentUndeployedNotification(managementName, runtimeName), notificationData));
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) {
                    ServiceName deploymentUnitServiceName = Services.deploymentUnitName(runtimeName);
                    context.removeService(deploymentUnitServiceName);
                    context.removeService(deploymentUnitServiceName.append(new String[]{"contents"}));
                    context.completeStep(new OperationContext.ResultHandler(){

                        public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                            if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                                ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
                                ContentItem[] contents = DeploymentHandlerUtils.getContents(model.require("content"));
                                DeploymentHandlerUtil.doDeploy(context, runtimeName, managementName, deployment, registration, mutableRegistration, vaultReader, contents);
                                if (context.hasFailureDescription()) {
                                    ServerLogger.ROOT_LOGGER.undeploymentRolledBack(runtimeName, DeploymentHandlerUtil.getFormattedFailureDescription(context));
                                } else {
                                    ServerLogger.ROOT_LOGGER.undeploymentRolledBackWithNoMessage(runtimeName);
                                }
                            } else {
                                ServerLogger.ROOT_LOGGER.deploymentUndeployed(managementName, runtimeName);
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private static String getFormattedFailureDescription(OperationContext context) {
        ModelNode failureDescNode = context.getFailureDescription();
        String failureDesc = failureDescNode.toString();
        if (failureDesc.contains("\n") && failureDesc.charAt(0) != '\n') {
            failureDesc = "\n" + failureDesc;
        }
        return failureDesc;
    }

    static class ContentItem {
        private byte[] hash;
        private String path;
        private String relativeTo;
        private boolean isArchive;

        ContentItem(byte[] hash) {
            assert (hash != null) : "hash is null";
            this.hash = hash;
        }

        ContentItem(String path, String relativeTo, boolean isArchive) {
            assert (path != null) : "path is null";
            this.path = path;
            this.relativeTo = relativeTo;
            this.isArchive = isArchive;
        }

        byte[] getHash() {
            return this.hash;
        }
    }
}

