/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.user;

import java.io.IOException;
import java.util.ArrayList;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderAdminService;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.policy.provider.user.UserPolicyProvider;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.UserModel;
import org.keycloak.util.JsonSerialization;

public class UserPolicyProviderFactory
implements PolicyProviderFactory {
    public String getName() {
        return "User-Based";
    }

    public String getGroup() {
        return "Identity Based";
    }

    public PolicyProvider create(Policy policy, AuthorizationProvider authorization) {
        return new UserPolicyProvider(policy);
    }

    public PolicyProviderAdminService getAdminResource(ResourceServer resourceServer) {
        return null;
    }

    public PolicyProvider create(KeycloakSession session) {
        return null;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(event -> {
            if (event instanceof UserModel.UserRemovedEvent) {
                KeycloakSession keycloakSession = ((UserModel.UserRemovedEvent)event).getKeycloakSession();
                AuthorizationProvider provider = (AuthorizationProvider)keycloakSession.getProvider(AuthorizationProvider.class);
                PolicyStore policyStore = provider.getStoreFactory().getPolicyStore();
                UserModel removedUser = ((UserModel.UserRemovedEvent)event).getUser();
                policyStore.findByType(this.getId()).forEach(policy -> {
                    ArrayList<String> users = new ArrayList<String>();
                    for (String userId : UserPolicyProviderFactory.getUsers(policy)) {
                        if (userId.equals(removedUser.getId())) continue;
                        users.add(userId);
                    }
                    try {
                        if (users.isEmpty()) {
                            policyStore.findDependentPolicies(policy.getId()).forEach(dependentPolicy -> dependentPolicy.removeAssociatedPolicy(policy));
                            policyStore.delete(policy.getId());
                        } else {
                            policy.getConfig().put("users", JsonSerialization.writeValueAsString(users));
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error while synchronizing users with policy [" + policy.getName() + "].", e);
                    }
                });
            }
        });
    }

    public void close() {
    }

    public String getId() {
        return "user";
    }

    static String[] getUsers(Policy policy) {
        String roles = (String)policy.getConfig().get("users");
        if (roles != null) {
            try {
                return (String[])JsonSerialization.readValue((byte[])roles.getBytes(), String[].class);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not parse roles [" + roles + "] from policy config [" + policy.getName() + ".", e);
            }
        }
        return new String[0];
    }
}

