/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authentication.AuthenticationFlow;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.ClientAuthenticationFlow;
import org.keycloak.authentication.ClientAuthenticationFlowContext;
import org.keycloak.authentication.ClientAuthenticator;
import org.keycloak.authentication.DefaultAuthenticationFlow;
import org.keycloak.authentication.FlowStatus;
import org.keycloak.authentication.ForkFlowException;
import org.keycloak.authentication.FormAuthenticationFlow;
import org.keycloak.authentication.authenticators.client.ClientAuthUtil;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.services.ErrorPage;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.util.CacheControlUtil;

public class AuthenticationProcessor {
    public static final String CURRENT_AUTHENTICATION_EXECUTION = "current.authentication.execution";
    protected static final Logger logger = Logger.getLogger(AuthenticationProcessor.class);
    protected RealmModel realm;
    protected UserSessionModel userSession;
    protected ClientSessionModel clientSession;
    protected ClientConnection connection;
    protected UriInfo uriInfo;
    protected KeycloakSession session;
    protected EventBuilder event;
    protected HttpRequest request;
    protected String flowId;
    protected String flowPath;
    protected boolean browserFlow;
    protected BruteForceProtector protector;
    protected boolean oneActionWasSuccessful;
    protected FormMessage forwardedErrorMessage;
    protected FormMessage forwardedSuccessMessage;
    protected boolean userSessionCreated;
    protected ClientModel client;
    protected Map<String, String> clientAuthAttributes = new HashMap<String, String>();

    public boolean isBrowserFlow() {
        return this.browserFlow;
    }

    public AuthenticationProcessor setBrowserFlow(boolean browserFlow) {
        this.browserFlow = browserFlow;
        return this;
    }

    public BruteForceProtector getBruteForceProtector() {
        if (this.protector == null) {
            this.protector = (BruteForceProtector)this.session.getProvider(BruteForceProtector.class);
        }
        return this.protector;
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public ClientModel getClient() {
        return this.client;
    }

    public void setClient(ClientModel client) {
        this.client = client;
    }

    public Map<String, String> getClientAuthAttributes() {
        return this.clientAuthAttributes;
    }

    public ClientSessionModel getClientSession() {
        return this.clientSession;
    }

    public ClientConnection getConnection() {
        return this.connection;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public UserSessionModel getUserSession() {
        return this.userSession;
    }

    public boolean isUserSessionCreated() {
        return this.userSessionCreated;
    }

    public AuthenticationProcessor setRealm(RealmModel realm) {
        this.realm = realm;
        return this;
    }

    public AuthenticationProcessor setClientSession(ClientSessionModel clientSession) {
        this.clientSession = clientSession;
        return this;
    }

    public AuthenticationProcessor setConnection(ClientConnection connection) {
        this.connection = connection;
        return this;
    }

    public AuthenticationProcessor setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
        return this;
    }

    public AuthenticationProcessor setSession(KeycloakSession session) {
        this.session = session;
        return this;
    }

    public AuthenticationProcessor setEventBuilder(EventBuilder eventBuilder) {
        this.event = eventBuilder;
        return this;
    }

    public AuthenticationProcessor setRequest(HttpRequest request) {
        this.request = request;
        return this;
    }

    public AuthenticationProcessor setFlowId(String flowId) {
        this.flowId = flowId;
        return this;
    }

    public AuthenticationProcessor setFlowPath(String flowPath) {
        this.flowPath = flowPath;
        return this;
    }

    public AuthenticationProcessor setForwardedErrorMessage(FormMessage forwardedErrorMessage) {
        this.forwardedErrorMessage = forwardedErrorMessage;
        return this;
    }

    public AuthenticationProcessor setForwardedSuccessMessage(FormMessage forwardedSuccessMessage) {
        this.forwardedSuccessMessage = forwardedSuccessMessage;
        return this;
    }

    public String generateCode() {
        ClientSessionCode accessCode = new ClientSessionCode(this.session, this.getRealm(), this.getClientSession());
        this.clientSession.setTimestamp(Time.currentTime());
        return accessCode.getCode();
    }

    public EventBuilder newEvent() {
        this.event = new EventBuilder(this.realm, this.session, this.connection);
        return this.event;
    }

    public EventBuilder getEvent() {
        return this.event;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public void setAutheticatedUser(UserModel user) {
        UserModel previousUser = this.clientSession.getAuthenticatedUser();
        if (previousUser != null && !user.getId().equals(previousUser.getId())) {
            throw new AuthenticationFlowException(AuthenticationFlowError.USER_CONFLICT);
        }
        this.validateUser(user);
        this.getClientSession().setAuthenticatedUser(user);
    }

    public void clearAuthenticatedUser() {
        this.getClientSession().setAuthenticatedUser(null);
    }

    public void logFailure() {
        UserModel user;
        String username;
        if (this.realm.isBruteForceProtected() && (username = this.clientSession.getNote("ATTEMPTED_USERNAME")) != null && (user = KeycloakModelUtils.findUserByNameOrEmail((KeycloakSession)this.session, (RealmModel)this.realm, (String)username)) != null) {
            this.getBruteForceProtector().failedLogin(this.realm, user, this.connection);
        }
    }

    public boolean isSuccessful(AuthenticationExecutionModel model) {
        ClientSessionModel.ExecutionStatus status = (ClientSessionModel.ExecutionStatus)this.clientSession.getExecutionStatus().get(model.getId());
        if (status == null) {
            return false;
        }
        return status == ClientSessionModel.ExecutionStatus.SUCCESS;
    }

    public Response handleBrowserException(Exception failure) {
        if (failure instanceof AuthenticationFlowException) {
            AuthenticationFlowException e = (AuthenticationFlowException)failure;
            if (e.getError() == AuthenticationFlowError.INVALID_USER) {
                ServicesLogger.LOGGER.failedAuthentication((Throwable)e);
                this.event.error("user_not_found");
                return ErrorPage.error(this.session, "invalidUserMessage", new Object[0]);
            }
            if (e.getError() == AuthenticationFlowError.USER_DISABLED) {
                ServicesLogger.LOGGER.failedAuthentication((Throwable)e);
                this.event.error("user_disabled");
                return ErrorPage.error(this.session, "accountDisabledMessage", new Object[0]);
            }
            if (e.getError() == AuthenticationFlowError.USER_TEMPORARILY_DISABLED) {
                ServicesLogger.LOGGER.failedAuthentication((Throwable)e);
                this.event.error("user_temporarily_disabled");
                return ErrorPage.error(this.session, "invalidUserMessage", new Object[0]);
            }
            if (e.getError() == AuthenticationFlowError.INVALID_CLIENT_SESSION) {
                ServicesLogger.LOGGER.failedAuthentication((Throwable)e);
                this.event.error("invalid_code");
                return ErrorPage.error(this.session, "invalidCodeMessage", new Object[0]);
            }
            if (e.getError() == AuthenticationFlowError.EXPIRED_CODE) {
                ServicesLogger.LOGGER.failedAuthentication((Throwable)e);
                this.event.error("expired_code");
                return ErrorPage.error(this.session, "expiredCodeMessage", new Object[0]);
            }
            if (e.getError() == AuthenticationFlowError.FORK_FLOW) {
                ForkFlowException reset = (ForkFlowException)e;
                ClientSessionModel clone = AuthenticationProcessor.clone(this.session, this.clientSession);
                clone.setAction(ClientSessionModel.Action.AUTHENTICATE.name());
                AuthenticationProcessor processor = new AuthenticationProcessor();
                processor.setClientSession(clone).setFlowPath("authenticate").setFlowId(this.realm.getBrowserFlow().getId()).setForwardedErrorMessage(reset.getErrorMessage()).setForwardedSuccessMessage(reset.getSuccessMessage()).setConnection(this.connection).setEventBuilder(this.event).setRealm(this.realm).setBrowserFlow(this.isBrowserFlow()).setSession(this.session).setUriInfo(this.uriInfo).setRequest(this.request);
                CacheControlUtil.noBackButtonCacheControlHeader();
                return processor.authenticate();
            }
            ServicesLogger.LOGGER.failedAuthentication((Throwable)e);
            this.event.error("invalid_user_credentials");
            return ErrorPage.error(this.session, "invalidUserMessage", new Object[0]);
        }
        ServicesLogger.LOGGER.failedAuthentication(failure);
        this.event.error("invalid_user_credentials");
        return ErrorPage.error(this.session, "unexpectedErrorHandlingRequestMessage", new Object[0]);
    }

    public Response handleClientAuthException(Exception failure) {
        if (failure instanceof AuthenticationFlowException) {
            AuthenticationFlowException e = (AuthenticationFlowException)failure;
            ServicesLogger.LOGGER.failedClientAuthentication((Throwable)e);
            if (e.getError() == AuthenticationFlowError.CLIENT_NOT_FOUND) {
                this.event.error("client_not_found");
                return ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "invalid_client", "Could not find client");
            }
            if (e.getError() == AuthenticationFlowError.CLIENT_DISABLED) {
                this.event.error("client_disabled");
                return ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "invalid_client", "Client is not enabled");
            }
            if (e.getError() == AuthenticationFlowError.CLIENT_CREDENTIALS_SETUP_REQUIRED) {
                this.event.error("invalid_client_credentials");
                return ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "unauthorized_client", e.getMessage());
            }
            this.event.error("invalid_client_credentials");
            return ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "unauthorized_client", e.getError().toString() + ": " + e.getMessage());
        }
        ServicesLogger.LOGGER.errorAuthenticatingClient(failure);
        this.event.error("invalid_client_credentials");
        return ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "unauthorized_client", "Unexpected error when authenticating client: " + failure.getMessage());
    }

    public AuthenticationFlow createFlowExecution(String flowId, AuthenticationExecutionModel execution) {
        AuthenticationFlowModel flow = this.realm.getAuthenticationFlowById(flowId);
        if (flow == null) {
            logger.error((Object)"Unknown flow to execute with");
            throw new AuthenticationFlowException(AuthenticationFlowError.INTERNAL_ERROR);
        }
        if (flow.getProviderId() == null || flow.getProviderId().equals("basic-flow")) {
            DefaultAuthenticationFlow flowExecution = new DefaultAuthenticationFlow(this, flow);
            return flowExecution;
        }
        if (flow.getProviderId().equals("form-flow")) {
            FormAuthenticationFlow flowExecution = new FormAuthenticationFlow(this, execution);
            return flowExecution;
        }
        if (flow.getProviderId().equals("client-flow")) {
            ClientAuthenticationFlow flowExecution = new ClientAuthenticationFlow(this, flow);
            return flowExecution;
        }
        throw new AuthenticationFlowException("Unknown flow provider type", AuthenticationFlowError.INTERNAL_ERROR);
    }

    public Response authenticate() throws AuthenticationFlowException {
        logger.debug((Object)"AUTHENTICATE");
        Response challenge = this.authenticateOnly();
        if (challenge != null) {
            return challenge;
        }
        return this.authenticationComplete();
    }

    public Response authenticateClient() throws AuthenticationFlowException {
        logger.debug((Object)"AUTHENTICATE CLIENT");
        AuthenticationFlow authenticationFlow = this.createFlowExecution(this.flowId, null);
        try {
            Response challenge = authenticationFlow.processFlow();
            return challenge;
        }
        catch (Exception e) {
            return this.handleClientAuthException(e);
        }
    }

    public Response redirectToFlow() {
        String code = this.generateCode();
        URI redirect = LoginActionsService.loginActionsBaseUrl(this.getUriInfo()).path(this.flowPath).queryParam("code", new Object[]{code}).build(new Object[]{this.getRealm().getName()});
        return Response.status((int)302).location(redirect).build();
    }

    public static Response redirectToRequiredActions(KeycloakSession session, RealmModel realm, ClientSessionModel clientSession, UriInfo uriInfo) {
        ClientSessionCode accessCode = new ClientSessionCode(session, realm, clientSession);
        accessCode.setAction(ClientSessionModel.Action.REQUIRED_ACTIONS.name());
        clientSession.setTimestamp(Time.currentTime());
        URI redirect = LoginActionsService.loginActionsBaseUrl(uriInfo).path("required-action").queryParam("code", new Object[]{accessCode.getCode()}).build(new Object[]{realm.getName()});
        return Response.status((int)302).location(redirect).build();
    }

    public static void resetFlow(ClientSessionModel clientSession) {
        logger.debug((Object)"RESET FLOW");
        clientSession.setTimestamp(Time.currentTime());
        clientSession.setAuthenticatedUser(null);
        clientSession.clearExecutionStatus();
        clientSession.clearUserSessionNotes();
        clientSession.removeNote(CURRENT_AUTHENTICATION_EXECUTION);
    }

    public static ClientSessionModel clone(KeycloakSession session, ClientSessionModel clientSession) {
        ClientSessionModel clone = session.sessions().createClientSession(clientSession.getRealm(), clientSession.getClient());
        for (Map.Entry entry : clientSession.getNotes().entrySet()) {
            clone.setNote((String)entry.getKey(), (String)entry.getValue());
        }
        clone.setRedirectUri(clientSession.getRedirectUri());
        clone.setAuthMethod(clientSession.getAuthMethod());
        clone.setTimestamp(Time.currentTime());
        clone.removeNote(CURRENT_AUTHENTICATION_EXECUTION);
        return clone;
    }

    public Response authenticationAction(String execution) {
        AuthenticationFlow authenticationFlow;
        Response challenge;
        logger.debug((Object)"authenticationAction");
        this.checkClientSession();
        String current = this.clientSession.getNote(CURRENT_AUTHENTICATION_EXECUTION);
        if (!execution.equals(current)) {
            logger.debug((Object)"Current execution does not equal executed execution.  Might be a page refresh");
            return this.authenticate();
        }
        UserModel authUser = this.clientSession.getAuthenticatedUser();
        this.validateUser(authUser);
        AuthenticationExecutionModel model = this.realm.getAuthenticationExecutionById(execution);
        if (model == null) {
            logger.debug((Object)"Cannot find execution, reseting flow");
            this.logFailure();
            AuthenticationProcessor.resetFlow(this.clientSession);
            return this.authenticate();
        }
        this.event.client(this.clientSession.getClient().getClientId()).detail("redirect_uri", this.clientSession.getRedirectUri()).detail("auth_method", this.clientSession.getAuthMethod());
        String authType = this.clientSession.getNote("auth_type");
        if (authType != null) {
            this.event.detail("auth_type", authType);
        }
        if ((challenge = (authenticationFlow = this.createFlowExecution(this.flowId, model)).processAction(execution)) != null) {
            return challenge;
        }
        if (this.clientSession.getAuthenticatedUser() == null) {
            throw new AuthenticationFlowException(AuthenticationFlowError.UNKNOWN_USER);
        }
        return this.authenticationComplete();
    }

    public void checkClientSession() {
        ClientSessionCode code = new ClientSessionCode(this.session, this.realm, this.clientSession);
        String action = ClientSessionModel.Action.AUTHENTICATE.name();
        if (!code.isValidAction(action)) {
            throw new AuthenticationFlowException(AuthenticationFlowError.INVALID_CLIENT_SESSION);
        }
        if (!code.isActionActive(ClientSessionCode.ActionType.LOGIN)) {
            throw new AuthenticationFlowException(AuthenticationFlowError.EXPIRED_CODE);
        }
        this.clientSession.setTimestamp(Time.currentTime());
    }

    public Response authenticateOnly() throws AuthenticationFlowException {
        logger.debug((Object)"AUTHENTICATE ONLY");
        this.checkClientSession();
        this.event.client(this.clientSession.getClient().getClientId()).detail("redirect_uri", this.clientSession.getRedirectUri()).detail("auth_method", this.clientSession.getAuthMethod());
        String authType = this.clientSession.getNote("auth_type");
        if (authType != null) {
            this.event.detail("auth_type", authType);
        }
        UserModel authUser = this.clientSession.getAuthenticatedUser();
        this.validateUser(authUser);
        AuthenticationFlow authenticationFlow = this.createFlowExecution(this.flowId, null);
        Response challenge = authenticationFlow.processFlow();
        if (challenge != null) {
            return challenge;
        }
        if (this.clientSession.getAuthenticatedUser() == null) {
            throw new AuthenticationFlowException(AuthenticationFlowError.UNKNOWN_USER);
        }
        return challenge;
    }

    public void setActionSuccessful() {
        this.oneActionWasSuccessful = true;
    }

    public Response checkWasSuccessfulBrowserAction() {
        if (this.oneActionWasSuccessful && this.isBrowserFlow()) {
            String code = this.generateCode();
            URI redirect = LoginActionsService.loginActionsBaseUrl(this.getUriInfo()).path(this.flowPath).queryParam("code", new Object[]{code}).build(new Object[]{this.getRealm().getName()});
            return Response.status((int)302).location(redirect).build();
        }
        return null;
    }

    public void attachSession() {
        String rememberMe;
        boolean remember;
        String username = this.clientSession.getAuthenticatedUser().getUsername();
        String attemptedUsername = this.clientSession.getNote("ATTEMPTED_USERNAME");
        if (attemptedUsername != null) {
            username = attemptedUsername;
        }
        boolean bl = remember = (rememberMe = this.clientSession.getNote("remember_me")) != null && rememberMe.equalsIgnoreCase("true");
        if (this.userSession == null) {
            this.userSession = this.session.sessions().createUserSession(this.realm, this.clientSession.getAuthenticatedUser(), username, this.connection.getRemoteAddr(), this.clientSession.getAuthMethod(), remember, null, null);
            this.userSession.setState(UserSessionModel.State.LOGGING_IN);
            this.userSessionCreated = true;
        }
        if (remember) {
            this.event.detail("remember_me", "true");
        }
        TokenManager.attachClientSession(this.userSession, this.clientSession);
        this.event.user(this.userSession.getUser()).detail("username", username).session(this.userSession);
    }

    public void evaluateRequiredActionTriggers() {
        AuthenticationManager.evaluateRequiredActionTriggers(this.session, this.userSession, this.clientSession, this.connection, this.request, this.uriInfo, this.event, this.realm, this.clientSession.getAuthenticatedUser());
    }

    public Response finishAuthentication(LoginProtocol protocol) {
        this.event.success();
        RealmModel realm = this.clientSession.getRealm();
        return AuthenticationManager.redirectAfterSuccessfulFlow(this.session, realm, this.userSession, this.clientSession, this.request, this.uriInfo, this.connection, this.event, protocol);
    }

    public void validateUser(UserModel authenticatedUser) {
        if (authenticatedUser == null) {
            return;
        }
        if (!authenticatedUser.isEnabled()) {
            throw new AuthenticationFlowException(AuthenticationFlowError.USER_DISABLED);
        }
        if (this.realm.isBruteForceProtected() && this.getBruteForceProtector().isTemporarilyDisabled(this.session, this.realm, authenticatedUser)) {
            throw new AuthenticationFlowException(AuthenticationFlowError.USER_TEMPORARILY_DISABLED);
        }
    }

    protected Response authenticationComplete() {
        this.attachSession();
        if (this.isActionRequired()) {
            return AuthenticationProcessor.redirectToRequiredActions(this.session, this.realm, this.clientSession, this.uriInfo);
        }
        this.event.detail("code_id", this.clientSession.getId());
        return AuthenticationManager.finishedRequiredActions(this.session, this.userSession, this.clientSession, this.connection, this.request, this.uriInfo, this.event);
    }

    public boolean isActionRequired() {
        return AuthenticationManager.isActionRequired(this.session, this.userSession, this.clientSession, this.connection, this.request, this.uriInfo, this.event);
    }

    public Result createAuthenticatorContext(AuthenticationExecutionModel model, Authenticator authenticator, List<AuthenticationExecutionModel> executions) {
        return new Result(model, authenticator, executions);
    }

    public Result createClientAuthenticatorContext(AuthenticationExecutionModel model, ClientAuthenticator clientAuthenticator, List<AuthenticationExecutionModel> executions) {
        return new Result(model, clientAuthenticator, executions);
    }

    public class Result
    implements AuthenticationFlowContext,
    ClientAuthenticationFlowContext {
        AuthenticatorConfigModel authenticatorConfig;
        AuthenticationExecutionModel execution;
        Authenticator authenticator;
        FlowStatus status;
        ClientAuthenticator clientAuthenticator;
        Response challenge;
        AuthenticationFlowError error;
        List<AuthenticationExecutionModel> currentExecutions;
        FormMessage errorMessage;
        FormMessage successMessage;

        private Result(AuthenticationExecutionModel execution, Authenticator authenticator, List<AuthenticationExecutionModel> currentExecutions) {
            this.execution = execution;
            this.authenticator = authenticator;
            this.currentExecutions = currentExecutions;
        }

        private Result(AuthenticationExecutionModel execution, ClientAuthenticator clientAuthenticator, List<AuthenticationExecutionModel> currentExecutions) {
            this.execution = execution;
            this.clientAuthenticator = clientAuthenticator;
            this.currentExecutions = currentExecutions;
        }

        public EventBuilder newEvent() {
            return AuthenticationProcessor.this.newEvent();
        }

        public AuthenticationExecutionModel.Requirement getCategoryRequirementFromCurrentFlow(String authenticatorCategory) {
            List executions = AuthenticationProcessor.this.realm.getAuthenticationExecutions(this.execution.getParentFlow());
            for (AuthenticationExecutionModel exe : executions) {
                AuthenticatorFactory factory = (AuthenticatorFactory)this.getSession().getKeycloakSessionFactory().getProviderFactory(Authenticator.class, exe.getAuthenticator());
                if (factory == null || !factory.getReferenceCategory().equals(authenticatorCategory)) continue;
                return exe.getRequirement();
            }
            return null;
        }

        public AuthenticationExecutionModel getExecution() {
            return this.execution;
        }

        public AuthenticatorConfigModel getAuthenticatorConfig() {
            if (this.execution.getAuthenticatorConfig() == null) {
                return null;
            }
            if (this.authenticatorConfig != null) {
                return this.authenticatorConfig;
            }
            this.authenticatorConfig = AuthenticationProcessor.this.realm.getAuthenticatorConfigById(this.execution.getAuthenticatorConfig());
            return this.authenticatorConfig;
        }

        public Authenticator getAuthenticator() {
            return this.authenticator;
        }

        public FlowStatus getStatus() {
            return this.status;
        }

        public ClientAuthenticator getClientAuthenticator() {
            return this.clientAuthenticator;
        }

        public void success() {
            this.status = FlowStatus.SUCCESS;
        }

        public void failure(AuthenticationFlowError error) {
            this.status = FlowStatus.FAILED;
            this.error = error;
        }

        public void challenge(Response challenge) {
            this.status = FlowStatus.CHALLENGE;
            this.challenge = challenge;
        }

        public void forceChallenge(Response challenge) {
            this.status = FlowStatus.FORCE_CHALLENGE;
            this.challenge = challenge;
        }

        public void failureChallenge(AuthenticationFlowError error, Response challenge) {
            this.error = error;
            this.status = FlowStatus.FAILURE_CHALLENGE;
            this.challenge = challenge;
        }

        public void failure(AuthenticationFlowError error, Response challenge) {
            this.error = error;
            this.status = FlowStatus.FAILED;
            this.challenge = challenge;
        }

        public void attempted() {
            this.status = FlowStatus.ATTEMPTED;
        }

        public UserModel getUser() {
            return this.getClientSession().getAuthenticatedUser();
        }

        public void setUser(UserModel user) {
            AuthenticationProcessor.this.setAutheticatedUser(user);
        }

        public void clearUser() {
            AuthenticationProcessor.this.clearAuthenticatedUser();
        }

        public RealmModel getRealm() {
            return AuthenticationProcessor.this.getRealm();
        }

        public ClientModel getClient() {
            return AuthenticationProcessor.this.getClient();
        }

        public void setClient(ClientModel client) {
            AuthenticationProcessor.this.setClient(client);
        }

        public Map<String, String> getClientAuthAttributes() {
            return AuthenticationProcessor.this.getClientAuthAttributes();
        }

        public ClientSessionModel getClientSession() {
            return AuthenticationProcessor.this.getClientSession();
        }

        public ClientConnection getConnection() {
            return AuthenticationProcessor.this.getConnection();
        }

        public UriInfo getUriInfo() {
            return AuthenticationProcessor.this.getUriInfo();
        }

        public KeycloakSession getSession() {
            return AuthenticationProcessor.this.getSession();
        }

        public HttpRequest getHttpRequest() {
            return AuthenticationProcessor.this.request;
        }

        public void attachUserSession(UserSessionModel userSession) {
            AuthenticationProcessor.this.userSession = userSession;
        }

        public BruteForceProtector getProtector() {
            return AuthenticationProcessor.this.getBruteForceProtector();
        }

        public EventBuilder getEvent() {
            return AuthenticationProcessor.this.event;
        }

        public FormMessage getForwardedErrorMessage() {
            return AuthenticationProcessor.this.forwardedErrorMessage;
        }

        public String generateAccessCode() {
            return AuthenticationProcessor.this.generateCode();
        }

        public Response getChallenge() {
            return this.challenge;
        }

        public AuthenticationFlowError getError() {
            return this.error;
        }

        public LoginFormsProvider form() {
            String accessCode = this.generateAccessCode();
            URI action = this.getActionUrl(accessCode);
            LoginFormsProvider provider = ((LoginFormsProvider)this.getSession().getProvider(LoginFormsProvider.class)).setUser(this.getUser()).setActionUri(action).setFormData(AuthenticationProcessor.this.request.getDecodedFormParameters()).setClientSessionCode(accessCode);
            if (this.getForwardedErrorMessage() != null) {
                provider.addError(this.getForwardedErrorMessage());
            } else if (this.getForwardedSuccessMessage() != null) {
                provider.addSuccess(this.getForwardedSuccessMessage());
            }
            return provider;
        }

        public URI getActionUrl(String code) {
            return LoginActionsService.loginActionsBaseUrl(this.getUriInfo()).path(AuthenticationProcessor.this.flowPath).queryParam("code", new Object[]{code}).queryParam("execution", new Object[]{this.getExecution().getId()}).build(new Object[]{this.getRealm().getName()});
        }

        public URI getActionUrl() {
            return this.getActionUrl(this.generateAccessCode());
        }

        public void cancelLogin() {
            this.getEvent().error("rejected_by_user");
            LoginProtocol protocol = (LoginProtocol)this.getSession().getProvider(LoginProtocol.class, this.getClientSession().getAuthMethod());
            protocol.setRealm(this.getRealm()).setHttpHeaders(this.getHttpRequest().getHttpHeaders()).setUriInfo(this.getUriInfo()).setEventBuilder(AuthenticationProcessor.this.event);
            Response response = protocol.sendError(this.getClientSession(), LoginProtocol.Error.CANCELLED_BY_USER);
            this.forceChallenge(response);
        }

        public void resetFlow() {
            this.status = FlowStatus.FLOW_RESET;
        }

        public void fork() {
            this.status = FlowStatus.FORK;
        }

        public void forkWithSuccessMessage(FormMessage message) {
            this.status = FlowStatus.FORK;
            this.successMessage = message;
        }

        public void forkWithErrorMessage(FormMessage message) {
            this.status = FlowStatus.FORK;
            this.errorMessage = message;
        }

        public FormMessage getForwardedSuccessMessage() {
            return AuthenticationProcessor.this.forwardedSuccessMessage;
        }

        public FormMessage getErrorMessage() {
            return this.errorMessage;
        }

        public FormMessage getSuccessMessage() {
            return this.successMessage;
        }
    }
}

