/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.clustering.controller.CapabilityDependency;
import org.jboss.as.clustering.controller.RequiredCapability;
import org.jboss.as.clustering.controller.Requirement;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.service.ProtocolStackServiceName;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.ValueDependency;

public abstract class AbstractProtocolConfigurationBuilder<P extends ProtocolConfiguration>
implements ResourceServiceBuilder<P>,
Value<P>,
ProtocolConfiguration {
    private final String stackName;
    private final String name;
    private final Map<String, String> properties = new HashMap<String, String>();
    private ModuleIdentifier module = ProtocolConfiguration.DEFAULT_MODULE;
    private ValueDependency<SocketBinding> socketBinding;

    public AbstractProtocolConfigurationBuilder(String stackName, String name) {
        this.stackName = stackName;
        this.name = name;
    }

    public ServiceName getServiceName() {
        return ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(this.stackName).append(new String[]{this.name});
    }

    public ServiceBuilder<P> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new ValueService((Value)this));
        if (this.socketBinding != null) {
            this.socketBinding.register(builder);
        }
        return builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public Builder<P> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.module = ModelNodes.asModuleIdentifier((ModelNode)ProtocolResourceDefinition.Attribute.MODULE.getDefinition().resolveModelAttribute(context, model));
        String binding = ModelNodes.asString((ModelNode)ProtocolResourceDefinition.Attribute.SOCKET_BINDING.getDefinition().resolveModelAttribute(context, model));
        if (binding != null) {
            this.socketBinding = new CapabilityDependency(context, (Requirement)RequiredCapability.SOCKET_BINDING, binding, SocketBinding.class);
        }
        for (Property property : ModelNodes.asPropertyList((ModelNode)ProtocolResourceDefinition.Attribute.PROPERTIES.getDefinition().resolveModelAttribute(context, model))) {
            this.properties.put(property.getName(), property.getValue().asString());
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getProtocolClassName() {
        StringBuilder builder = new StringBuilder();
        if (this.module.equals(ProtocolConfiguration.DEFAULT_MODULE) && !this.name.startsWith("org.jgroups.protocols")) {
            builder.append("org.jgroups.protocols").append('.');
        }
        return builder.append(this.name).toString();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public SocketBinding getSocketBinding() {
        return this.socketBinding != null ? (SocketBinding)this.socketBinding.getValue() : null;
    }

    public ModuleIdentifier getModule() {
        return this.module;
    }
}

