/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.GroupCommandDefinition;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandException;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.keycloak.client.registration.cli.commands.AbstractAuthOptionsCmd;
import org.keycloak.client.registration.cli.commands.ConfigCredentialsCmd;
import org.keycloak.client.registration.cli.commands.ConfigInitialTokenCmd;
import org.keycloak.client.registration.cli.commands.ConfigRegistrationTokenCmd;
import org.keycloak.client.registration.cli.commands.ConfigTruststoreCmd;
import org.keycloak.client.registration.cli.util.OsUtil;

@GroupCommandDefinition(name="config", description="COMMAND [ARGUMENTS]", groupCommands={ConfigCredentialsCmd.class})
public class ConfigCmd
extends AbstractAuthOptionsCmd
implements Command {
    @Arguments
    protected List<String> args;

    public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        try {
            String cmd;
            if (this.args == null || this.args.size() == 0) {
                if (this.printHelp()) {
                    CommandResult commandResult = CommandResult.SUCCESS;
                    return commandResult;
                }
                throw new RuntimeException("Sub-command required by '" + OsUtil.CMD + " config' - one of: 'credentials', 'truststore', 'initial-token', 'registration-token'");
            }
            switch (cmd = this.args.get(0)) {
                case "credentials": {
                    CommandResult commandResult = new ConfigCredentialsCmd(this).execute(commandInvocation);
                    return commandResult;
                }
                case "truststore": {
                    CommandResult commandResult = new ConfigTruststoreCmd(this).execute(commandInvocation);
                    return commandResult;
                }
                case "initial-token": {
                    CommandResult commandResult = new ConfigInitialTokenCmd(this).execute(commandInvocation);
                    return commandResult;
                }
                case "registration-token": {
                    CommandResult commandResult = new ConfigRegistrationTokenCmd(this).execute(commandInvocation);
                    return commandResult;
                }
            }
            if (this.printHelp()) {
                CommandResult commandResult = CommandResult.SUCCESS;
                return commandResult;
            }
            throw new RuntimeException("Unknown sub-command: " + cmd);
        }
        finally {
            commandInvocation.stop();
        }
    }

    @Override
    protected String help() {
        return ConfigCmd.usage();
    }

    public static String usage() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + OsUtil.CMD + " config SUB_COMMAND [ARGUMENTS]");
        out.println();
        out.println("Where SUB_COMMAND is one of: 'credentials', 'truststore', 'initial-token', 'registration-token'");
        out.println();
        out.println();
        out.println("Use '" + OsUtil.CMD + " help config SUB_COMMAND' for more info.");
        out.println("Use '" + OsUtil.CMD + " help' for general information and a list of commands.");
        return sb.toString();
    }
}

