/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.addressRewrite;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.wsf.stack.cxf.addressRewrite.CharMap;
import org.jboss.wsf.stack.cxf.addressRewrite.SedArguments;

final class SEDProcessor {
    private static final int[] EMPTY_OCCURRENCE = new int[0];
    private final SEDCommand command;
    private final String replacement;
    private final int[] occurrences;
    private final Pattern regexp;
    private final SedArguments args;
    private final CharMap charMap;

    private SEDProcessor(String script, SEDCommand command) {
        this.command = command;
        this.args = this.deriveArgs(script);
        this.regexp = this.args.isIgnoreCase() ? Pattern.compile(SEDProcessor.getRegexp(this.args), 2) : Pattern.compile(SEDProcessor.getRegexp(this.args));
        this.replacement = SEDProcessor.getReplacement(this.args);
        this.occurrences = this.args.isOccurrenceSet() ? this.args.getOccurrence() : EMPTY_OCCURRENCE;
        for (int i = 0; i < this.occurrences.length; ++i) {
            if (this.occurrences[i] > 0) continue;
            throw new IllegalArgumentException("invalid occurrence index " + this.occurrences[i] + " in sed command");
        }
        Arrays.sort(this.occurrences);
        this.charMap = command == SEDCommand.TRANSLATE ? new CharMap(this.args.getString1(), this.args.getString2()) : null;
    }

    private static String getRegexp(SedArguments args) {
        if (args.isRegexpSet()) {
            return args.getRegexp();
        }
        if (args.isString1Set()) {
            return args.getString1();
        }
        return "";
    }

    private static String getReplacement(SedArguments args) {
        if (args.isReplacementSet()) {
            return args.getReplacement();
        }
        if (args.isString2Set()) {
            return args.getString2();
        }
        return "";
    }

    private SedArguments deriveArgs(String script) {
        int start = SEDProcessor.findStartTrimWhitespace(script) + 1;
        int mid = SEDProcessor.indexOfNextDelimiter(script, start);
        int end = SEDProcessor.indexOfNextDelimiter(script, mid);
        if (mid < 0 || end < 0) {
            throw new IllegalArgumentException("invalid script for sed command: " + script);
        }
        if (this.command == SEDCommand.SUBSTITUTE) {
            SedArguments args = SEDProcessor.parseSubstituteFlags(script, end + 1);
            args.setRegexp(script.substring(start + 1, mid));
            args.setReplacement(script.substring(mid + 1, end));
            return args;
        }
        if (this.command == SEDCommand.TRANSLATE) {
            SedArguments args = new SedArguments();
            args.setScript(script);
            args.setTranslate(true);
            int scriptEnd = SEDProcessor.findEndTrimWhitespace(script);
            if (end + 1 < scriptEnd) {
                throw new IllegalArgumentException("non-whitespace characters found after " + (Object)((Object)this.command) + " command in sed script: " + script);
            }
            args.setString1(script.substring(start + 1, mid));
            args.setString2(script.substring(mid + 1, end));
            return args;
        }
        throw new IllegalStateException();
    }

    private static SedArguments parseSubstituteFlags(String script, int start) {
        int end = SEDProcessor.findWhitespace(script, start);
        if (end < SEDProcessor.findEndTrimWhitespace(script)) {
            throw new IllegalArgumentException("extra non-whitespace characters found after substitute command in sed script: " + script);
        }
        SedArguments args = new SedArguments();
        args.setScript(script);
        args.setSubstitute(true);
        if (start < end) {
            int index;
            for (index = end - 1; index >= start; --index) {
                char flag = script.charAt(index);
                if (flag == 'g') {
                    args.setGlobal(true);
                    continue;
                }
                if (flag != 'I') break;
                args.setIgnoreCase(true);
            }
            if (index >= start) {
                int occurrence;
                String occurrenceStr = script.substring(start, index + 1);
                try {
                    occurrence = Integer.parseInt(occurrenceStr);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("invalid substitute flags in sed script: " + script, e);
                }
                if (occurrence <= 0) {
                    throw new IllegalArgumentException("invalid occurrence index " + occurrence + " in sed script: " + script);
                }
                args.setOccurrence(occurrence);
            }
        }
        return args;
    }

    public String processLine(String line) {
        if (this.command == SEDCommand.SUBSTITUTE) {
            Matcher matcher = this.regexp.matcher(line);
            if (matcher.find()) {
                boolean matches = true;
                StringBuffer changed = new StringBuffer();
                if (this.occurrences.length > 0) {
                    int current = 1;
                    for (int i = 0; i < this.occurrences.length; ++i) {
                        int occurrence = this.occurrences[i];
                        while (matches && current < occurrence) {
                            matches = matcher.find();
                            ++current;
                        }
                        if (!matches) break;
                        matcher.appendReplacement(changed, this.replacement);
                    }
                    if (matches && this.occurrences.length == 1 && this.args.isGlobal()) {
                        matches = matcher.find();
                        while (matches) {
                            matcher.appendReplacement(changed, this.replacement);
                            matches = matcher.find();
                        }
                    }
                } else {
                    while (matches) {
                        matcher.appendReplacement(changed, this.replacement);
                        matches = this.args.isGlobal() && matcher.find();
                    }
                }
                matcher.appendTail(changed);
                return changed.toString();
            }
            return line;
        }
        if (this.command == SEDCommand.TRANSLATE) {
            char[] changed = null;
            int len = line.length();
            for (int i = 0; i < len; ++i) {
                char src = line.charAt(i);
                char dst = this.charMap.map(src);
                if (dst != '\u0000') {
                    if (changed == null) {
                        changed = new char[len];
                        for (int j = 0; j < i; ++j) {
                            changed[j] = line.charAt(j);
                        }
                    }
                    changed[i] = dst;
                    continue;
                }
                if (changed == null) continue;
                changed[i] = src;
            }
            return changed != null ? String.valueOf(changed) : line;
        }
        return null;
    }

    private static int indexOfNextDelimiter(String script, int indexOfPreviousDelimiter) {
        if (indexOfPreviousDelimiter < 0 || script.length() <= indexOfPreviousDelimiter) {
            return -1;
        }
        char delim = script.charAt(indexOfPreviousDelimiter);
        if (delim == '\\') {
            throw new IllegalArgumentException("invalid delimiter '\\' in sed script: " + script);
        }
        int index = indexOfPreviousDelimiter;
        while ((index = script.indexOf(delim, index + 1)) >= 0 && SEDProcessor.isEscaped(script, index)) {
        }
        return index;
    }

    private static boolean isEscaped(String script, int index) {
        int backslashCount = 0;
        --index;
        while (index >= 0 && script.charAt(index) == '\\') {
            ++backslashCount;
            --index;
        }
        return backslashCount % 2 == 1;
    }

    private static int findStartTrimWhitespace(CharSequence s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return i;
        }
        return len;
    }

    private static int findWhitespace(CharSequence s, int start) {
        int len = s.length();
        for (int i = start; i < len; ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return i;
        }
        return len;
    }

    private static int findEndTrimWhitespace(CharSequence s) {
        for (int i = s.length(); i > 0; --i) {
            if (Character.isWhitespace(s.charAt(i - 1))) continue;
            return i;
        }
        return 0;
    }

    public static SEDProcessor newInstance(String script) {
        int len = script.length();
        int scriptStart = SEDProcessor.findStartTrimWhitespace(script);
        if (scriptStart < len) {
            char firstChar = script.charAt(scriptStart);
            if (firstChar == 's') {
                return new SEDProcessor(script, SEDCommand.SUBSTITUTE);
            }
            if (firstChar == 'y') {
                return new SEDProcessor(script, SEDCommand.TRANSLATE);
            }
        }
        throw new IllegalArgumentException("invalid script");
    }

    private static enum SEDCommand {
        SUBSTITUTE,
        TRANSLATE;

    }
}

