/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostModelUtil;
import org.jboss.as.host.controller.discovery.DiscoveryOptionsResource;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.RootPlatformMBeanResource;
import org.jboss.as.version.Version;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.ModuleClassLoader;

public class HostModelRegistrationHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "register-host-model";
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("register-host-model", null).setPrivateEntry().build();
    private final HostControllerEnvironment hostControllerEnvironment;
    private final IgnoredDomainResourceRegistry ignoredDomainResourceRegistry;
    private final HostModelUtil.HostModelRegistrar hostModelRegistrar;
    private final Resource modelControllerResource;

    public HostModelRegistrationHandler(HostControllerEnvironment hostControllerEnvironment, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry, HostModelUtil.HostModelRegistrar hostModelRegistrar, Resource modelControllerResource) {
        this.hostControllerEnvironment = hostControllerEnvironment;
        this.ignoredDomainResourceRegistry = ignoredDomainResourceRegistry;
        this.hostModelRegistrar = hostModelRegistrar;
        this.modelControllerResource = modelControllerResource;
    }

    public void execute(OperationContext context, ModelNode operation) {
        if (!context.isBooting()) {
            throw HostControllerLogger.ROOT_LOGGER.invocationNotAllowedAfterBoot(OPERATION_NAME);
        }
        String hostName = operation.require("name").asString();
        ManagementResourceRegistration rootRegistration = context.getResourceRegistrationForUpdate();
        this.hostModelRegistrar.registerHostModel(hostName, rootRegistration);
        PathAddress hostAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)hostName)});
        Resource rootResource = context.createResource(hostAddress);
        ModelNode model = rootResource.getModel();
        HostModelRegistrationHandler.initCoreModel(model, this.hostControllerEnvironment);
        Resource management = context.createResource(hostAddress.append(new PathElement[]{PathElement.pathElement((String)"core-service", (String)"management")}));
        if (this.modelControllerResource != null) {
            management.registerChild(PathElement.pathElement((String)"service", (String)"management-operations"), this.modelControllerResource);
        }
        context.addResource(hostAddress.append(new PathElement[]{PathElement.pathElement((String)"core-service", (String)"host-environment")}), (Resource)PlaceholderResource.INSTANCE);
        rootResource.registerChild(PathElement.pathElement((String)"core-service", (String)"module-loading"), (Resource)PlaceholderResource.INSTANCE);
        rootResource.registerChild(PlatformMBeanConstants.ROOT_PATH, (Resource)new RootPlatformMBeanResource());
        Resource.ResourceEntry ignoredRoot = this.ignoredDomainResourceRegistry.getRootResource();
        rootResource.registerChild(ignoredRoot.getPathElement(), (Resource)ignoredRoot);
        context.addResource(hostAddress.append(new PathElement[]{PathElement.pathElement((String)"core-service", (String)"discovery-options")}), (Resource)new DiscoveryOptionsResource());
    }

    private static void initCoreModel(ModelNode root, HostControllerEnvironment environment) {
        block5: {
            try {
                root.get("release-version").set(Version.AS_VERSION);
                root.get("release-codename").set(Version.AS_RELEASE_CODENAME);
            }
            catch (RuntimeException e) {
                if (!(HostModelRegistrationHandler.class.getClassLoader() instanceof ModuleClassLoader)) break block5;
                throw e;
            }
        }
        root.get("management-major-version").set(4);
        root.get("management-minor-version").set(0);
        root.get("management-micro-version").set(0);
        ModelNode nameNode = root.get("product-name");
        ModelNode versionNode = root.get("product-version");
        if (environment != null) {
            String productName = environment.getProductConfig().getProductName();
            String productVersion = environment.getProductConfig().getProductVersion();
            if (productName != null) {
                nameNode.set(productName);
            }
            if (productVersion != null) {
                versionNode.set(productVersion);
            }
        }
        root.get("namespaces").setEmptyList();
        root.get("schema-locations").setEmptyList();
    }
}

