/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import org.keycloak.keys.KeyMetadata;
import org.keycloak.models.RealmModel;

public interface KeyManager {
    public ActiveKey getActiveKey(RealmModel var1);

    public PublicKey getPublicKey(RealmModel var1, String var2);

    public Certificate getCertificate(RealmModel var1, String var2);

    public List<KeyMetadata> getKeys(RealmModel var1, boolean var2);

    public static class ActiveKey {
        private final String kid;
        private final PrivateKey privateKey;
        private final PublicKey publicKey;
        private final X509Certificate certificate;

        public ActiveKey(String kid, PrivateKey privateKey, PublicKey publicKey, X509Certificate certificate) {
            this.kid = kid;
            this.privateKey = privateKey;
            this.publicKey = publicKey;
            this.certificate = certificate;
        }

        public String getKid() {
            return this.kid;
        }

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public PublicKey getPublicKey() {
            return this.publicKey;
        }

        public X509Certificate getCertificate() {
            return this.certificate;
        }
    }
}

