/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc.mappers;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.broker.oidc.mappers.AbstractClaimMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderConfigProperty;

public class UserAttributeMapper
extends AbstractClaimMapper {
    public static final String[] COMPATIBLE_PROVIDERS = new String[]{"keycloak-oidc", "oidc"};
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String USER_ATTRIBUTE = "user.attribute";
    public static final String PROVIDER_ID = "oidc-user-attribute-idp-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String[] getCompatibleProviders() {
        return COMPATIBLE_PROVIDERS;
    }

    public String getDisplayCategory() {
        return "Attribute Importer";
    }

    public String getDisplayType() {
        return "Attribute Importer";
    }

    public void preprocessFederatedIdentity(KeycloakSession session, RealmModel realm, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String attribute = (String)mapperModel.getConfig().get(USER_ATTRIBUTE);
        Object value = UserAttributeMapper.getClaimValue(mapperModel, context);
        if (value != null) {
            if (attribute.equalsIgnoreCase("email")) {
                context.setEmail(value.toString());
            } else if (attribute.equalsIgnoreCase("firstName")) {
                context.setFirstName(value.toString());
            } else if (attribute.equalsIgnoreCase("lastName")) {
                context.setLastName(value.toString());
            } else {
                context.setUserAttribute(attribute, value.toString());
            }
        }
    }

    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String attribute = (String)mapperModel.getConfig().get(USER_ATTRIBUTE);
        Object value = UserAttributeMapper.getClaimValue(mapperModel, context);
        String stringValue = null;
        if (value != null) {
            stringValue = value.toString();
        }
        if (attribute.equalsIgnoreCase("email")) {
            user.setEmail(stringValue);
        } else if (attribute.equalsIgnoreCase("firstName")) {
            user.setFirstName(stringValue);
        } else if (attribute.equalsIgnoreCase("lastName")) {
            user.setLastName(stringValue);
        } else {
            String current = user.getFirstAttribute(attribute);
            if (stringValue != null && !stringValue.equals(current)) {
                user.setSingleAttribute(attribute, stringValue);
            } else if (value == null) {
                user.removeAttribute(attribute);
            }
        }
    }

    public String getHelpText() {
        return "Import declared claim if it exists in ID, access token or the claim set returned by the user profile endpoint into the specified user property or attribute.";
    }

    static {
        ProviderConfigProperty property1 = new ProviderConfigProperty();
        property1.setName("claim");
        property1.setLabel("Claim");
        property1.setHelpText("Name of claim to search for in token.  You can reference nested claims using a '.', i.e. 'address.locality'.");
        property1.setType("String");
        configProperties.add(property1);
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(USER_ATTRIBUTE);
        property.setLabel("User Attribute Name");
        property.setHelpText("User attribute name to store claim.  Use email, lastName, and firstName to map to those predefined user properties.");
        property.setType("String");
        configProperties.add(property);
    }
}

