/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.security.Key;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.LinkedList;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.common.util.PemUtils;
import org.keycloak.keys.KeyMetadata;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.KeysMetadataRepresentation;
import org.keycloak.services.resources.admin.RealmAuth;

public class KeyResource {
    private RealmModel realm;
    private KeycloakSession session;
    private RealmAuth auth;

    public KeyResource(RealmModel realm, KeycloakSession session, RealmAuth auth) {
        this.realm = realm;
        this.session = session;
        this.auth = auth;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public KeysMetadataRepresentation getKeyMetadata() {
        this.auth.requireView();
        KeyManager keystore = this.session.keys();
        KeysMetadataRepresentation keys = new KeysMetadataRepresentation();
        keys.setActive(Collections.singletonMap(KeyMetadata.Type.RSA.name(), keystore.getActiveKey(this.realm).getKid()));
        LinkedList<KeysMetadataRepresentation.KeyMetadataRepresentation> l = new LinkedList<KeysMetadataRepresentation.KeyMetadataRepresentation>();
        for (KeyMetadata m : this.session.keys().getKeys(this.realm, true)) {
            KeysMetadataRepresentation.KeyMetadataRepresentation r = new KeysMetadataRepresentation.KeyMetadataRepresentation();
            r.setProviderId(m.getProviderId());
            r.setProviderPriority(m.getProviderPriority());
            r.setKid(m.getKid());
            r.setStatus(m.getStatus() != null ? m.getStatus().name() : null);
            r.setType(m.getType() != null ? m.getType().name() : null);
            r.setPublicKey(PemUtils.encodeKey((Key)m.getPublicKey()));
            r.setCertificate(PemUtils.encodeCertificate((Certificate)m.getCertificate()));
            l.add(r);
        }
        keys.setKeys(l);
        return keys;
    }
}

