/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;

public class ClientConfigResolver {
    protected ClientModel client;
    protected ClientTemplateModel clientTemplate;

    public ClientConfigResolver(ClientModel client) {
        this.client = client;
        this.clientTemplate = client.getClientTemplate();
    }

    public String resolveAttribute(String name) {
        if (this.clientTemplate != null && this.client.useTemplateConfig()) {
            return this.clientTemplate.getAttribute(name);
        }
        return this.client.getAttribute(name);
    }

    public boolean isFrontchannelLogout() {
        if (this.clientTemplate != null && this.client.useTemplateConfig()) {
            return this.clientTemplate.isFrontchannelLogout();
        }
        return this.client.isFrontchannelLogout();
    }

    boolean isConsentRequired() {
        if (this.clientTemplate != null && this.client.useTemplateConfig()) {
            return this.clientTemplate.isConsentRequired();
        }
        return this.client.isConsentRequired();
    }

    boolean isStandardFlowEnabled() {
        if (this.clientTemplate != null && this.client.useTemplateConfig()) {
            return this.clientTemplate.isStandardFlowEnabled();
        }
        return this.client.isStandardFlowEnabled();
    }

    boolean isServiceAccountsEnabled() {
        if (this.clientTemplate != null && this.client.useTemplateConfig()) {
            return this.clientTemplate.isServiceAccountsEnabled();
        }
        return this.client.isServiceAccountsEnabled();
    }
}

