/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.stream;

import java.io.Serializable;
import java.util.Map;
import java.util.function.Predicate;
import org.keycloak.models.sessions.infinispan.entities.ClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

public class ClientSessionPredicate
implements Predicate<Map.Entry<String, SessionEntity>>,
Serializable {
    private String realm;
    private String client;
    private String userSession;
    private Long expiredRefresh;
    private Boolean requireUserSession = false;
    private Boolean requireNullUserSession = false;

    private ClientSessionPredicate(String realm) {
        this.realm = realm;
    }

    public static ClientSessionPredicate create(String realm) {
        return new ClientSessionPredicate(realm);
    }

    public ClientSessionPredicate client(String client) {
        this.client = client;
        return this;
    }

    public ClientSessionPredicate userSession(String userSession) {
        this.userSession = userSession;
        return this;
    }

    public ClientSessionPredicate expiredRefresh(long expiredRefresh) {
        this.expiredRefresh = expiredRefresh;
        return this;
    }

    public ClientSessionPredicate requireUserSession() {
        this.requireUserSession = true;
        return this;
    }

    public ClientSessionPredicate requireNullUserSession() {
        this.requireNullUserSession = true;
        return this;
    }

    @Override
    public boolean test(Map.Entry<String, SessionEntity> entry) {
        SessionEntity e = entry.getValue();
        if (!this.realm.equals(e.getRealm())) {
            return false;
        }
        if (!(e instanceof ClientSessionEntity)) {
            return false;
        }
        ClientSessionEntity entity = (ClientSessionEntity)e;
        if (this.client != null && !entity.getClient().equals(this.client)) {
            return false;
        }
        if (this.userSession != null && !this.userSession.equals(entity.getUserSession())) {
            return false;
        }
        if (this.requireUserSession.booleanValue() && entity.getUserSession() == null) {
            return false;
        }
        if (this.requireNullUserSession.booleanValue() && entity.getUserSession() != null) {
            return false;
        }
        return this.expiredRefresh == null || (long)entity.getTimestamp() <= this.expiredRefresh;
    }
}

