/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.StreamMessage;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.client.impl.ClientMessageImpl;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.reader.StreamMessageUtil;

public final class ActiveMQStreamMessage
extends ActiveMQMessage
implements StreamMessage {
    public static final byte TYPE = 6;
    private int len = 0;

    protected ActiveMQStreamMessage(ClientSession session) {
        super((byte)6, session);
    }

    protected ActiveMQStreamMessage(ClientMessage message, ClientSession session) {
        super(message, session);
    }

    public ActiveMQStreamMessage(StreamMessage foreign, ClientSession session) throws JMSException {
        super(foreign, (byte)6, session);
        foreign.reset();
        try {
            while (true) {
                Object obj = foreign.readObject();
                this.writeObject(obj);
            }
        }
        catch (MessageEOFException messageEOFException) {
            return;
        }
    }

    public ActiveMQStreamMessage() {
        this.message = new ClientMessageImpl(0, false, 0L, 0L, 4, 1500);
    }

    @Override
    public byte getType() {
        return 6;
    }

    @Override
    public boolean readBoolean() throws JMSException {
        this.checkRead();
        try {
            return StreamMessageUtil.streamReadBoolean(this.message.getBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new MessageFormatException(e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public byte readByte() throws JMSException {
        this.checkRead();
        try {
            return StreamMessageUtil.streamReadByte(this.message.getBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new MessageFormatException(e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public short readShort() throws JMSException {
        this.checkRead();
        try {
            return StreamMessageUtil.streamReadShort(this.message.getBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new MessageFormatException(e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public char readChar() throws JMSException {
        this.checkRead();
        try {
            return StreamMessageUtil.streamReadChar(this.message.getBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new MessageFormatException(e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public int readInt() throws JMSException {
        this.checkRead();
        try {
            return StreamMessageUtil.streamReadInteger(this.message.getBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new MessageFormatException(e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public long readLong() throws JMSException {
        this.checkRead();
        try {
            return StreamMessageUtil.streamReadLong(this.message.getBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new MessageFormatException(e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public float readFloat() throws JMSException {
        this.checkRead();
        try {
            return StreamMessageUtil.streamReadFloat(this.message.getBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new MessageFormatException(e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public double readDouble() throws JMSException {
        this.checkRead();
        try {
            return StreamMessageUtil.streamReadDouble(this.message.getBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new MessageFormatException(e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public String readString() throws JMSException {
        this.checkRead();
        try {
            return StreamMessageUtil.streamReadString(this.message.getBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new MessageFormatException(e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public int readBytes(byte[] value) throws JMSException {
        this.checkRead();
        try {
            Pair<Integer, Integer> pairRead = StreamMessageUtil.streamReadBytes(this.message.getBodyBuffer(), this.len, value);
            this.len = pairRead.getA();
            return pairRead.getB();
        }
        catch (IllegalStateException e) {
            throw new MessageFormatException(e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public Object readObject() throws JMSException {
        this.checkRead();
        try {
            return StreamMessageUtil.streamReadObject(this.message.getBodyBuffer());
        }
        catch (IllegalStateException e) {
            throw new MessageFormatException(e.getMessage());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public void writeBoolean(boolean value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeByte((byte)2);
        this.getBuffer().writeBoolean(value);
    }

    @Override
    public void writeByte(byte value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeByte((byte)3);
        this.getBuffer().writeByte(value);
    }

    @Override
    public void writeShort(short value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeByte((byte)5);
        this.getBuffer().writeShort(value);
    }

    @Override
    public void writeChar(char value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeByte((byte)11);
        this.getBuffer().writeShort((short)value);
    }

    @Override
    public void writeInt(int value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeByte((byte)6);
        this.getBuffer().writeInt(value);
    }

    @Override
    public void writeLong(long value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeByte((byte)7);
        this.getBuffer().writeLong(value);
    }

    @Override
    public void writeFloat(float value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeByte((byte)8);
        this.getBuffer().writeInt(Float.floatToIntBits(value));
    }

    @Override
    public void writeDouble(double value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeByte((byte)9);
        this.getBuffer().writeLong(Double.doubleToLongBits(value));
    }

    @Override
    public void writeString(String value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeByte((byte)10);
        this.getBuffer().writeNullableString(value);
    }

    @Override
    public void writeBytes(byte[] value) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeByte((byte)4);
        this.getBuffer().writeInt(value.length);
        this.getBuffer().writeBytes(value);
    }

    @Override
    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.checkWrite();
        this.getBuffer().writeByte((byte)4);
        this.getBuffer().writeInt(length);
        this.getBuffer().writeBytes(value, offset, length);
    }

    @Override
    public void writeObject(Object value) throws JMSException {
        if (value instanceof String) {
            this.writeString((String)value);
        } else if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value == null) {
            this.writeString(null);
        } else {
            throw new MessageFormatException("Invalid object type: " + value.getClass());
        }
    }

    @Override
    public void reset() throws JMSException {
        if (!this.readOnly) {
            this.readOnly = true;
        }
        this.getBuffer().resetReaderIndex();
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.getBuffer().clear();
    }

    @Override
    public void doBeforeSend() throws Exception {
        this.reset();
    }

    private ActiveMQBuffer getBuffer() {
        return this.message.getBodyBuffer();
    }

    @Override
    public boolean isBodyAssignableTo(Class c) {
        return false;
    }
}

