/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.compensations.impl;

import com.arjuna.wst.BusinessAgreementWithParticipantCompletionParticipant;
import com.arjuna.wst.FaultedException;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.WrongStateException;
import com.arjuna.wst11.ConfirmCompletedParticipant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.narayana.compensations.api.CompensationHandler;
import org.jboss.narayana.compensations.api.ConfirmationHandler;
import org.jboss.narayana.compensations.api.TransactionLoggedHandler;
import org.jboss.narayana.compensations.impl.BeanManagerUtil;
import org.jboss.narayana.compensations.impl.CompensationContext;

public class ParticipantImpl
implements BusinessAgreementWithParticipantCompletionParticipant,
ConfirmCompletedParticipant {
    private static final Map<Object, AtomicInteger> PARTICIPANT_COUNTERS = new HashMap<Object, AtomicInteger>();
    private Class<? extends CompensationHandler> compensationHandler;
    private Class<? extends ConfirmationHandler> confirmationHandler;
    private Class<? extends TransactionLoggedHandler> transactionLoggedHandler;
    private BeanManager beanManager;
    private ClassLoader applicationClassloader;
    private Object currentTX;

    public ParticipantImpl(Class<? extends CompensationHandler> compensationHandlerClass, Class<? extends ConfirmationHandler> confirmationHandlerClass, Class<? extends TransactionLoggedHandler> transactionLoggedHandlerClass, Object currentTX) {
        this.compensationHandler = compensationHandlerClass;
        this.confirmationHandler = confirmationHandlerClass;
        this.transactionLoggedHandler = transactionLoggedHandlerClass;
        this.currentTX = currentTX;
        this.beanManager = BeanManagerUtil.getBeanManager();
        this.applicationClassloader = Thread.currentThread().getContextClassLoader();
        this.incrementParticipantsCounter();
    }

    private <T> T instantiate(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        return BeanManagerUtil.createBeanInstance(clazz, this.beanManager);
    }

    public void confirmCompleted(boolean confirmed) {
        if (this.transactionLoggedHandler != null) {
            ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.applicationClassloader);
            TransactionLoggedHandler handler = this.instantiate(this.transactionLoggedHandler);
            handler.transactionLogged(confirmed);
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }

    public void close() throws WrongStateException, SystemException {
        if (this.confirmationHandler != null) {
            ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.applicationClassloader);
            CompensationContext.setTxContextToExtend(this.currentTX);
            ConfirmationHandler handler = this.instantiate(this.confirmationHandler);
            handler.confirm();
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
        this.decrementParticipantsCounter();
    }

    public void cancel() throws FaultedException, WrongStateException, SystemException {
    }

    public void compensate() throws FaultedException, WrongStateException, SystemException {
        try {
            if (this.compensationHandler != null) {
                ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.applicationClassloader);
                CompensationContext.setTxContextToExtend(this.currentTX);
                CompensationHandler handler = this.instantiate(this.compensationHandler);
                handler.compensate();
                Thread.currentThread().setContextClassLoader(origClassLoader);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.decrementParticipantsCounter();
    }

    public String status() throws SystemException {
        return null;
    }

    public void unknown() throws SystemException {
    }

    public void error() throws SystemException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementParticipantsCounter() {
        Map<Object, AtomicInteger> map = PARTICIPANT_COUNTERS;
        synchronized (map) {
            AtomicInteger counter = PARTICIPANT_COUNTERS.get(this.currentTX);
            if (counter == null) {
                PARTICIPANT_COUNTERS.put(this.currentTX, new AtomicInteger(1));
            } else {
                counter.incrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementParticipantsCounter() {
        Map<Object, AtomicInteger> map = PARTICIPANT_COUNTERS;
        synchronized (map) {
            AtomicInteger counter = PARTICIPANT_COUNTERS.get(this.currentTX);
            if (counter == null || counter.decrementAndGet() > 0) {
                return;
            }
            PARTICIPANT_COUNTERS.remove(this.currentTX);
        }
        CompensationContext.close(this.currentTX);
    }
}

