/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.bean;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanEntry;
import org.wildfly.clustering.marshalling.Externalizer;

public class InfinispanBeanEntryExternalizer
implements Externalizer<InfinispanBeanEntry<Object>> {
    public void writeObject(ObjectOutput output, InfinispanBeanEntry<Object> entry) throws IOException {
        output.writeObject(entry.getGroupId());
        Date lastAccessedTime = entry.getLastAccessedTime();
        output.writeLong(lastAccessedTime != null ? lastAccessedTime.getTime() : 0L);
    }

    public InfinispanBeanEntry<Object> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        InfinispanBeanEntry<Object> entry = new InfinispanBeanEntry<Object>(input.readObject());
        long time = input.readLong();
        if (time > 0L) {
            entry.setLastAccessedTime(new Date(time));
        }
        return entry;
    }

    public Class<InfinispanBeanEntry<Object>> getTargetClass() {
        Class<InfinispanBeanEntry> targetClass = InfinispanBeanEntry.class;
        return targetClass;
    }
}

