/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap;

import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.LDAPConstants;
import org.keycloak.storage.ldap.LDAPStorageProviderFactory;

public class LDAPConfig {
    private final MultivaluedHashMap<String, String> config;

    public LDAPConfig(MultivaluedHashMap<String, String> config) {
        this.config = config;
    }

    public String getConnectionUrl() {
        return (String)this.config.getFirst((Object)"connectionUrl");
    }

    public String getFactoryName() {
        return "com.sun.jndi.ldap.LdapCtxFactory";
    }

    public String getAuthType() {
        String value = (String)this.config.getFirst((Object)"authType");
        if (value == null) {
            return "simple";
        }
        return value;
    }

    public String getUseTruststoreSpi() {
        return (String)this.config.getFirst((Object)"useTruststoreSpi");
    }

    public String getUsersDn() {
        String usersDn = (String)this.config.getFirst((Object)"usersDn");
        if (usersDn == null) {
            usersDn = (String)this.config.getFirst((Object)"userDnSuffix");
        }
        return usersDn;
    }

    public Collection<String> getUserObjectClasses() {
        String objClassesCfg = (String)this.config.getFirst((Object)"userObjectClasses");
        String objClassesStr = objClassesCfg != null && objClassesCfg.length() > 0 ? objClassesCfg.trim() : "inetOrgPerson,organizationalPerson";
        String[] objectClasses = objClassesStr.split(",");
        HashSet<String> userObjClasses = new HashSet<String>();
        for (int i = 0; i < objectClasses.length; ++i) {
            userObjClasses.add(objectClasses[i].trim());
        }
        return userObjClasses;
    }

    public String getBindDN() {
        return (String)this.config.getFirst((Object)"bindDn");
    }

    public String getBindCredential() {
        return (String)this.config.getFirst((Object)"bindCredential");
    }

    public String getVendor() {
        return (String)this.config.getFirst((Object)"vendor");
    }

    public boolean isActiveDirectory() {
        String vendor = this.getVendor();
        return vendor != null && vendor.equals("ad");
    }

    public String getConnectionPooling() {
        return (String)this.config.getFirst((Object)"connectionPooling");
    }

    public Properties getAdditionalConnectionProperties() {
        return null;
    }

    public int getSearchScope() {
        String searchScope = (String)this.config.getFirst((Object)"searchScope");
        return searchScope == null ? 2 : Integer.parseInt(searchScope);
    }

    public String getUuidLDAPAttributeName() {
        String uuidAttrName = (String)this.config.getFirst((Object)"uuidLDAPAttribute");
        if (uuidAttrName == null) {
            String vendor = this.getVendor();
            uuidAttrName = LDAPConstants.getUuidAttributeName((String)vendor);
        }
        return uuidAttrName;
    }

    public boolean isPagination() {
        String pagination = (String)this.config.getFirst((Object)"pagination");
        return Boolean.parseBoolean(pagination);
    }

    public int getBatchSizeForSync() {
        String pageSizeConfig = (String)this.config.getFirst((Object)"batchSizeForSync");
        return pageSizeConfig != null ? Integer.parseInt(pageSizeConfig) : 1000;
    }

    public String getUsernameLdapAttribute() {
        String username = (String)this.config.getFirst((Object)"usernameLDAPAttribute");
        if (username == null) {
            username = this.isActiveDirectory() ? "cn" : "uid";
        }
        return username;
    }

    public String getRdnLdapAttribute() {
        String rdn = (String)this.config.getFirst((Object)"rdnLDAPAttribute");
        if (rdn == null && (rdn = this.getUsernameLdapAttribute()).equalsIgnoreCase("sAMAccountName")) {
            rdn = "cn";
        }
        return rdn;
    }

    public String getCustomUserSearchFilter() {
        String customFilter = (String)this.config.getFirst((Object)"customUserSearchFilter");
        if (customFilter != null && (customFilter = customFilter.trim()).length() > 0) {
            return customFilter;
        }
        return null;
    }

    public LDAPStorageProviderFactory.EditMode getEditMode() {
        String editModeString = (String)this.config.getFirst((Object)"editMode");
        if (editModeString == null) {
            return LDAPStorageProviderFactory.EditMode.READ_ONLY;
        }
        return LDAPStorageProviderFactory.EditMode.valueOf(editModeString);
    }
}

