/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.idm.store.ldap.LDAPIdentityStore;

public class LDAPIdentityStoreRegistry {
    private static final Logger logger = Logger.getLogger(LDAPIdentityStoreRegistry.class);
    private Map<String, LDAPIdentityStoreContext> ldapStores = new ConcurrentHashMap<String, LDAPIdentityStoreContext>();

    public LDAPIdentityStore getLdapStore(ComponentModel model) {
        LDAPIdentityStoreContext context = this.ldapStores.get(model.getId());
        MultivaluedHashMap config = model.getConfig();
        if (context == null || !config.equals((Object)context.config)) {
            this.logLDAPConfig(model.getName(), (MultivaluedHashMap<String, String>)config);
            LDAPIdentityStore store = LDAPIdentityStoreRegistry.createLdapIdentityStore((MultivaluedHashMap<String, String>)config);
            context = new LDAPIdentityStoreContext(config, store);
            this.ldapStores.put(model.getId(), context);
        }
        return context.store;
    }

    private void logLDAPConfig(String fedProviderDisplayName, MultivaluedHashMap<String, String> ldapConfig) {
        MultivaluedHashMap copy = new MultivaluedHashMap(ldapConfig);
        copy.remove((Object)"bindCredential");
        logger.infof("Creating new LDAP based partition manager for the Federation provider: " + fedProviderDisplayName + ", LDAP Configuration: " + copy, new Object[0]);
    }

    public static LDAPIdentityStore createLdapIdentityStore(MultivaluedHashMap<String, String> ldapConfig) {
        LDAPConfig cfg = new LDAPConfig(ldapConfig);
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.authentication", "none simple");
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.initsize", "1");
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.maxsize", "1000");
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.prefsize", "5");
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.timeout", "300000");
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.protocol", "plain");
        LDAPIdentityStoreRegistry.checkSystemProperty("com.sun.jndi.ldap.connect.pool.debug", "off");
        return new LDAPIdentityStore(cfg);
    }

    private static void checkSystemProperty(String name, String defaultValue) {
        if (System.getProperty(name) == null) {
            System.setProperty(name, defaultValue);
        }
    }

    private class LDAPIdentityStoreContext {
        private MultivaluedHashMap<String, String> config;
        private LDAPIdentityStore store;

        private LDAPIdentityStoreContext(MultivaluedHashMap<String, String> config, LDAPIdentityStore store) {
            this.config = config;
            this.store = store;
        }
    }
}

