/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers;

import java.util.Collections;
import java.util.List;
import javax.naming.AuthenticationException;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.user.SynchronizationResult;

public abstract class AbstractLDAPStorageMapper {
    protected final ComponentModel mapperModel;
    protected final LDAPStorageProvider ldapProvider;
    protected final RealmModel realm;

    public AbstractLDAPStorageMapper(ComponentModel mapperModel, LDAPStorageProvider ldapProvider, RealmModel realm) {
        this.mapperModel = mapperModel;
        this.ldapProvider = ldapProvider;
        this.realm = realm;
    }

    public SynchronizationResult syncDataFromFederationProviderToKeycloak() {
        return new SynchronizationResult();
    }

    public SynchronizationResult syncDataFromKeycloakToFederationProvider() {
        return new SynchronizationResult();
    }

    public abstract void beforeLDAPQuery(LDAPQuery var1);

    public abstract UserModel proxy(LDAPObject var1, UserModel var2);

    public abstract void onRegisterUserToLDAP(LDAPObject var1, UserModel var2);

    public abstract void onImportUserFromLDAP(LDAPObject var1, UserModel var2, boolean var3);

    public List<UserModel> getGroupMembers(GroupModel group, int firstResult, int maxResults) {
        return Collections.emptyList();
    }

    public boolean onAuthenticationFailure(LDAPObject ldapUser, UserModel user, AuthenticationException ldapException) {
        return false;
    }

    public static boolean parseBooleanParameter(ComponentModel mapperModel, String paramName) {
        String paramm = (String)mapperModel.getConfig().getFirst((Object)paramName);
        return Boolean.parseBoolean(paramm);
    }

    public LDAPStorageProvider getLdapProvider() {
        return this.ldapProvider;
    }

    public RealmModel getRealm() {
        return this.realm;
    }
}

