/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers.membership;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ModelException;
import org.keycloak.storage.ldap.mappers.membership.LDAPGroupMapperMode;
import org.keycloak.storage.ldap.mappers.membership.MembershipType;

public abstract class CommonLDAPGroupMapperConfig {
    public static final String MEMBERSHIP_LDAP_ATTRIBUTE = "membership.ldap.attribute";
    public static final String MEMBERSHIP_ATTRIBUTE_TYPE = "membership.attribute.type";
    public static final String MODE = "mode";
    public static final String USER_ROLES_RETRIEVE_STRATEGY = "user.roles.retrieve.strategy";
    protected final ComponentModel mapperModel;

    public CommonLDAPGroupMapperConfig(ComponentModel mapperModel) {
        this.mapperModel = mapperModel;
    }

    public String getMembershipLdapAttribute() {
        String membershipAttrName = (String)this.mapperModel.getConfig().getFirst((Object)MEMBERSHIP_LDAP_ATTRIBUTE);
        return membershipAttrName != null ? membershipAttrName : "member";
    }

    public MembershipType getMembershipTypeLdapAttribute() {
        String membershipType = (String)this.mapperModel.getConfig().getFirst((Object)MEMBERSHIP_ATTRIBUTE_TYPE);
        return membershipType != null && !membershipType.isEmpty() ? Enum.valueOf(MembershipType.class, membershipType) : MembershipType.DN;
    }

    public LDAPGroupMapperMode getMode() {
        String modeString = (String)this.mapperModel.getConfig().getFirst((Object)MODE);
        if (modeString == null || modeString.isEmpty()) {
            throw new ModelException("Mode is missing! Check your configuration");
        }
        return Enum.valueOf(LDAPGroupMapperMode.class, modeString.toUpperCase());
    }

    protected Set<String> getConfigValues(String str) {
        String[] objClasses = str.split(",");
        HashSet<String> trimmed = new HashSet<String>();
        for (String objectClass : objClasses) {
            if ((objectClass = objectClass.trim()).length() <= 0) continue;
            trimmed.add(objectClass);
        }
        return trimmed;
    }

    public abstract String getLDAPGroupsDn();

    public abstract String getLDAPGroupNameLdapAttribute();
}

