/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProviderCreationEventImpl;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.mongo.keycloak.adapters.AbstractMongoAdapter;
import org.keycloak.models.mongo.keycloak.adapters.ClientAdapter;
import org.keycloak.models.mongo.keycloak.adapters.ClientTemplateAdapter;
import org.keycloak.models.mongo.keycloak.adapters.RoleAdapter;
import org.keycloak.models.mongo.keycloak.entities.AuthenticationExecutionEntity;
import org.keycloak.models.mongo.keycloak.entities.AuthenticationFlowEntity;
import org.keycloak.models.mongo.keycloak.entities.AuthenticatorConfigEntity;
import org.keycloak.models.mongo.keycloak.entities.ComponentEntity;
import org.keycloak.models.mongo.keycloak.entities.IdentityProviderEntity;
import org.keycloak.models.mongo.keycloak.entities.IdentityProviderMapperEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoClientEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoClientTemplateEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoRealmEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoRoleEntity;
import org.keycloak.models.mongo.keycloak.entities.RequiredActionProviderEntity;
import org.keycloak.models.mongo.keycloak.entities.RequiredCredentialEntity;
import org.keycloak.models.mongo.keycloak.entities.UserFederationMapperEntity;
import org.keycloak.models.mongo.keycloak.entities.UserFederationProviderEntity;
import org.keycloak.models.utils.ComponentUtil;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderEvent;

public class RealmAdapter
extends AbstractMongoAdapter<MongoRealmEntity>
implements RealmModel {
    private final MongoRealmEntity realm;
    private final RealmProvider model;
    private volatile transient OTPPolicy otpPolicy;
    private volatile transient PasswordPolicy passwordPolicy;
    private volatile transient KeycloakSession session;

    public RealmAdapter(KeycloakSession session, MongoRealmEntity realmEntity, MongoStoreInvocationContext invocationContext) {
        super(invocationContext);
        this.realm = realmEntity;
        this.session = session;
        this.model = session.realms();
    }

    public String getId() {
        return this.realm.getId();
    }

    public String getName() {
        return this.realm.getName();
    }

    public void setName(String name) {
        this.realm.setName(name);
        this.updateRealm();
    }

    public String getDisplayName() {
        return this.realm.getDisplayName();
    }

    public void setDisplayName(String displayName) {
        this.realm.setDisplayName(displayName);
        this.updateRealm();
    }

    public String getDisplayNameHtml() {
        return this.realm.getDisplayNameHtml();
    }

    public void setDisplayNameHtml(String displayNameHtml) {
        this.realm.setDisplayNameHtml(displayNameHtml);
        this.updateRealm();
    }

    public boolean isEnabled() {
        return this.realm.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.realm.setEnabled(enabled);
        this.updateRealm();
    }

    public SslRequired getSslRequired() {
        return this.realm.getSslRequired() != null ? SslRequired.valueOf((String)this.realm.getSslRequired()) : null;
    }

    public void setSslRequired(SslRequired sslRequired) {
        this.realm.setSslRequired(sslRequired.name());
        this.updateRealm();
    }

    public boolean isRegistrationAllowed() {
        return this.realm.isRegistrationAllowed();
    }

    public void setRegistrationAllowed(boolean registrationAllowed) {
        this.realm.setRegistrationAllowed(registrationAllowed);
        this.updateRealm();
    }

    public boolean isRegistrationEmailAsUsername() {
        return this.realm.isRegistrationEmailAsUsername();
    }

    public void setRegistrationEmailAsUsername(boolean registrationEmailAsUsername) {
        this.realm.setRegistrationEmailAsUsername(registrationEmailAsUsername);
        this.updateRealm();
    }

    public boolean isRememberMe() {
        return this.realm.isRememberMe();
    }

    public void setRememberMe(boolean rememberMe) {
        this.realm.setRememberMe(rememberMe);
        this.updateRealm();
    }

    public boolean isBruteForceProtected() {
        return this.realm.isBruteForceProtected();
    }

    public void setBruteForceProtected(boolean value) {
        this.realm.setBruteForceProtected(value);
        this.updateRealm();
    }

    public int getMaxFailureWaitSeconds() {
        return this.realm.getMaxFailureWaitSeconds();
    }

    public void setMaxFailureWaitSeconds(int val) {
        this.realm.setMaxFailureWaitSeconds(val);
        this.updateRealm();
    }

    public int getWaitIncrementSeconds() {
        return this.realm.getWaitIncrementSeconds();
    }

    public void setWaitIncrementSeconds(int val) {
        this.realm.setWaitIncrementSeconds(val);
        this.updateRealm();
    }

    public long getQuickLoginCheckMilliSeconds() {
        return this.realm.getQuickLoginCheckMilliSeconds();
    }

    public void setQuickLoginCheckMilliSeconds(long val) {
        this.realm.setQuickLoginCheckMilliSeconds(val);
        this.updateRealm();
    }

    public int getMinimumQuickLoginWaitSeconds() {
        return this.realm.getMinimumQuickLoginWaitSeconds();
    }

    public void setMinimumQuickLoginWaitSeconds(int val) {
        this.realm.setMinimumQuickLoginWaitSeconds(val);
        this.updateRealm();
    }

    public int getMaxDeltaTimeSeconds() {
        return this.realm.getMaxDeltaTimeSeconds();
    }

    public void setMaxDeltaTimeSeconds(int val) {
        this.realm.setMaxDeltaTimeSeconds(val);
        this.updateRealm();
    }

    public int getFailureFactor() {
        return this.realm.getFailureFactor();
    }

    public void setFailureFactor(int failureFactor) {
        this.realm.setFailureFactor(failureFactor);
        this.updateRealm();
    }

    public boolean isVerifyEmail() {
        return this.realm.isVerifyEmail();
    }

    public void setVerifyEmail(boolean verifyEmail) {
        this.realm.setVerifyEmail(verifyEmail);
        this.updateRealm();
    }

    public boolean isResetPasswordAllowed() {
        return this.realm.isResetPasswordAllowed();
    }

    public void setResetPasswordAllowed(boolean resetPassword) {
        this.realm.setResetPasswordAllowed(resetPassword);
        this.updateRealm();
    }

    public boolean isEditUsernameAllowed() {
        return this.realm.isEditUsernameAllowed();
    }

    public void setEditUsernameAllowed(boolean editUsernameAllowed) {
        this.realm.setEditUsernameAllowed(editUsernameAllowed);
        this.updateRealm();
    }

    public PasswordPolicy getPasswordPolicy() {
        if (this.passwordPolicy == null) {
            this.passwordPolicy = PasswordPolicy.parse((KeycloakSession)this.session, (String)this.realm.getPasswordPolicy());
        }
        return this.passwordPolicy;
    }

    public void setPasswordPolicy(PasswordPolicy policy) {
        this.passwordPolicy = policy;
        this.realm.setPasswordPolicy(policy.toString());
        this.updateRealm();
    }

    public OTPPolicy getOTPPolicy() {
        if (this.otpPolicy == null) {
            this.otpPolicy = new OTPPolicy();
            this.otpPolicy.setDigits(this.realm.getOtpPolicyDigits());
            this.otpPolicy.setAlgorithm(this.realm.getOtpPolicyAlgorithm());
            this.otpPolicy.setInitialCounter(this.realm.getOtpPolicyInitialCounter());
            this.otpPolicy.setLookAheadWindow(this.realm.getOtpPolicyLookAheadWindow());
            this.otpPolicy.setType(this.realm.getOtpPolicyType());
            this.otpPolicy.setPeriod(this.realm.getOtpPolicyPeriod());
        }
        return this.otpPolicy;
    }

    public void setOTPPolicy(OTPPolicy policy) {
        this.realm.setOtpPolicyAlgorithm(policy.getAlgorithm());
        this.realm.setOtpPolicyDigits(policy.getDigits());
        this.realm.setOtpPolicyInitialCounter(policy.getInitialCounter());
        this.realm.setOtpPolicyLookAheadWindow(policy.getLookAheadWindow());
        this.realm.setOtpPolicyType(policy.getType());
        this.realm.setOtpPolicyPeriod(policy.getPeriod());
        this.updateRealm();
    }

    public int getNotBefore() {
        return this.realm.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.realm.setNotBefore(notBefore);
        this.updateRealm();
    }

    public boolean isRevokeRefreshToken() {
        return this.realm.isRevokeRefreshToken();
    }

    public void setRevokeRefreshToken(boolean revokeRefreshToken) {
        this.realm.setRevokeRefreshToken(revokeRefreshToken);
        this.updateRealm();
    }

    public int getSsoSessionIdleTimeout() {
        return this.realm.getSsoSessionIdleTimeout();
    }

    public void setSsoSessionIdleTimeout(int seconds) {
        this.realm.setSsoSessionIdleTimeout(seconds);
        this.updateRealm();
    }

    public int getSsoSessionMaxLifespan() {
        return this.realm.getSsoSessionMaxLifespan();
    }

    public void setSsoSessionMaxLifespan(int seconds) {
        this.realm.setSsoSessionMaxLifespan(seconds);
        this.updateRealm();
    }

    public int getOfflineSessionIdleTimeout() {
        return this.realm.getOfflineSessionIdleTimeout();
    }

    public void setOfflineSessionIdleTimeout(int seconds) {
        this.realm.setOfflineSessionIdleTimeout(seconds);
        this.updateRealm();
    }

    public int getAccessTokenLifespan() {
        return this.realm.getAccessTokenLifespan();
    }

    public void setAccessTokenLifespan(int tokenLifespan) {
        this.realm.setAccessTokenLifespan(tokenLifespan);
        this.updateRealm();
    }

    public int getAccessTokenLifespanForImplicitFlow() {
        return this.realm.getAccessTokenLifespanForImplicitFlow();
    }

    public void setAccessTokenLifespanForImplicitFlow(int seconds) {
        this.realm.setAccessTokenLifespanForImplicitFlow(seconds);
        this.updateRealm();
    }

    public int getAccessCodeLifespan() {
        return this.realm.getAccessCodeLifespan();
    }

    public void setAccessCodeLifespan(int accessCodeLifespan) {
        this.realm.setAccessCodeLifespan(accessCodeLifespan);
        this.updateRealm();
    }

    public int getAccessCodeLifespanUserAction() {
        return this.realm.getAccessCodeLifespanUserAction();
    }

    public void setAccessCodeLifespanUserAction(int accessCodeLifespanUserAction) {
        this.realm.setAccessCodeLifespanUserAction(accessCodeLifespanUserAction);
        this.updateRealm();
    }

    public void setAccessCodeLifespanLogin(int accessCodeLifespanLogin) {
        this.realm.setAccessCodeLifespanLogin(accessCodeLifespanLogin);
        this.updateRealm();
    }

    public int getAccessCodeLifespanLogin() {
        return this.realm.getAccessCodeLifespanLogin();
    }

    public String getLoginTheme() {
        return this.realm.getLoginTheme();
    }

    public void setLoginTheme(String name) {
        this.realm.setLoginTheme(name);
        this.updateRealm();
    }

    public String getAccountTheme() {
        return this.realm.getAccountTheme();
    }

    public void setAccountTheme(String name) {
        this.realm.setAccountTheme(name);
        this.updateRealm();
    }

    public String getAdminTheme() {
        return this.realm.getAdminTheme();
    }

    public void setAdminTheme(String name) {
        this.realm.setAdminTheme(name);
        this.updateRealm();
    }

    public String getEmailTheme() {
        return this.realm.getEmailTheme();
    }

    public void setEmailTheme(String name) {
        this.realm.setEmailTheme(name);
        this.updateRealm();
    }

    public RoleModel getRole(String name) {
        return this.session.realms().getRealmRole((RealmModel)this, name);
    }

    public RoleModel addRole(String name) {
        return this.session.realms().addRealmRole((RealmModel)this, name);
    }

    public RoleModel addRole(String id, String name) {
        return this.session.realms().addRealmRole((RealmModel)this, id, name);
    }

    public boolean removeRole(RoleModel role) {
        return this.session.realms().removeRole((RealmModel)this, role);
    }

    public Set<RoleModel> getRoles() {
        DBObject query = new QueryBuilder().and("realmId").is((Object)this.getId()).get();
        List<MongoRoleEntity> roles = this.getMongoStore().loadEntities(MongoRoleEntity.class, query, this.invocationContext);
        if (roles == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<RoleAdapter> result = new HashSet<RoleAdapter>();
        for (MongoRoleEntity role : roles) {
            result.add(new RoleAdapter(this.session, this, role, (RoleContainerModel)this, this.invocationContext));
        }
        return Collections.unmodifiableSet(result);
    }

    public RoleModel getRoleById(String id) {
        return this.session.realms().getRoleById(id, (RealmModel)this);
    }

    public GroupModel createGroup(String name) {
        return this.session.realms().createGroup((RealmModel)this, name);
    }

    public GroupModel createGroup(String id, String name) {
        return this.session.realms().createGroup((RealmModel)this, id, name);
    }

    public void moveGroup(GroupModel group, GroupModel toParent) {
        this.session.realms().moveGroup((RealmModel)this, group, toParent);
    }

    public GroupModel getGroupById(String id) {
        return this.model.getGroupById(id, (RealmModel)this);
    }

    public List<GroupModel> getGroups() {
        return this.session.realms().getGroups((RealmModel)this);
    }

    public List<GroupModel> getTopLevelGroups() {
        return this.session.realms().getTopLevelGroups((RealmModel)this);
    }

    public boolean removeGroup(GroupModel group) {
        return this.session.realms().removeGroup((RealmModel)this, group);
    }

    public List<String> getDefaultRoles() {
        return Collections.unmodifiableList(this.realm.getDefaultRoles());
    }

    public void addDefaultRole(String name) {
        RoleModel role = this.getRole(name);
        if (role == null) {
            this.addRole(name);
        }
        this.getMongoStore().pushItemToList(this.realm, "defaultRoles", name, true, this.invocationContext);
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        ArrayList<String> roleNames = new ArrayList<String>();
        for (String roleName : defaultRoles) {
            RoleModel role = this.getRole(roleName);
            if (role == null) {
                this.addRole(roleName);
            }
            roleNames.add(roleName);
        }
        this.realm.setDefaultRoles(roleNames);
        this.updateRealm();
    }

    public static boolean contains(String str, String[] array) {
        for (String s : array) {
            if (!str.equals(s)) continue;
            return true;
        }
        return false;
    }

    public void removeDefaultRoles(String ... defaultRoles) {
        ArrayList<String> roleNames = new ArrayList<String>();
        for (String role : this.realm.getDefaultRoles()) {
            if (RealmAdapter.contains(role, defaultRoles)) continue;
            roleNames.add(role);
        }
        this.realm.setDefaultRoles(roleNames);
        this.updateRealm();
    }

    public List<GroupModel> getDefaultGroups() {
        List<String> entities = this.realm.getDefaultGroups();
        if (entities == null || entities.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<GroupModel> defaultGroups = new LinkedList<GroupModel>();
        for (String id : entities) {
            defaultGroups.add(this.session.realms().getGroupById(id, (RealmModel)this));
        }
        return Collections.unmodifiableList(defaultGroups);
    }

    public void addDefaultGroup(GroupModel group) {
        this.getMongoStore().pushItemToList(this.realm, "defaultGroups", group.getId(), true, this.invocationContext);
    }

    public void removeDefaultGroup(GroupModel group) {
        this.getMongoStore().pullItemFromList(this.realm, "defaultGroups", group.getId(), this.invocationContext);
    }

    public ClientModel getClientById(String id) {
        return this.model.getClientById(id, (RealmModel)this);
    }

    public ClientModel getClientByClientId(String clientId) {
        return this.session.realms().getClientByClientId(clientId, (RealmModel)this);
    }

    public List<ClientModel> getClients() {
        return this.session.realms().getClients((RealmModel)this);
    }

    public ClientModel addClient(String name) {
        return this.session.realms().addClient((RealmModel)this, name);
    }

    public ClientModel addClient(String id, String clientId) {
        return this.session.realms().addClient((RealmModel)this, id, clientId);
    }

    public boolean removeClient(String id) {
        if (id == null) {
            return false;
        }
        ClientModel client = this.getClientById(id);
        if (client == null) {
            return false;
        }
        return this.session.realms().removeClient(id, (RealmModel)this);
    }

    public void addRequiredCredential(String type) {
        RequiredCredentialModel credentialModel = this.initRequiredCredentialModel(type);
        this.addRequiredCredential(credentialModel, this.realm.getRequiredCredentials());
    }

    protected void addRequiredCredential(RequiredCredentialModel credentialModel, List<RequiredCredentialEntity> persistentCollection) {
        RequiredCredentialEntity credEntity = new RequiredCredentialEntity();
        credEntity.setType(credentialModel.getType());
        credEntity.setFormLabel(credentialModel.getFormLabel());
        credEntity.setInput(credentialModel.isInput());
        credEntity.setSecret(credentialModel.isSecret());
        persistentCollection.add(credEntity);
        this.updateRealm();
    }

    public void updateRequiredCredentials(Set<String> creds) {
        this.updateRequiredCredentials(creds, this.realm.getRequiredCredentials());
    }

    protected void updateRequiredCredentials(Set<String> creds, List<RequiredCredentialEntity> credsEntities) {
        HashSet<String> already = new HashSet<String>();
        HashSet<RequiredCredentialEntity> toRemove = new HashSet<RequiredCredentialEntity>();
        for (RequiredCredentialEntity entity : credsEntities) {
            if (!creds.contains(entity.getType())) {
                toRemove.add(entity);
                continue;
            }
            already.add(entity.getType());
        }
        for (RequiredCredentialEntity entity : toRemove) {
            credsEntities.remove(entity);
        }
        for (String cred : creds) {
            if (already.contains(cred)) continue;
            RequiredCredentialModel credentialModel = this.initRequiredCredentialModel(cred);
            this.addRequiredCredential(credentialModel, credsEntities);
        }
        this.updateRealm();
    }

    public List<RequiredCredentialModel> getRequiredCredentials() {
        return this.convertRequiredCredentialEntities(this.realm.getRequiredCredentials());
    }

    protected List<RequiredCredentialModel> convertRequiredCredentialEntities(Collection<RequiredCredentialEntity> credEntities) {
        if (credEntities == null || credEntities.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<RequiredCredentialModel> result = new LinkedList<RequiredCredentialModel>();
        for (RequiredCredentialEntity entity : credEntities) {
            RequiredCredentialModel model = new RequiredCredentialModel();
            model.setFormLabel(entity.getFormLabel());
            model.setInput(entity.isInput());
            model.setSecret(entity.isSecret());
            model.setType(entity.getType());
            result.add(model);
        }
        return Collections.unmodifiableList(result);
    }

    protected void updateRealm() {
        super.updateMongoEntity();
    }

    protected RequiredCredentialModel initRequiredCredentialModel(String type) {
        RequiredCredentialModel model = (RequiredCredentialModel)RequiredCredentialModel.BUILT_IN.get(type);
        if (model == null) {
            throw new RuntimeException("Unknown credential type " + type);
        }
        return model;
    }

    public Map<String, String> getBrowserSecurityHeaders() {
        return Collections.unmodifiableMap(this.realm.getBrowserSecurityHeaders());
    }

    public void setBrowserSecurityHeaders(Map<String, String> headers) {
        this.realm.setBrowserSecurityHeaders(headers);
        this.updateRealm();
    }

    public Map<String, String> getSmtpConfig() {
        return Collections.unmodifiableMap(this.realm.getSmtpConfig());
    }

    public void setSmtpConfig(Map<String, String> smtpConfig) {
        this.realm.setSmtpConfig(smtpConfig);
        this.updateRealm();
    }

    public List<IdentityProviderModel> getIdentityProviders() {
        List<IdentityProviderEntity> entities = this.realm.getIdentityProviders();
        if (entities.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IdentityProviderModel> identityProviders = new ArrayList<IdentityProviderModel>();
        for (IdentityProviderEntity entity : entities) {
            IdentityProviderModel identityProviderModel = new IdentityProviderModel();
            identityProviderModel.setProviderId(entity.getProviderId());
            identityProviderModel.setAlias(entity.getAlias());
            identityProviderModel.setDisplayName(entity.getDisplayName());
            identityProviderModel.setInternalId(entity.getInternalId());
            Map<String, String> config = entity.getConfig();
            HashMap<String, String> copy = new HashMap<String, String>();
            copy.putAll(config);
            identityProviderModel.setConfig(copy);
            identityProviderModel.setEnabled(entity.isEnabled());
            identityProviderModel.setTrustEmail(entity.isTrustEmail());
            identityProviderModel.setAuthenticateByDefault(entity.isAuthenticateByDefault());
            identityProviderModel.setFirstBrokerLoginFlowId(entity.getFirstBrokerLoginFlowId());
            identityProviderModel.setPostBrokerLoginFlowId(entity.getPostBrokerLoginFlowId());
            identityProviderModel.setStoreToken(entity.isStoreToken());
            identityProviderModel.setAddReadTokenRoleOnCreate(entity.isAddReadTokenRoleOnCreate());
            identityProviders.add(identityProviderModel);
        }
        return Collections.unmodifiableList(identityProviders);
    }

    public IdentityProviderModel getIdentityProviderByAlias(String alias) {
        for (IdentityProviderModel identityProviderModel : this.getIdentityProviders()) {
            if (!identityProviderModel.getAlias().equals(alias)) continue;
            return identityProviderModel;
        }
        return null;
    }

    public void addIdentityProvider(IdentityProviderModel identityProvider) {
        IdentityProviderEntity entity = new IdentityProviderEntity();
        entity.setInternalId(KeycloakModelUtils.generateId());
        entity.setAlias(identityProvider.getAlias());
        entity.setDisplayName(identityProvider.getDisplayName());
        entity.setProviderId(identityProvider.getProviderId());
        entity.setEnabled(identityProvider.isEnabled());
        entity.setTrustEmail(identityProvider.isTrustEmail());
        entity.setAddReadTokenRoleOnCreate(identityProvider.isAddReadTokenRoleOnCreate());
        entity.setStoreToken(identityProvider.isStoreToken());
        entity.setAuthenticateByDefault(identityProvider.isAuthenticateByDefault());
        entity.setFirstBrokerLoginFlowId(identityProvider.getFirstBrokerLoginFlowId());
        entity.setPostBrokerLoginFlowId(identityProvider.getPostBrokerLoginFlowId());
        entity.setConfig(identityProvider.getConfig());
        this.realm.getIdentityProviders().add(entity);
        this.updateRealm();
    }

    public void removeIdentityProviderByAlias(String alias) {
        for (IdentityProviderEntity entity : this.realm.getIdentityProviders()) {
            if (!entity.getAlias().equals(alias)) continue;
            this.realm.getIdentityProviders().remove(entity);
            this.updateRealm();
            break;
        }
    }

    public void updateIdentityProvider(IdentityProviderModel identityProvider) {
        for (IdentityProviderEntity entity : this.realm.getIdentityProviders()) {
            if (!entity.getInternalId().equals(identityProvider.getInternalId())) continue;
            entity.setAlias(identityProvider.getAlias());
            entity.setDisplayName(identityProvider.getDisplayName());
            entity.setEnabled(identityProvider.isEnabled());
            entity.setTrustEmail(identityProvider.isTrustEmail());
            entity.setAuthenticateByDefault(identityProvider.isAuthenticateByDefault());
            entity.setFirstBrokerLoginFlowId(identityProvider.getFirstBrokerLoginFlowId());
            entity.setPostBrokerLoginFlowId(identityProvider.getPostBrokerLoginFlowId());
            entity.setAddReadTokenRoleOnCreate(identityProvider.isAddReadTokenRoleOnCreate());
            entity.setStoreToken(identityProvider.isStoreToken());
            entity.setConfig(identityProvider.getConfig());
        }
        this.updateRealm();
    }

    private void removeFederationMappersForProvider(String federationProviderId) {
        Set<UserFederationMapperEntity> mappers = this.getUserFederationMapperEntitiesByFederationProvider(federationProviderId);
        for (UserFederationMapperEntity mapper : mappers) {
            this.getMongoEntity().getUserFederationMappers().remove(mapper);
        }
    }

    public UserFederationProviderModel addUserFederationProvider(String providerName, Map<String, String> config, int priority, String displayName, int fullSyncPeriod, int changedSyncPeriod, int lastSync) {
        KeycloakModelUtils.ensureUniqueDisplayName((String)displayName, null, this.getUserFederationProviders());
        UserFederationProviderEntity entity = new UserFederationProviderEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setPriority(priority);
        entity.setProviderName(providerName);
        entity.setConfig(config);
        if (displayName == null) {
            displayName = entity.getId();
        }
        entity.setDisplayName(displayName);
        entity.setFullSyncPeriod(fullSyncPeriod);
        entity.setChangedSyncPeriod(changedSyncPeriod);
        entity.setLastSync(lastSync);
        this.realm.getUserFederationProviders().add(entity);
        this.updateRealm();
        UserFederationProviderModel providerModel = new UserFederationProviderModel(entity.getId(), providerName, config, priority, displayName, fullSyncPeriod, changedSyncPeriod, lastSync);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new UserFederationProviderCreationEventImpl((RealmModel)this, providerModel));
        return providerModel;
    }

    public void removeUserFederationProvider(UserFederationProviderModel provider) {
        Iterator<UserFederationProviderEntity> it = this.realm.getUserFederationProviders().iterator();
        while (it.hasNext()) {
            UserFederationProviderEntity entity = it.next();
            if (!entity.getId().equals(provider.getId())) continue;
            this.session.users().preRemove((RealmModel)this, new UserFederationProviderModel(entity.getId(), entity.getProviderName(), entity.getConfig(), entity.getPriority(), entity.getDisplayName(), entity.getFullSyncPeriod(), entity.getChangedSyncPeriod(), entity.getLastSync()));
            this.removeFederationMappersForProvider(provider.getId());
            it.remove();
        }
        this.updateRealm();
    }

    public void updateUserFederationProvider(UserFederationProviderModel model) {
        KeycloakModelUtils.ensureUniqueDisplayName((String)model.getDisplayName(), (UserFederationProviderModel)model, this.getUserFederationProviders());
        for (UserFederationProviderEntity entity : this.realm.getUserFederationProviders()) {
            if (!entity.getId().equals(model.getId())) continue;
            entity.setProviderName(model.getProviderName());
            entity.setConfig(model.getConfig());
            entity.setPriority(model.getPriority());
            String displayName = model.getDisplayName();
            if (displayName != null) {
                entity.setDisplayName(model.getDisplayName());
            }
            entity.setFullSyncPeriod(model.getFullSyncPeriod());
            entity.setChangedSyncPeriod(model.getChangedSyncPeriod());
            entity.setLastSync(model.getLastSync());
        }
        this.updateRealm();
    }

    public List<UserFederationProviderModel> getUserFederationProviders() {
        List<UserFederationProviderEntity> entities = this.realm.getUserFederationProviders();
        if (entities.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<UserFederationProviderEntity> copy = new LinkedList<UserFederationProviderEntity>();
        for (UserFederationProviderEntity entity : entities) {
            copy.add(entity);
        }
        Collections.sort(copy, new Comparator<UserFederationProviderEntity>(){

            @Override
            public int compare(UserFederationProviderEntity o1, UserFederationProviderEntity o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        LinkedList<UserFederationProviderModel> result = new LinkedList<UserFederationProviderModel>();
        for (UserFederationProviderEntity entity : copy) {
            result.add(new UserFederationProviderModel(entity.getId(), entity.getProviderName(), entity.getConfig(), entity.getPriority(), entity.getDisplayName(), entity.getFullSyncPeriod(), entity.getChangedSyncPeriod(), entity.getLastSync()));
        }
        return Collections.unmodifiableList(result);
    }

    /*
     * WARNING - void declaration
     */
    public void setUserFederationProviders(List<UserFederationProviderModel> providers) {
        for (UserFederationProviderModel currentProvider : providers) {
            KeycloakModelUtils.ensureUniqueDisplayName((String)currentProvider.getDisplayName(), (UserFederationProviderModel)currentProvider, providers);
        }
        List<UserFederationProviderEntity> existingProviders = this.realm.getUserFederationProviders();
        LinkedList<UserFederationProviderEntity> toRemove = new LinkedList<UserFederationProviderEntity>();
        for (UserFederationProviderEntity entity : existingProviders) {
            boolean found = false;
            for (UserFederationProviderModel userFederationProviderModel : providers) {
                if (!entity.getId().equals(userFederationProviderModel.getId())) continue;
                entity.setConfig(userFederationProviderModel.getConfig());
                entity.setPriority(userFederationProviderModel.getPriority());
                entity.setProviderName(userFederationProviderModel.getProviderName());
                String displayName = userFederationProviderModel.getDisplayName();
                if (displayName != null) {
                    entity.setDisplayName(displayName);
                }
                entity.setFullSyncPeriod(userFederationProviderModel.getFullSyncPeriod());
                entity.setChangedSyncPeriod(userFederationProviderModel.getChangedSyncPeriod());
                entity.setLastSync(userFederationProviderModel.getLastSync());
                found = true;
                break;
            }
            if (found) continue;
            this.session.users().preRemove((RealmModel)this, new UserFederationProviderModel(entity.getId(), entity.getProviderName(), entity.getConfig(), entity.getPriority(), entity.getDisplayName(), entity.getFullSyncPeriod(), entity.getChangedSyncPeriod(), entity.getLastSync()));
            this.removeFederationMappersForProvider(entity.getId());
            toRemove.add(entity);
        }
        for (UserFederationProviderEntity entity : toRemove) {
            this.realm.getUserFederationProviders().remove(entity);
        }
        LinkedList<UserFederationProviderModel> add = new LinkedList<UserFederationProviderModel>();
        for (UserFederationProviderModel model : providers) {
            boolean found = false;
            for (UserFederationProviderEntity entity : this.realm.getUserFederationProviders()) {
                if (!entity.getId().equals(model.getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            add.add(model);
        }
        for (UserFederationProviderModel model : add) {
            void var8_21;
            UserFederationProviderEntity entity = new UserFederationProviderEntity();
            if (model.getId() != null) {
                entity.setId(model.getId());
            } else {
                String string = KeycloakModelUtils.generateId();
                entity.setId(string);
                model.setId(string);
            }
            entity.setProviderName(model.getProviderName());
            entity.setConfig(model.getConfig());
            entity.setPriority(model.getPriority());
            String string = model.getDisplayName();
            if (string == null) {
                String string2 = entity.getId();
            }
            entity.setDisplayName((String)var8_21);
            entity.setFullSyncPeriod(model.getFullSyncPeriod());
            entity.setChangedSyncPeriod(model.getChangedSyncPeriod());
            entity.setLastSync(model.getLastSync());
            this.realm.getUserFederationProviders().add(entity);
            this.session.getKeycloakSessionFactory().publish((ProviderEvent)new UserFederationProviderCreationEventImpl((RealmModel)this, model));
        }
        this.updateRealm();
    }

    public boolean isEventsEnabled() {
        return this.realm.isEventsEnabled();
    }

    public void setEventsEnabled(boolean enabled) {
        this.realm.setEventsEnabled(enabled);
        this.updateRealm();
    }

    public long getEventsExpiration() {
        return this.realm.getEventsExpiration();
    }

    public void setEventsExpiration(long expiration) {
        this.realm.setEventsExpiration(expiration);
        this.updateRealm();
    }

    public Set<String> getEventsListeners() {
        List<String> eventsListeners = this.realm.getEventsListeners();
        if (eventsListeners.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> copy = new HashSet<String>();
        copy.addAll(eventsListeners);
        return Collections.unmodifiableSet(copy);
    }

    public void setEventsListeners(Set<String> listeners) {
        if (listeners != null) {
            this.realm.setEventsListeners(new ArrayList<String>(listeners));
        } else {
            this.realm.setEventsListeners(Collections.EMPTY_LIST);
        }
        this.updateRealm();
    }

    public Set<String> getEnabledEventTypes() {
        List<String> enabledEventTypes = this.realm.getEnabledEventTypes();
        if (enabledEventTypes.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> copy = new HashSet<String>();
        copy.addAll(enabledEventTypes);
        return Collections.unmodifiableSet(copy);
    }

    public void setEnabledEventTypes(Set<String> enabledEventTypes) {
        if (enabledEventTypes != null) {
            this.realm.setEnabledEventTypes(new ArrayList<String>(enabledEventTypes));
        } else {
            this.realm.setEnabledEventTypes(Collections.EMPTY_LIST);
        }
        this.updateRealm();
    }

    public boolean isAdminEventsEnabled() {
        return this.realm.isAdminEventsEnabled();
    }

    public void setAdminEventsEnabled(boolean enabled) {
        this.realm.setAdminEventsEnabled(enabled);
        this.updateRealm();
    }

    public boolean isAdminEventsDetailsEnabled() {
        return this.realm.isAdminEventsDetailsEnabled();
    }

    public void setAdminEventsDetailsEnabled(boolean enabled) {
        this.realm.setAdminEventsDetailsEnabled(enabled);
        this.updateRealm();
    }

    public ClientModel getMasterAdminClient() {
        MongoClientEntity appData = this.getMongoStore().loadEntity(MongoClientEntity.class, this.realm.getMasterAdminClient(), this.invocationContext);
        if (appData == null) {
            return null;
        }
        MongoRealmEntity masterRealm = this.getMongoStore().loadEntity(MongoRealmEntity.class, appData.getRealmId(), this.invocationContext);
        RealmAdapter masterRealmModel = new RealmAdapter(this.session, masterRealm, this.invocationContext);
        return new ClientAdapter(this.session, masterRealmModel, appData, this.invocationContext);
    }

    public void setMasterAdminClient(ClientModel client) {
        String adminAppId = client != null ? client.getId() : null;
        this.realm.setMasterAdminClient(adminAppId);
        this.updateRealm();
    }

    @Override
    public MongoRealmEntity getMongoEntity() {
        return this.realm;
    }

    public boolean isIdentityFederationEnabled() {
        return this.realm.getIdentityProviders() != null && !this.realm.getIdentityProviders().isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RealmModel)) {
            return false;
        }
        RealmModel that = (RealmModel)o;
        return that.getId().equals(this.getId());
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean isInternationalizationEnabled() {
        return this.realm.isInternationalizationEnabled();
    }

    public void setInternationalizationEnabled(boolean enabled) {
        this.realm.setInternationalizationEnabled(enabled);
        this.updateRealm();
    }

    public Set<String> getSupportedLocales() {
        List<String> supportedLocales = this.realm.getSupportedLocales();
        if (supportedLocales == null || supportedLocales.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> copy = new HashSet<String>();
        copy.addAll(supportedLocales);
        return Collections.unmodifiableSet(copy);
    }

    public void setSupportedLocales(Set<String> locales) {
        if (locales != null) {
            this.realm.setSupportedLocales(new ArrayList<String>(locales));
        } else {
            this.realm.setSupportedLocales(Collections.EMPTY_LIST);
        }
        this.updateRealm();
    }

    public String getDefaultLocale() {
        return this.realm.getDefaultLocale();
    }

    public void setDefaultLocale(String locale) {
        this.realm.setDefaultLocale(locale);
        this.updateRealm();
    }

    public Set<IdentityProviderMapperModel> getIdentityProviderMappers() {
        List<IdentityProviderMapperEntity> entities = this.getMongoEntity().getIdentityProviderMappers();
        if (entities.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<IdentityProviderMapperModel> mappings = new HashSet<IdentityProviderMapperModel>();
        for (IdentityProviderMapperEntity entity : entities) {
            IdentityProviderMapperModel mapping = this.entityToModel(entity);
            mappings.add(mapping);
        }
        return Collections.unmodifiableSet(mappings);
    }

    public Set<IdentityProviderMapperModel> getIdentityProviderMappersByAlias(String brokerAlias) {
        HashSet<IdentityProviderMapperModel> mappings = new HashSet<IdentityProviderMapperModel>();
        for (IdentityProviderMapperEntity entity : this.getMongoEntity().getIdentityProviderMappers()) {
            if (!entity.getIdentityProviderAlias().equals(brokerAlias)) continue;
            IdentityProviderMapperModel mapping = this.entityToModel(entity);
            mappings.add(mapping);
        }
        return mappings;
    }

    public IdentityProviderMapperModel addIdentityProviderMapper(IdentityProviderMapperModel model) {
        if (this.getIdentityProviderMapperByName(model.getIdentityProviderAlias(), model.getIdentityProviderMapper()) != null) {
            throw new RuntimeException("identity provider mapper name must be unique per identity provider");
        }
        String id = KeycloakModelUtils.generateId();
        IdentityProviderMapperEntity entity = new IdentityProviderMapperEntity();
        entity.setId(id);
        entity.setName(model.getName());
        entity.setIdentityProviderAlias(model.getIdentityProviderAlias());
        entity.setIdentityProviderMapper(model.getIdentityProviderMapper());
        entity.setConfig(model.getConfig());
        this.getMongoEntity().getIdentityProviderMappers().add(entity);
        this.updateMongoEntity();
        return this.entityToModel(entity);
    }

    protected IdentityProviderMapperEntity getIdentityProviderMapperEntity(String id) {
        for (IdentityProviderMapperEntity entity : this.getMongoEntity().getIdentityProviderMappers()) {
            if (!entity.getId().equals(id)) continue;
            return entity;
        }
        return null;
    }

    protected IdentityProviderMapperEntity getIdentityProviderMapperEntityByName(String alias, String name) {
        for (IdentityProviderMapperEntity entity : this.getMongoEntity().getIdentityProviderMappers()) {
            if (!entity.getIdentityProviderAlias().equals(alias) || !entity.getName().equals(name)) continue;
            return entity;
        }
        return null;
    }

    public void removeIdentityProviderMapper(IdentityProviderMapperModel mapping) {
        IdentityProviderMapperEntity toDelete = this.getIdentityProviderMapperEntity(mapping.getId());
        if (toDelete != null) {
            this.realm.getIdentityProviderMappers().remove(toDelete);
            this.updateMongoEntity();
        }
    }

    public void updateIdentityProviderMapper(IdentityProviderMapperModel mapping) {
        IdentityProviderMapperEntity entity = this.getIdentityProviderMapperEntity(mapping.getId());
        entity.setIdentityProviderAlias(mapping.getIdentityProviderAlias());
        entity.setIdentityProviderMapper(mapping.getIdentityProviderMapper());
        if (entity.getConfig() == null) {
            entity.setConfig(mapping.getConfig());
        } else {
            entity.getConfig().clear();
            entity.getConfig().putAll(mapping.getConfig());
        }
        this.updateMongoEntity();
    }

    public IdentityProviderMapperModel getIdentityProviderMapperById(String id) {
        IdentityProviderMapperEntity entity = this.getIdentityProviderMapperEntity(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public IdentityProviderMapperModel getIdentityProviderMapperByName(String alias, String name) {
        IdentityProviderMapperEntity entity = this.getIdentityProviderMapperEntityByName(alias, name);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    protected IdentityProviderMapperModel entityToModel(IdentityProviderMapperEntity entity) {
        IdentityProviderMapperModel mapping = new IdentityProviderMapperModel();
        mapping.setId(entity.getId());
        mapping.setName(entity.getName());
        mapping.setIdentityProviderAlias(entity.getIdentityProviderAlias());
        mapping.setIdentityProviderMapper(entity.getIdentityProviderMapper());
        HashMap<String, String> config = new HashMap<String, String>();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        mapping.setConfig(config);
        return mapping;
    }

    public AuthenticationFlowModel getBrowserFlow() {
        String flowId = this.realm.getBrowserFlow();
        if (flowId == null) {
            return null;
        }
        return this.getAuthenticationFlowById(flowId);
    }

    public void setBrowserFlow(AuthenticationFlowModel flow) {
        this.realm.setBrowserFlow(flow.getId());
        this.updateRealm();
    }

    public AuthenticationFlowModel getRegistrationFlow() {
        String flowId = this.realm.getRegistrationFlow();
        if (flowId == null) {
            return null;
        }
        return this.getAuthenticationFlowById(flowId);
    }

    public void setRegistrationFlow(AuthenticationFlowModel flow) {
        this.realm.setRegistrationFlow(flow.getId());
        this.updateRealm();
    }

    public AuthenticationFlowModel getDirectGrantFlow() {
        String flowId = this.realm.getDirectGrantFlow();
        if (flowId == null) {
            return null;
        }
        return this.getAuthenticationFlowById(flowId);
    }

    public void setDirectGrantFlow(AuthenticationFlowModel flow) {
        this.realm.setDirectGrantFlow(flow.getId());
        this.updateRealm();
    }

    public AuthenticationFlowModel getResetCredentialsFlow() {
        String flowId = this.realm.getResetCredentialsFlow();
        if (flowId == null) {
            return null;
        }
        return this.getAuthenticationFlowById(flowId);
    }

    public void setResetCredentialsFlow(AuthenticationFlowModel flow) {
        this.realm.setResetCredentialsFlow(flow.getId());
        this.updateRealm();
    }

    public AuthenticationFlowModel getClientAuthenticationFlow() {
        String flowId = this.realm.getClientAuthenticationFlow();
        if (flowId == null) {
            return null;
        }
        return this.getAuthenticationFlowById(flowId);
    }

    public void setClientAuthenticationFlow(AuthenticationFlowModel flow) {
        this.realm.setClientAuthenticationFlow(flow.getId());
        this.updateRealm();
    }

    public List<AuthenticationFlowModel> getAuthenticationFlows() {
        List<AuthenticationFlowEntity> flows = this.getMongoEntity().getAuthenticationFlows();
        if (flows.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<AuthenticationFlowModel> models = new LinkedList<AuthenticationFlowModel>();
        for (AuthenticationFlowEntity entity : flows) {
            AuthenticationFlowModel model = this.entityToModel(entity);
            models.add(model);
        }
        return Collections.unmodifiableList(models);
    }

    public AuthenticationFlowModel getFlowByAlias(String alias) {
        for (AuthenticationFlowModel flow : this.getAuthenticationFlows()) {
            if (!flow.getAlias().equals(alias)) continue;
            return flow;
        }
        return null;
    }

    protected AuthenticationFlowModel entityToModel(AuthenticationFlowEntity entity) {
        AuthenticationFlowModel model = new AuthenticationFlowModel();
        model.setId(entity.getId());
        model.setAlias(entity.getAlias());
        model.setDescription(entity.getDescription());
        model.setBuiltIn(entity.isBuiltIn());
        model.setTopLevel(entity.isTopLevel());
        model.setProviderId(entity.getProviderId());
        return model;
    }

    public AuthenticationFlowModel getAuthenticationFlowById(String id) {
        AuthenticationFlowEntity entity = this.getFlowEntity(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    protected AuthenticationFlowEntity getFlowEntity(String id) {
        List<AuthenticationFlowEntity> flows = this.getMongoEntity().getAuthenticationFlows();
        for (AuthenticationFlowEntity entity : flows) {
            if (!id.equals(entity.getId())) continue;
            return entity;
        }
        return null;
    }

    public void removeAuthenticationFlow(AuthenticationFlowModel model) {
        if (KeycloakModelUtils.isFlowUsed((RealmModel)this, (AuthenticationFlowModel)model)) {
            throw new ModelException("Cannot remove authentication flow, it is currently in use");
        }
        AuthenticationFlowEntity toDelete = this.getFlowEntity(model.getId());
        if (toDelete == null) {
            return;
        }
        this.getMongoEntity().getAuthenticationFlows().remove(toDelete);
        this.updateMongoEntity();
    }

    public void updateAuthenticationFlow(AuthenticationFlowModel model) {
        AuthenticationFlowEntity toUpdate = this.getFlowEntity(model.getId());
        if (toUpdate == null) {
            return;
        }
        toUpdate.setAlias(model.getAlias());
        toUpdate.setDescription(model.getDescription());
        toUpdate.setProviderId(model.getProviderId());
        toUpdate.setBuiltIn(model.isBuiltIn());
        toUpdate.setTopLevel(model.isTopLevel());
        this.updateMongoEntity();
    }

    public AuthenticationFlowModel addAuthenticationFlow(AuthenticationFlowModel model) {
        AuthenticationFlowEntity entity = new AuthenticationFlowEntity();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        entity.setId(id);
        entity.setAlias(model.getAlias());
        entity.setDescription(model.getDescription());
        entity.setProviderId(model.getProviderId());
        entity.setBuiltIn(model.isBuiltIn());
        entity.setTopLevel(model.isTopLevel());
        this.getMongoEntity().getAuthenticationFlows().add(entity);
        model.setId(entity.getId());
        this.updateMongoEntity();
        return model;
    }

    public List<AuthenticationExecutionModel> getAuthenticationExecutions(String flowId) {
        AuthenticationFlowEntity flow = this.getFlowEntity(flowId);
        if (flow == null) {
            return Collections.EMPTY_LIST;
        }
        List<AuthenticationExecutionEntity> queryResult = flow.getExecutions();
        LinkedList<AuthenticationExecutionModel> executions = new LinkedList<AuthenticationExecutionModel>();
        for (AuthenticationExecutionEntity entity : queryResult) {
            AuthenticationExecutionModel model = this.entityToModel(entity);
            executions.add(model);
        }
        Collections.sort(executions, AuthenticationExecutionModel.ExecutionComparator.SINGLETON);
        return Collections.unmodifiableList(executions);
    }

    public AuthenticationExecutionModel entityToModel(AuthenticationExecutionEntity entity) {
        AuthenticationExecutionModel model = new AuthenticationExecutionModel();
        model.setId(entity.getId());
        model.setRequirement(entity.getRequirement());
        model.setPriority(entity.getPriority());
        model.setAuthenticator(entity.getAuthenticator());
        model.setFlowId(entity.getFlowId());
        model.setParentFlow(entity.getParentFlow());
        model.setAuthenticatorFlow(entity.isAuthenticatorFlow());
        model.setAuthenticatorConfig(entity.getAuthenticatorConfig());
        return model;
    }

    public AuthenticationExecutionModel getAuthenticationExecutionById(String id) {
        AuthenticationExecutionEntity execution = this.getAuthenticationExecutionEntity(id);
        return this.entityToModel(execution);
    }

    public AuthenticationExecutionEntity getAuthenticationExecutionEntity(String id) {
        List<AuthenticationFlowEntity> flows = this.getMongoEntity().getAuthenticationFlows();
        for (AuthenticationFlowEntity entity : flows) {
            for (AuthenticationExecutionEntity exe : entity.getExecutions()) {
                if (!exe.getId().equals(id)) continue;
                return exe;
            }
        }
        return null;
    }

    public AuthenticationExecutionModel addAuthenticatorExecution(AuthenticationExecutionModel model) {
        AuthenticationExecutionEntity entity = new AuthenticationExecutionEntity();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        entity.setId(id);
        entity.setAuthenticator(model.getAuthenticator());
        entity.setPriority(model.getPriority());
        entity.setRequirement(model.getRequirement());
        entity.setAuthenticatorFlow(model.isAuthenticatorFlow());
        entity.setFlowId(model.getFlowId());
        entity.setParentFlow(model.getParentFlow());
        entity.setAuthenticatorConfig(model.getAuthenticatorConfig());
        AuthenticationFlowEntity flow = this.getFlowEntity(model.getParentFlow());
        flow.getExecutions().add(entity);
        this.updateMongoEntity();
        model.setId(entity.getId());
        return model;
    }

    public void updateAuthenticatorExecution(AuthenticationExecutionModel model) {
        AuthenticationExecutionEntity entity = null;
        AuthenticationFlowEntity flow = this.getFlowEntity(model.getParentFlow());
        for (AuthenticationExecutionEntity exe : flow.getExecutions()) {
            if (!exe.getId().equals(model.getId())) continue;
            entity = exe;
        }
        if (entity == null) {
            return;
        }
        entity.setAuthenticatorFlow(model.isAuthenticatorFlow());
        entity.setAuthenticator(model.getAuthenticator());
        entity.setPriority(model.getPriority());
        entity.setRequirement(model.getRequirement());
        entity.setFlowId(model.getFlowId());
        entity.setAuthenticatorConfig(model.getAuthenticatorConfig());
        this.updateMongoEntity();
    }

    public void removeAuthenticatorExecution(AuthenticationExecutionModel model) {
        AuthenticationExecutionEntity entity = null;
        AuthenticationFlowEntity flow = this.getFlowEntity(model.getParentFlow());
        for (AuthenticationExecutionEntity exe : flow.getExecutions()) {
            if (!exe.getId().equals(model.getId())) continue;
            entity = exe;
        }
        if (entity == null) {
            return;
        }
        flow.getExecutions().remove(entity);
        this.updateMongoEntity();
    }

    public List<AuthenticatorConfigModel> getAuthenticatorConfigs() {
        List<AuthenticatorConfigEntity> entities = this.getMongoEntity().getAuthenticatorConfigs();
        if (entities.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<AuthenticatorConfigModel> authenticators = new LinkedList<AuthenticatorConfigModel>();
        for (AuthenticatorConfigEntity entity : entities) {
            authenticators.add(this.entityToModel(entity));
        }
        return Collections.unmodifiableList(authenticators);
    }

    public AuthenticatorConfigModel getAuthenticatorConfigByAlias(String alias) {
        for (AuthenticatorConfigModel config : this.getAuthenticatorConfigs()) {
            if (!config.getAlias().equals(alias)) continue;
            return config;
        }
        return null;
    }

    public AuthenticatorConfigModel addAuthenticatorConfig(AuthenticatorConfigModel model) {
        AuthenticatorConfigEntity auth = new AuthenticatorConfigEntity();
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        auth.setId(id);
        auth.setAlias(model.getAlias());
        auth.setConfig(model.getConfig());
        this.realm.getAuthenticatorConfigs().add(auth);
        model.setId(auth.getId());
        this.updateMongoEntity();
        return model;
    }

    public void removeAuthenticatorConfig(AuthenticatorConfigModel model) {
        AuthenticatorConfigEntity entity = this.getAuthenticatorConfigEntity(model.getId());
        if (entity == null) {
            return;
        }
        this.getMongoEntity().getAuthenticatorConfigs().remove(entity);
        this.updateMongoEntity();
    }

    public AuthenticatorConfigModel getAuthenticatorConfigById(String id) {
        AuthenticatorConfigEntity entity = this.getAuthenticatorConfigEntity(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public AuthenticatorConfigEntity getAuthenticatorConfigEntity(String id) {
        AuthenticatorConfigEntity entity = null;
        for (AuthenticatorConfigEntity auth : this.getMongoEntity().getAuthenticatorConfigs()) {
            if (!auth.getId().equals(id)) continue;
            entity = auth;
            break;
        }
        return entity;
    }

    public AuthenticatorConfigModel entityToModel(AuthenticatorConfigEntity entity) {
        AuthenticatorConfigModel model = new AuthenticatorConfigModel();
        model.setId(entity.getId());
        model.setAlias(entity.getAlias());
        HashMap<String, String> config = new HashMap<String, String>();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        model.setConfig(config);
        return model;
    }

    public void updateAuthenticatorConfig(AuthenticatorConfigModel model) {
        AuthenticatorConfigEntity entity = this.getAuthenticatorConfigEntity(model.getId());
        if (entity == null) {
            return;
        }
        entity.setAlias(model.getAlias());
        if (entity.getConfig() == null) {
            entity.setConfig(model.getConfig());
        } else {
            entity.getConfig().clear();
            entity.getConfig().putAll(model.getConfig());
        }
        this.updateMongoEntity();
    }

    public RequiredActionProviderModel addRequiredActionProvider(RequiredActionProviderModel model) {
        RequiredActionProviderEntity auth = new RequiredActionProviderEntity();
        auth.setId(KeycloakModelUtils.generateId());
        auth.setAlias(model.getAlias());
        auth.setName(model.getName());
        auth.setProviderId(model.getProviderId());
        auth.setConfig(model.getConfig());
        auth.setEnabled(model.isEnabled());
        auth.setDefaultAction(model.isDefaultAction());
        this.realm.getRequiredActionProviders().add(auth);
        model.setId(auth.getId());
        this.updateMongoEntity();
        return model;
    }

    public void removeRequiredActionProvider(RequiredActionProviderModel model) {
        RequiredActionProviderEntity entity = this.getRequiredActionProviderEntity(model.getId());
        if (entity == null) {
            return;
        }
        this.getMongoEntity().getRequiredActionProviders().remove(entity);
        this.updateMongoEntity();
    }

    public RequiredActionProviderModel getRequiredActionProviderById(String id) {
        RequiredActionProviderEntity entity = this.getRequiredActionProviderEntity(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public RequiredActionProviderModel entityToModel(RequiredActionProviderEntity entity) {
        RequiredActionProviderModel model = new RequiredActionProviderModel();
        model.setId(entity.getId());
        model.setProviderId(entity.getProviderId());
        model.setAlias(entity.getAlias());
        model.setName(entity.getName());
        model.setEnabled(entity.isEnabled());
        model.setDefaultAction(entity.isDefaultAction());
        HashMap<String, String> config = new HashMap<String, String>();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        model.setConfig(config);
        return model;
    }

    public void updateRequiredActionProvider(RequiredActionProviderModel model) {
        RequiredActionProviderEntity entity = this.getRequiredActionProviderEntity(model.getId());
        if (entity == null) {
            return;
        }
        entity.setAlias(model.getAlias());
        entity.setName(model.getName());
        entity.setProviderId(model.getProviderId());
        entity.setEnabled(model.isEnabled());
        entity.setDefaultAction(model.isDefaultAction());
        if (entity.getConfig() == null) {
            entity.setConfig(model.getConfig());
        } else {
            entity.getConfig().clear();
            entity.getConfig().putAll(model.getConfig());
        }
        this.updateMongoEntity();
    }

    public List<RequiredActionProviderModel> getRequiredActionProviders() {
        List<RequiredActionProviderEntity> entities = this.realm.getRequiredActionProviders();
        if (entities.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<RequiredActionProviderModel> actions = new LinkedList<RequiredActionProviderModel>();
        for (RequiredActionProviderEntity entity : entities) {
            actions.add(this.entityToModel(entity));
        }
        return Collections.unmodifiableList(actions);
    }

    public RequiredActionProviderEntity getRequiredActionProviderEntity(String id) {
        RequiredActionProviderEntity entity = null;
        for (RequiredActionProviderEntity auth : this.getMongoEntity().getRequiredActionProviders()) {
            if (!auth.getId().equals(id)) continue;
            entity = auth;
            break;
        }
        return entity;
    }

    public RequiredActionProviderModel getRequiredActionProviderByAlias(String alias) {
        for (RequiredActionProviderModel action : this.getRequiredActionProviders()) {
            if (!action.getAlias().equals(alias)) continue;
            return action;
        }
        return null;
    }

    public Set<UserFederationMapperModel> getUserFederationMappers() {
        List<UserFederationMapperEntity> entities = this.getMongoEntity().getUserFederationMappers();
        if (entities.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<UserFederationMapperModel> mappers = new HashSet<UserFederationMapperModel>();
        for (UserFederationMapperEntity entity : entities) {
            UserFederationMapperModel mapper = this.entityToModel(entity);
            mappers.add(mapper);
        }
        return Collections.unmodifiableSet(mappers);
    }

    public Set<UserFederationMapperModel> getUserFederationMappersByFederationProvider(String federationProviderId) {
        HashSet<UserFederationMapperModel> mappers = new HashSet<UserFederationMapperModel>();
        Set<UserFederationMapperEntity> mapperEntities = this.getUserFederationMapperEntitiesByFederationProvider(federationProviderId);
        for (UserFederationMapperEntity entity : mapperEntities) {
            mappers.add(this.entityToModel(entity));
        }
        return mappers;
    }

    public UserFederationMapperModel addUserFederationMapper(UserFederationMapperModel model) {
        if (this.getUserFederationMapperByName(model.getFederationProviderId(), model.getName()) != null) {
            throw new ModelDuplicateException("User federation mapper must be unique per federation provider. There is already: " + model.getName());
        }
        String id = KeycloakModelUtils.generateId();
        UserFederationMapperEntity entity = new UserFederationMapperEntity();
        entity.setId(id);
        entity.setName(model.getName());
        entity.setFederationProviderId(model.getFederationProviderId());
        entity.setFederationMapperType(model.getFederationMapperType());
        entity.setConfig(model.getConfig());
        this.getMongoEntity().getUserFederationMappers().add(entity);
        this.updateMongoEntity();
        UserFederationMapperModel mapperModel = this.entityToModel(entity);
        return mapperModel;
    }

    protected UserFederationMapperEntity getUserFederationMapperEntity(String id) {
        for (UserFederationMapperEntity entity : this.getMongoEntity().getUserFederationMappers()) {
            if (!entity.getId().equals(id)) continue;
            return entity;
        }
        return null;
    }

    protected UserFederationMapperEntity getUserFederationMapperEntityByName(String federationProviderId, String name) {
        for (UserFederationMapperEntity entity : this.getMongoEntity().getUserFederationMappers()) {
            if (!entity.getFederationProviderId().equals(federationProviderId) || !entity.getName().equals(name)) continue;
            return entity;
        }
        return null;
    }

    protected Set<UserFederationMapperEntity> getUserFederationMapperEntitiesByFederationProvider(String federationProviderId) {
        HashSet<UserFederationMapperEntity> mappers = new HashSet<UserFederationMapperEntity>();
        for (UserFederationMapperEntity entity : this.getMongoEntity().getUserFederationMappers()) {
            if (!federationProviderId.equals(entity.getFederationProviderId())) continue;
            mappers.add(entity);
        }
        return mappers;
    }

    public void removeUserFederationMapper(UserFederationMapperModel mapper) {
        UserFederationMapperEntity toDelete = this.getUserFederationMapperEntity(mapper.getId());
        if (toDelete != null) {
            this.realm.getUserFederationMappers().remove(toDelete);
            this.updateMongoEntity();
        }
    }

    public void updateUserFederationMapper(UserFederationMapperModel mapper) {
        UserFederationMapperEntity entity = this.getUserFederationMapperEntity(mapper.getId());
        entity.setFederationProviderId(mapper.getFederationProviderId());
        entity.setFederationMapperType(mapper.getFederationMapperType());
        if (entity.getConfig() == null) {
            entity.setConfig(mapper.getConfig());
        } else {
            entity.getConfig().clear();
            entity.getConfig().putAll(mapper.getConfig());
        }
        this.updateMongoEntity();
    }

    public UserFederationMapperModel getUserFederationMapperById(String id) {
        UserFederationMapperEntity entity = this.getUserFederationMapperEntity(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public UserFederationMapperModel getUserFederationMapperByName(String federationProviderId, String name) {
        UserFederationMapperEntity entity = this.getUserFederationMapperEntityByName(federationProviderId, name);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    protected UserFederationMapperModel entityToModel(UserFederationMapperEntity entity) {
        UserFederationMapperModel mapper = new UserFederationMapperModel();
        mapper.setId(entity.getId());
        mapper.setName(entity.getName());
        mapper.setFederationProviderId(entity.getFederationProviderId());
        mapper.setFederationMapperType(entity.getFederationMapperType());
        HashMap<String, String> config = new HashMap<String, String>();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        mapper.setConfig(config);
        return mapper;
    }

    public List<ClientTemplateModel> getClientTemplates() {
        DBObject query = new QueryBuilder().and("realmId").is((Object)this.getId()).get();
        List<MongoClientTemplateEntity> clientEntities = this.getMongoStore().loadEntities(MongoClientTemplateEntity.class, query, this.invocationContext);
        if (clientEntities.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<ClientTemplateAdapter> result = new LinkedList<ClientTemplateAdapter>();
        for (MongoClientTemplateEntity clientEntity : clientEntities) {
            result.add(new ClientTemplateAdapter(this.session, this, clientEntity, this.invocationContext));
        }
        return Collections.unmodifiableList(result);
    }

    public ClientTemplateModel addClientTemplate(String name) {
        return this.addClientTemplate(null, name);
    }

    public ClientTemplateModel addClientTemplate(String id, String name) {
        MongoClientTemplateEntity clientEntity = new MongoClientTemplateEntity();
        clientEntity.setId(id);
        clientEntity.setName(name);
        clientEntity.setRealmId(this.getId());
        this.getMongoStore().insertEntity(clientEntity, this.invocationContext);
        ClientTemplateAdapter model = new ClientTemplateAdapter(this.session, this, clientEntity, this.invocationContext);
        return model;
    }

    public boolean removeClientTemplate(String id) {
        if (id == null) {
            return false;
        }
        ClientTemplateModel client = this.getClientTemplateById(id);
        if (client == null) {
            return false;
        }
        if (KeycloakModelUtils.isClientTemplateUsed((RealmModel)this, (ClientTemplateModel)client)) {
            throw new ModelException("Cannot remove client template, it is currently in use");
        }
        return this.getMongoStore().removeEntity(MongoClientTemplateEntity.class, id, this.invocationContext);
    }

    public ClientTemplateModel getClientTemplateById(String id) {
        return this.model.getClientTemplateById(id, (RealmModel)this);
    }

    public ComponentModel addComponentModel(ComponentModel model) {
        model = this.importComponentModel(model);
        ComponentUtil.notifyCreated((KeycloakSession)this.session, (RealmModel)this, (ComponentModel)model);
        return model;
    }

    public ComponentModel importComponentModel(ComponentModel model) {
        ComponentUtil.getComponentFactory((KeycloakSession)this.session, (ComponentModel)model).validateConfiguration(this.session, (RealmModel)this, model);
        ComponentEntity entity = new ComponentEntity();
        if (model.getId() == null) {
            entity.setId(KeycloakModelUtils.generateId());
        } else {
            entity.setId(model.getId());
        }
        this.updateComponentEntity(entity, model);
        model.setId(entity.getId());
        if (model.getParentId() == null) {
            entity.setParentId(this.getId());
            model.setParentId(this.getId());
        }
        this.realm.getComponentEntities().add(entity);
        this.updateRealm();
        return model;
    }

    public void updateComponent(ComponentModel model) {
        ComponentUtil.getComponentFactory((KeycloakSession)this.session, (ComponentModel)model).validateConfiguration(this.session, (RealmModel)this, model);
        for (ComponentEntity entity : this.realm.getComponentEntities()) {
            if (!entity.getId().equals(model.getId())) continue;
            this.updateComponentEntity(entity, model);
        }
        this.updateRealm();
    }

    private void updateComponentEntity(ComponentEntity entity, ComponentModel model) {
        entity.setConfig((Map<String, List<String>>)model.getConfig());
        entity.setParentId(model.getParentId());
        entity.setProviderType(model.getProviderType());
        entity.setSubType(model.getSubType());
        entity.setProviderId(model.getProviderId());
        entity.setName(model.getName());
    }

    public void removeComponent(ComponentModel component) {
        Iterator<ComponentEntity> it = this.realm.getComponentEntities().iterator();
        ComponentEntity found = null;
        while (it.hasNext()) {
            ComponentEntity next = it.next();
            if (!next.getId().equals(component.getId())) continue;
            found = next;
            break;
        }
        if (found != null) {
            this.session.users().preRemove((RealmModel)this, component);
            this.removeComponents(component.getId());
            this.realm.getComponentEntities().remove(found);
            this.updateRealm();
        }
    }

    public void removeComponents(String parentId) {
        Iterator<ComponentEntity> it = this.realm.getComponentEntities().iterator();
        HashSet<ComponentEntity> toRemove = new HashSet<ComponentEntity>();
        while (it.hasNext()) {
            ComponentEntity next = it.next();
            if (!next.getParentId().equals(parentId)) continue;
            toRemove.add(next);
        }
        for (ComponentEntity toRem : toRemove) {
            this.session.users().preRemove((RealmModel)this, this.entityToModel(toRem));
            this.realm.getComponentEntities().remove(toRem);
        }
        this.updateRealm();
    }

    public List<ComponentModel> getComponents(String parentId, String providerType) {
        LinkedList<ComponentModel> results = new LinkedList<ComponentModel>();
        for (ComponentEntity entity : this.realm.getComponentEntities()) {
            if (!entity.getParentId().equals(parentId) || !entity.getProviderType().equals(providerType)) continue;
            ComponentModel model = this.entityToModel(entity);
            results.add(model);
        }
        return results;
    }

    public List<ComponentModel> getComponents(String parentId) {
        LinkedList<ComponentModel> results = new LinkedList<ComponentModel>();
        for (ComponentEntity entity : this.realm.getComponentEntities()) {
            if (!entity.getParentId().equals(parentId)) continue;
            ComponentModel model = this.entityToModel(entity);
            results.add(model);
        }
        return results;
    }

    protected ComponentModel entityToModel(ComponentEntity entity) {
        ComponentModel model = new ComponentModel();
        model.setId(entity.getId());
        model.setName(entity.getName());
        model.setParentId(entity.getParentId());
        model.setProviderId(entity.getProviderId());
        model.setProviderType(entity.getProviderType());
        model.setSubType(entity.getSubType());
        MultivaluedHashMap map = new MultivaluedHashMap();
        map.putAll(entity.getConfig());
        model.setConfig(map);
        return model;
    }

    public List<ComponentModel> getComponents() {
        LinkedList<ComponentModel> results = new LinkedList<ComponentModel>();
        for (ComponentEntity entity : this.realm.getComponentEntities()) {
            ComponentModel model = this.entityToModel(entity);
            results.add(model);
        }
        return results;
    }

    public ComponentModel getComponent(String id) {
        for (ComponentEntity entity : this.realm.getComponentEntities()) {
            if (!id.equals(entity.getId())) continue;
            return this.entityToModel(entity);
        }
        return null;
    }

    public void setAttribute(String name, String value) {
        this.realm.getAttributes().put(name, value);
        this.updateRealm();
    }

    public void setAttribute(String name, Boolean value) {
        this.setAttribute(name, value.toString());
    }

    public void setAttribute(String name, Integer value) {
        this.setAttribute(name, value.toString());
    }

    public void setAttribute(String name, Long value) {
        this.setAttribute(name, value.toString());
    }

    public void removeAttribute(String name) {
        this.realm.getAttributes().remove(name);
        this.updateRealm();
    }

    public String getAttribute(String name) {
        return this.realm.getAttributes().get(name);
    }

    public Integer getAttribute(String name, Integer defaultValue) {
        String v = this.getAttribute(name);
        return v != null ? Integer.parseInt(v) : defaultValue;
    }

    public Long getAttribute(String name, Long defaultValue) {
        String v = this.getAttribute(name);
        return v != null ? Long.parseLong(v) : defaultValue;
    }

    public Boolean getAttribute(String name, Boolean defaultValue) {
        String v = this.getAttribute(name);
        return v != null ? Boolean.parseBoolean(v) : defaultValue;
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.putAll(this.realm.getAttributes());
        return attributes;
    }
}

