/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.logs.ActiveMQUtilLogger;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.UUIDTimer;

public final class UUIDGenerator {
    private static final UUIDGenerator sSingleton = new UUIDGenerator();
    private static final byte[][] BLACK_LIST = new byte[][]{{2, 0, 84, 85, 78, 1}};
    private Random mRnd = null;
    private final Object mTimerLock = new Object();
    private UUIDTimer mTimer = null;
    private byte[] address;

    private UUIDGenerator() {
    }

    public static UUIDGenerator getInstance() {
        return sSingleton;
    }

    public Random getRandomNumberGenerator() {
        if (this.mRnd == null) {
            this.mRnd = new SecureRandom();
        }
        return this.mRnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID generateTimeBasedUUID(byte[] byteAddr) {
        byte[] contents = new byte[16];
        int pos = 10;
        for (int i = 0; i < 6; ++i) {
            contents[pos + i] = byteAddr[i];
        }
        Object object = this.mTimerLock;
        synchronized (object) {
            if (this.mTimer == null) {
                this.mTimer = new UUIDTimer(this.getRandomNumberGenerator());
            }
            this.mTimer.getTimestamp(contents);
        }
        return new UUID(1, contents);
    }

    public byte[] generateDummyAddress() {
        Random rnd = this.getRandomNumberGenerator();
        byte[] dummy = new byte[6];
        rnd.nextBytes(dummy);
        dummy[0] = (byte)(dummy[0] | 1);
        if (ActiveMQUtilLogger.LOGGER.isDebugEnabled()) {
            ActiveMQUtilLogger.LOGGER.debug("using dummy address " + UUIDGenerator.asString(dummy));
        }
        return dummy;
    }

    public static byte[] getHardwareAddress() {
        Method isVirtualMethod;
        Method isLoopbackMethod;
        Method isUpMethod;
        Method getHardwareAddressMethod;
        try {
            getHardwareAddressMethod = NetworkInterface.class.getMethod("getHardwareAddress", new Class[0]);
            isUpMethod = NetworkInterface.class.getMethod("isUp", new Class[0]);
            isLoopbackMethod = NetworkInterface.class.getMethod("isLoopback", new Class[0]);
            isVirtualMethod = NetworkInterface.class.getMethod("isVirtual", new Class[0]);
            ExecutorService executor = Executors.newFixedThreadPool(0);
            executor.shutdownNow();
        }
        catch (Throwable t) {
            return null;
        }
        try {
            List<NetworkInterface> ifaces = UUIDGenerator.getAllNetworkInterfaces();
            if (ifaces.size() == 0) {
                return null;
            }
            byte[] address = UUIDGenerator.findFirstMatchingHardwareAddress(ifaces, getHardwareAddressMethod, isUpMethod, isLoopbackMethod, isVirtualMethod);
            if (address != null) {
                if (ActiveMQUtilLogger.LOGGER.isDebugEnabled()) {
                    ActiveMQUtilLogger.LOGGER.debug("using hardware address " + UUIDGenerator.asString(address));
                }
                return address;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public SimpleString generateSimpleStringUUID() {
        return new SimpleString(this.generateStringUUID());
    }

    public UUID generateUUID() {
        byte[] address = this.getAddressBytes();
        UUID uid = this.generateTimeBasedUUID(address);
        return uid;
    }

    public String generateStringUUID() {
        byte[] address = this.getAddressBytes();
        if (address == null) {
            return java.util.UUID.randomUUID().toString();
        }
        return this.generateTimeBasedUUID(address).toString();
    }

    public static byte[] getZeroPaddedSixBytes(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length > 0 && bytes.length <= 6) {
            if (bytes.length == 6) {
                return bytes;
            }
            byte[] paddedAddress = new byte[6];
            System.arraycopy(bytes, 0, paddedAddress, 0, bytes.length);
            for (int i = bytes.length; i < 6; ++i) {
                paddedAddress[i] = 0;
            }
            return paddedAddress;
        }
        return null;
    }

    private static boolean isBlackList(byte[] address) {
        for (byte[] blackList : BLACK_LIST) {
            if (!Arrays.equals(address, blackList)) continue;
            return true;
        }
        return false;
    }

    private byte[] getAddressBytes() {
        if (this.address == null) {
            this.address = UUIDGenerator.getHardwareAddress();
            if (this.address == null) {
                this.address = this.generateDummyAddress();
            }
        }
        return this.address;
    }

    private static String asString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < bytes.length - 1; ++i) {
            s.append(Integer.toHexString(bytes[i]));
            s.append(":");
        }
        s.append(bytes[bytes.length - 1]);
        return s.toString();
    }

    private static List<NetworkInterface> getAllNetworkInterfaces() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            ArrayList<NetworkInterface> ifaces = new ArrayList<NetworkInterface>();
            while (networkInterfaces.hasMoreElements()) {
                ifaces.add(networkInterfaces.nextElement());
            }
            return ifaces;
        }
        catch (SocketException e) {
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] findFirstMatchingHardwareAddress(List<NetworkInterface> ifaces, final Method getHardwareAddressMethod, final Method isUpMethod, final Method isLoopbackMethod, final Method isVirtualMethod) {
        byte[] byArray;
        ExecutorService executor = Executors.newFixedThreadPool(ifaces.size());
        ArrayList<1> tasks = new ArrayList<1>(ifaces.size());
        for (final NetworkInterface networkInterface : ifaces) {
            tasks.add(new Callable<byte[]>(){

                @Override
                public byte[] call() throws Exception {
                    boolean up2 = (Boolean)isUpMethod.invoke((Object)networkInterface, new Object[0]);
                    boolean loopback = (Boolean)isLoopbackMethod.invoke((Object)networkInterface, new Object[0]);
                    boolean virtual = (Boolean)isVirtualMethod.invoke((Object)networkInterface, new Object[0]);
                    if (loopback || virtual || !up2) {
                        throw new Exception("not suitable interface");
                    }
                    Object res = getHardwareAddressMethod.invoke((Object)networkInterface, new Object[0]);
                    if (res != null && res instanceof byte[]) {
                        byte[] address = (byte[])res;
                        byte[] paddedAddress = UUIDGenerator.getZeroPaddedSixBytes(address);
                        if (UUIDGenerator.isBlackList(address)) {
                            throw new Exception("black listed address");
                        }
                        if (paddedAddress != null) {
                            return paddedAddress;
                        }
                    }
                    throw new Exception("invalid network interface");
                }
            });
        }
        try {
            byte[] address;
            byArray = address = (byte[])executor.invokeAny(tasks, 5L, TimeUnit.SECONDS);
            return byArray;
        }
        catch (Exception e) {
            byArray = null;
            return byArray;
        }
        finally {
            executor.shutdownNow();
        }
    }
}

