/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.security.idm.Account;
import io.undertow.server.session.Session;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.handlers.security.CachedAuthenticatedSessionHandler;
import io.undertow.servlet.spec.HttpSessionImpl;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.jboss.security.AuthenticationManager;
import org.wildfly.extension.undertow.deployment.SecurityActions;
import org.wildfly.extension.undertow.security.AccountImpl;
import org.wildfly.security.manager.WildFlySecurityManager;

public class LogoutSessionListener
implements HttpSessionListener {
    private final AuthenticationManager manager;

    public LogoutSessionListener(AuthenticationManager manager) {
        this.manager = manager;
    }

    public void sessionCreated(HttpSessionEvent se) {
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        ServletRequestContext src = ServletRequestContext.current();
        Account requestAccount = null;
        if (src != null && (requestAccount = src.getExchange().getSecurityContext().getAuthenticatedAccount()) != null) {
            this.clearAccount(requestAccount);
        }
        if (se.getSession() instanceof HttpSessionImpl) {
            Account sessionAccount;
            AuthenticatedSessionManager.AuthenticatedSession authenticatedSession;
            final HttpSessionImpl impl = (HttpSessionImpl)se.getSession();
            Session session = WildFlySecurityManager.isChecking() ? (Session)WildFlySecurityManager.doChecked((PrivilegedAction)new PrivilegedAction<Session>(){

                @Override
                public Session run() {
                    return impl.getSession();
                }
            }) : impl.getSession();
            if (session != null && (authenticatedSession = (AuthenticatedSessionManager.AuthenticatedSession)session.getAttribute(CachedAuthenticatedSessionHandler.class.getName() + ".AuthenticatedSession")) != null && (sessionAccount = authenticatedSession.getAccount()) != null && !sessionAccount.equals(requestAccount)) {
                this.clearAccount(sessionAccount);
            }
        }
    }

    private void clearAccount(Account account) {
        Principal principal;
        Principal principal2 = principal = account instanceof AccountImpl ? ((AccountImpl)account).getOriginalPrincipal() : account.getPrincipal();
        if (principal != null) {
            Subject subject = SecurityActions.getSubject();
            this.manager.logout(principal, subject);
        }
    }
}

