/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.idm.query.internal;

import java.util.Date;
import org.keycloak.storage.ldap.idm.query.internal.NamedParameterCondition;
import org.keycloak.storage.ldap.idm.store.ldap.LDAPUtil;

public class EqualCondition
extends NamedParameterCondition {
    private final Object value;

    public EqualCondition(String name, Object value) {
        super(name);
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public void applyCondition(StringBuilder filter) {
        Object parameterValue = this.value;
        if (Date.class.isInstance(this.value)) {
            parameterValue = LDAPUtil.formatDate((Date)parameterValue);
        }
        filter.append("(").append(this.getParameterName()).append("=").append(parameterValue).append(")");
    }

    public String toString() {
        return "EqualCondition{paramName=" + this.getParameterName() + ", value=" + this.value + '}';
    }
}

