/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers;

import java.util.List;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.LDAPStorageProviderFactory;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapperFactory;
import org.keycloak.storage.ldap.mappers.UserAttributeLDAPStorageMapper;

public class UserAttributeLDAPStorageMapperFactory
extends AbstractLDAPStorageMapperFactory {
    public static final String PROVIDER_ID = "user-attribute-ldap-mapper";
    protected static final List<ProviderConfigProperty> configProperties;

    private static List<ProviderConfigProperty> getConfigProps(ComponentModel parent) {
        String readOnly = "false";
        if (parent != null) {
            LDAPConfig ldapConfig = new LDAPConfig((MultivaluedHashMap<String, String>)parent.getConfig());
            readOnly = ldapConfig.getEditMode() == LDAPStorageProviderFactory.EditMode.WRITABLE ? "false" : "true";
        }
        return ProviderConfigurationBuilder.create().property().name("user.model.attribute").label("User Model Attribute").helpText("Name of mapped UserModel property or UserModel attribute in Keycloak DB. For example 'firstName', 'lastName, 'email', 'street' etc.").type("String").add().property().name("ldap.attribute").label("LDAP Attribute").helpText("Name of mapped attribute on LDAP object. For example 'cn', 'sn, 'mail', 'street' etc.").type("String").add().property().name("read.only").label("Read Only").helpText("Read-only attribute is imported from LDAP to Keycloak DB, but it's not saved back to LDAP when user is updated in Keycloak.").type("boolean").defaultValue((Object)readOnly).add().property().name("always.read.value.from.ldap").label("Always Read Value From LDAP").helpText("If on, then during reading of the user will be value of attribute from LDAP always used instead of the value from Keycloak DB").type("boolean").defaultValue((Object)"false").add().property().name("is.mandatory.in.ldap").label("Is Mandatory In LDAP").helpText("If true, attribute is mandatory in LDAP. Hence if there is no value in Keycloak DB, the empty value will be set to be propagated to LDAP").type("boolean").defaultValue((Object)"false").add().build();
    }

    @Override
    public String getHelpText() {
        return "Used to map single attribute from LDAP user to attribute of UserModel in Keycloak DB";
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel config) throws ComponentValidationException {
        this.checkMandatoryConfigAttribute("user.model.attribute", "User Model Attribute", config);
        this.checkMandatoryConfigAttribute("ldap.attribute", "LDAP Attribute", config);
    }

    @Override
    protected AbstractLDAPStorageMapper createMapper(ComponentModel mapperModel, LDAPStorageProvider federationProvider, RealmModel realm) {
        return new UserAttributeLDAPStorageMapper(mapperModel, federationProvider, realm);
    }

    public List<ProviderConfigProperty> getConfigProperties(RealmModel realm, ComponentModel parent) {
        return UserAttributeLDAPStorageMapperFactory.getConfigProps(parent);
    }

    static {
        List<ProviderConfigProperty> props = UserAttributeLDAPStorageMapperFactory.getConfigProps(null);
        configProperties = props;
    }
}

