/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.kerberos;

import java.util.Map;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.UserFederationProviderModel;

public abstract class CommonKerberosConfig {
    protected UserFederationProviderModel providerModel;
    protected ComponentModel componentModel;

    public CommonKerberosConfig(UserFederationProviderModel userFederationProvider) {
        this.providerModel = userFederationProvider;
    }

    public CommonKerberosConfig(ComponentModel componentModel) {
        this.componentModel = componentModel;
    }

    public boolean isAllowKerberosAuthentication() {
        if (this.providerModel != null) {
            return Boolean.valueOf(this.getConfig().get("allowKerberosAuthentication"));
        }
        return Boolean.valueOf((String)this.componentModel.getConfig().getFirst((Object)"allowKerberosAuthentication"));
    }

    public String getKerberosRealm() {
        if (this.providerModel != null) {
            return this.getConfig().get("kerberosRealm");
        }
        return (String)this.componentModel.getConfig().getFirst((Object)"kerberosRealm");
    }

    public String getServerPrincipal() {
        if (this.providerModel != null) {
            return this.getConfig().get("serverPrincipal");
        }
        return (String)this.componentModel.getConfig().getFirst((Object)"serverPrincipal");
    }

    public String getKeyTab() {
        if (this.providerModel != null) {
            return this.getConfig().get("keyTab");
        }
        return (String)this.componentModel.getConfig().getFirst((Object)"keyTab");
    }

    public boolean isDebug() {
        if (this.providerModel != null) {
            return Boolean.valueOf(this.getConfig().get("debug"));
        }
        return Boolean.valueOf((String)this.componentModel.getConfig().getFirst((Object)"debug"));
    }

    protected Map<String, String> getConfig() {
        return this.providerModel.getConfig();
    }
}

