/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import org.jgroups.util.Util;

public class bla5 {
    protected AsynchronousServerSocketChannel ch;

    protected void start() throws Exception {
        this.ch = AsynchronousServerSocketChannel.open();
        this.ch.bind(new InetSocketAddress("0.0.0.0", 7500));
        this.ch.accept(null, new AcceptHandler());
        Util.sleep(60000L);
    }

    public static void main(String[] args) throws Exception {
        new bla5().start();
    }

    protected static class Request {
        protected final ByteBuffer buf;
        protected final AsynchronousSocketChannel ch;

        public Request(ByteBuffer buf, AsynchronousSocketChannel ch) {
            this.buf = buf;
            this.ch = ch;
        }
    }

    protected static class ReadHandler
    implements CompletionHandler<Integer, Request> {
        protected ReadHandler() {
        }

        @Override
        public void completed(Integer result, Request req) {
            if (result < 0) {
                try {
                    req.ch.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                System.out.printf("read %d bytes\n", result);
                req.buf.clear();
                req.ch.read(req.buf, req, this);
            }
        }

        @Override
        public void failed(Throwable exc, Request attachment) {
            System.err.printf("read(): failed: %s\n", exc);
        }
    }

    protected static class AcceptHandler
    implements CompletionHandler<AsynchronousSocketChannel, Object> {
        protected AcceptHandler() {
        }

        @Override
        public void completed(AsynchronousSocketChannel result, Object attachment) {
            System.out.printf("accept(): sock is %s attachment is %s\n", result, attachment);
            Request req = new Request(ByteBuffer.allocate(1024), result);
            result.read(req.buf, req, new ReadHandler());
        }

        @Override
        public void failed(Throwable exc, Object attachment) {
            System.err.println("accept() failed: " + exc);
        }
    }
}

