/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.io.IOException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.xnio.OptionMap;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public class WorkerService
implements Service<XnioWorker> {
    private final OptionMap options;
    private XnioWorker worker;
    private volatile StopContext stopContext;

    public WorkerService(OptionMap options) {
        this.options = options;
    }

    public void start(StartContext startContext) throws StartException {
        Xnio xnio = Xnio.getInstance();
        try {
            this.worker = xnio.createWorker(null, this.options, this::stopDone);
        }
        catch (IOException e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext context) {
        this.stopContext = context;
        context.asynchronous();
        this.worker.shutdown();
        this.worker = null;
    }

    private void stopDone() {
        StopContext stopContext = this.stopContext;
        this.stopContext = null;
        assert (stopContext != null);
        stopContext.complete();
    }

    public XnioWorker getValue() throws IllegalStateException, IllegalArgumentException {
        return this.worker;
    }
}

