/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.spdy;

import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class SpdyPushBackParser {
    private byte[] pushedBackData;
    private boolean finished;
    protected int streamId = -1;
    private int remainingData;

    public SpdyPushBackParser(int frameLength) {
        this.remainingData = frameLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(ByteBuffer data) throws IOException {
        int used = 0;
        ByteBuffer dataToParse = data;
        int oldLimit = dataToParse.limit();
        try {
            if (this.pushedBackData != null) {
                dataToParse = ByteBuffer.wrap(new byte[this.pushedBackData.length + data.remaining()]);
                dataToParse.put(this.pushedBackData);
                dataToParse.put(data);
                dataToParse.flip();
                oldLimit = dataToParse.limit();
            }
            if (dataToParse.remaining() > this.remainingData) {
                dataToParse.limit(dataToParse.position() + this.remainingData);
            }
            int rem = dataToParse.remaining();
            this.handleData(dataToParse);
            used = rem - dataToParse.remaining();
        }
        finally {
            int leftOver = dataToParse.remaining();
            if (leftOver > 0) {
                this.pushedBackData = new byte[leftOver];
                dataToParse.get(this.pushedBackData);
            } else {
                this.pushedBackData = null;
            }
            dataToParse.limit(oldLimit);
            this.remainingData -= used;
            if (this.remainingData == 0) {
                this.finished = true;
                this.finished();
            }
        }
    }

    protected void finished() throws IOException {
    }

    protected abstract void handleData(ByteBuffer var1) throws IOException;

    public boolean isFinished() {
        return this.finished;
    }

    public int getStreamId() {
        return this.streamId;
    }
}

