/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class ClientSessionCode {
    private static final String ACTIVE_CODE = "active_code";
    private static final Logger logger = Logger.getLogger(ClientSessionCode.class);
    private static final String NEXT_CODE = ClientSessionCode.class.getName() + ".nextCode";
    private KeycloakSession session;
    private final RealmModel realm;
    private final ClientSessionModel clientSession;

    public ClientSessionCode(KeycloakSession session, RealmModel realm, ClientSessionModel clientSession) {
        this.session = session;
        this.realm = realm;
        this.clientSession = clientSession;
    }

    public static ParseResult parseResult(String code, KeycloakSession session, RealmModel realm) {
        ParseResult result = new ParseResult();
        if (code == null) {
            result.illegalHash = true;
            return result;
        }
        try {
            result.clientSession = ClientSessionCode.getClientSession(code, session, realm);
            if (result.clientSession == null) {
                result.clientSessionNotFound = true;
                return result;
            }
            if (!ClientSessionCode.verifyCode(code, result.clientSession)) {
                result.illegalHash = true;
                return result;
            }
            result.code = new ClientSessionCode(session, realm, result.clientSession);
            return result;
        }
        catch (RuntimeException e) {
            result.illegalHash = true;
            return result;
        }
    }

    public static ClientSessionCode parse(String code, KeycloakSession session, RealmModel realm) {
        try {
            ClientSessionModel clientSession = ClientSessionCode.getClientSession(code, session, realm);
            if (clientSession == null) {
                return null;
            }
            if (!ClientSessionCode.verifyCode(code, clientSession)) {
                return null;
            }
            return new ClientSessionCode(session, realm, clientSession);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static ClientSessionModel getClientSession(String code, KeycloakSession session, RealmModel realm) {
        try {
            String[] parts = code.split("\\.");
            String id = parts[1];
            return session.sessions().getClientSession(realm, id);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public ClientSessionModel getClientSession() {
        return this.clientSession;
    }

    public boolean isValid(String requestedAction, ActionType actionType) {
        if (!this.isValidAction(requestedAction)) {
            return false;
        }
        return this.isActionActive(actionType);
    }

    public boolean isActionActive(ActionType actionType) {
        int lifespan;
        int timestamp = this.clientSession.getTimestamp();
        switch (actionType) {
            case CLIENT: {
                lifespan = this.realm.getAccessCodeLifespan();
                break;
            }
            case LOGIN: {
                lifespan = this.realm.getAccessCodeLifespanLogin() > 0 ? this.realm.getAccessCodeLifespanLogin() : this.realm.getAccessCodeLifespanUserAction();
                break;
            }
            case USER: {
                lifespan = this.realm.getAccessCodeLifespanUserAction();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return timestamp + lifespan > Time.currentTime();
    }

    public boolean isValidAction(String requestedAction) {
        String action = this.clientSession.getAction();
        if (action == null) {
            return false;
        }
        return action.equals(requestedAction);
    }

    public Set<RoleModel> getRequestedRoles() {
        HashSet<RoleModel> requestedRoles = new HashSet<RoleModel>();
        for (String roleId : this.clientSession.getRoles()) {
            RoleModel role = this.realm.getRoleById(roleId);
            if (role == null) continue;
            requestedRoles.add(role);
        }
        return requestedRoles;
    }

    public Set<ProtocolMapperModel> getRequestedProtocolMappers() {
        HashSet<ProtocolMapperModel> requestedProtocolMappers = new HashSet<ProtocolMapperModel>();
        Set protocolMappers = this.clientSession.getProtocolMappers();
        ClientModel client = this.clientSession.getClient();
        ClientTemplateModel template = client.getClientTemplate();
        if (protocolMappers != null) {
            for (String protocolMapperId : protocolMappers) {
                ProtocolMapperModel protocolMapper = client.getProtocolMapperById(protocolMapperId);
                if (protocolMapper == null && template != null) {
                    protocolMapper = template.getProtocolMapperById(protocolMapperId);
                }
                if (protocolMapper == null) continue;
                requestedProtocolMappers.add(protocolMapper);
            }
        }
        return requestedProtocolMappers;
    }

    public void setAction(String action) {
        this.clientSession.setAction(action);
        this.clientSession.setTimestamp(Time.currentTime());
    }

    public String getCode() {
        String nextCode = (String)this.session.getAttribute(NEXT_CODE + "." + this.clientSession.getId());
        if (nextCode == null) {
            nextCode = ClientSessionCode.generateCode(this.clientSession);
            this.session.setAttribute(NEXT_CODE + "." + this.clientSession.getId(), (Object)nextCode);
        } else {
            logger.debug((Object)"Code already generated for session, using code from session attributes");
        }
        return nextCode;
    }

    private static String generateCode(ClientSessionModel clientSession) {
        try {
            String actionId = KeycloakModelUtils.generateSecret();
            StringBuilder sb = new StringBuilder();
            sb.append(actionId);
            sb.append('.');
            sb.append(clientSession.getId());
            String code = sb.toString();
            clientSession.setNote(ACTIVE_CODE, code);
            return code;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean verifyCode(String code, ClientSessionModel clientSession) {
        try {
            String activeCode = clientSession.getNote(ACTIVE_CODE);
            if (activeCode == null) {
                logger.debug((Object)"Active code not found in client session");
                return false;
            }
            clientSession.removeNote(ACTIVE_CODE);
            return code.equals(activeCode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class ParseResult {
        ClientSessionCode code;
        boolean clientSessionNotFound;
        boolean illegalHash;
        ClientSessionModel clientSession;

        public ClientSessionCode getCode() {
            return this.code;
        }

        public boolean isClientSessionNotFound() {
            return this.clientSessionNotFound;
        }

        public boolean isIllegalHash() {
            return this.illegalHash;
        }

        public ClientSessionModel getClientSession() {
            return this.clientSession;
        }
    }

    public static enum ActionType {
        CLIENT,
        LOGIN,
        USER;

    }
}

