/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder.dialect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.FunctionDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.dialect.java.JavaAnalysisResult;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaBlockDescr;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaCatchBlockDescr;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaContainerBlockDescr;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaElseBlockDescr;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaFinalBlockDescr;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaForBlockDescr;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaIfBlockDescr;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaInterfacePointsDescr;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaLocalDeclarationDescr;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaModifyBlockDescr;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaThrowBlockDescr;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaTryBlockDescr;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaWhileBlockDescr;
import org.drools.compiler.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.compiler.rule.builder.dialect.mvel.MVELConsequenceBuilder;
import org.drools.compiler.rule.builder.dialect.mvel.MVELDialect;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.rule.ConsequenceMetaData;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.ClassWireable;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.StringUtils;
import org.drools.core.util.bitmask.AllSetBitMask;
import org.drools.core.util.bitmask.BitMask;
import org.kie.api.definition.type.FactField;
import org.mvel2.CompileException;
import org.mvel2.Macro;
import org.mvel2.MacroProcessor;

public final class DialectUtil {
    private static final Pattern NON_ALPHA_REGEX = Pattern.compile("[ -/:-@\\[-`\\{-\\xff]");
    private static final Pattern LINE_BREAK_FINDER = Pattern.compile("\\r\\n|\\r|\\n");

    public static String getUniqueLegalName(String packageName, String name, int seed, String ext, String prefix, ResourceReader src) {
        String actualName;
        String newName = prefix + "_" + DialectUtil.normalizeRuleName(name);
        if (ext.equals("java")) {
            return newName + Math.abs(seed);
        }
        String fileName = packageName.replace('.', '/') + "/" + newName;
        if (src == null || !src.isAvailable(fileName + "." + ext)) {
            return newName;
        }
        int counter = -1;
        while (src.isAvailable(actualName = fileName + "_" + ++counter + "." + ext)) {
        }
        return newName + "_" + counter;
    }

    public static String fixBlockDescr(RuleBuildContext context, JavaAnalysisResult analysis, Map<String, Declaration> decls) {
        List<JavaBlockDescr> blocks = DialectUtil.buildBlockDescrs(new ArrayList<JavaBlockDescr>(), analysis.getBlockDescrs());
        return DialectUtil.fixBlockDescr(context, analysis, decls, blocks);
    }

    public static String fixBlockDescr(RuleBuildContext context, JavaAnalysisResult analysis, Map<String, Declaration> decls, List<JavaBlockDescr> blocks) {
        MVELDialect mvel = (MVELDialect)context.getDialect("mvel");
        String originalCode = analysis.getAnalyzedExpr();
        BoundIdentifiers bindings = analysis.getBoundIdentifiers();
        Collections.sort(blocks, new Comparator<JavaBlockDescr>(){

            @Override
            public int compare(JavaBlockDescr o1, JavaBlockDescr o2) {
                return o1.getStart() - o2.getStart();
            }
        });
        StringBuilder consequence = new StringBuilder();
        int lastAdded = 0;
        block5: for (JavaBlockDescr block : blocks) {
            if (block.getEnd() == 0 || block.getEnd() > originalCode.length()) continue;
            consequence.append(originalCode.substring(lastAdded, block.getStart() - 1));
            lastAdded = block.getEnd();
            switch (block.getType()) {
                case MODIFY: 
                case UPDATE: 
                case DELETE: {
                    DialectUtil.rewriteDescr(context, originalCode, mvel, consequence, block, bindings, decls);
                    continue block5;
                }
                case ENTRY: 
                case EXIT: 
                case CHANNEL: {
                    DialectUtil.rewriteInterfacePoint(context, originalCode, consequence, (JavaInterfacePointsDescr)block);
                    continue block5;
                }
                case INSERT: {
                    DialectUtil.parseInsertDescr(context, block);
                }
            }
            consequence.append(originalCode.substring(block.getStart() - 1, lastAdded));
        }
        consequence.append(originalCode.substring(lastAdded));
        return consequence.toString();
    }

    private static List<JavaBlockDescr> buildBlockDescrs(List<JavaBlockDescr> descrs, JavaContainerBlockDescr parentBlock) {
        for (JavaBlockDescr block : parentBlock.getJavaBlockDescrs()) {
            if (block instanceof JavaContainerBlockDescr) {
                DialectUtil.buildBlockDescrs(descrs, (JavaContainerBlockDescr)block);
                continue;
            }
            descrs.add(block);
        }
        return descrs;
    }

    public static void setContainerBlockInputs(RuleBuildContext context, List<JavaBlockDescr> descrs, JavaContainerBlockDescr parentBlock, String originalCode, BoundIdentifiers bindings, Map<String, Class<?>> parentVars, int offset) {
        StringBuilder consequence = new StringBuilder();
        int lastAdded = 0;
        for (JavaBlockDescr block : parentBlock.getJavaBlockDescrs()) {
            if (block.getEnd() == 0) continue;
            if (block.getType() == JavaBlockDescr.BlockType.TRY) {
                consequence.append(originalCode.substring(lastAdded, block.getStart() - 1 - offset));
                JavaTryBlockDescr tryDescr = (JavaTryBlockDescr)block;
                lastAdded = tryDescr.getFinal() != null ? tryDescr.getFinal().getEnd() - offset : tryDescr.getCatches().get(tryDescr.getCatches().size() - 1).getEnd() - offset;
                DialectUtil.stripTryDescr(originalCode, consequence, (JavaTryBlockDescr)block, offset);
                continue;
            }
            if (block.getType() == JavaBlockDescr.BlockType.THROW) {
                consequence.append(originalCode.substring(lastAdded, block.getStart() - 1 - offset));
                JavaThrowBlockDescr throwBlock = (JavaThrowBlockDescr)block;
                DialectUtil.addWhiteSpaces(originalCode, consequence, throwBlock.getStart() - offset, throwBlock.getTextStart() - offset);
                consequence.append(originalCode.substring(throwBlock.getTextStart() - offset - 1, throwBlock.getEnd() - 1 - offset)).append(";");
                lastAdded = throwBlock.getEnd() - offset;
                continue;
            }
            if (block.getType() == JavaBlockDescr.BlockType.IF) {
                consequence.append(originalCode.substring(lastAdded, block.getStart() - 1 - offset));
                JavaIfBlockDescr ifDescr = (JavaIfBlockDescr)block;
                lastAdded = ifDescr.getEnd() - offset;
                DialectUtil.stripBlockDescr(originalCode, consequence, ifDescr, offset);
                continue;
            }
            if (block.getType() == JavaBlockDescr.BlockType.ELSE) {
                consequence.append(originalCode.substring(lastAdded, block.getStart() - 1 - offset));
                JavaElseBlockDescr elseDescr = (JavaElseBlockDescr)block;
                lastAdded = elseDescr.getEnd() - offset;
                DialectUtil.stripBlockDescr(originalCode, consequence, elseDescr, offset);
                continue;
            }
            if (block.getType() == JavaBlockDescr.BlockType.WHILE) {
                consequence.append(originalCode.substring(lastAdded, block.getStart() - 1 - offset));
                JavaWhileBlockDescr whileDescr = (JavaWhileBlockDescr)block;
                lastAdded = whileDescr.getEnd() - offset;
                DialectUtil.stripBlockDescr(originalCode, consequence, whileDescr, offset);
                continue;
            }
            if (block.getType() != JavaBlockDescr.BlockType.FOR) continue;
            consequence.append(originalCode.substring(lastAdded, block.getStart() - 1 - offset));
            JavaForBlockDescr forDescr = (JavaForBlockDescr)block;
            lastAdded = forDescr.getEnd() - offset;
            DialectUtil.stripBlockDescr(originalCode, consequence, forDescr, offset);
        }
        consequence.append(originalCode.substring(lastAdded));
        MacroProcessor macroProcessor = new MacroProcessor();
        HashMap<String, Macro> macros = new HashMap<String, Macro>(MVELConsequenceBuilder.macros);
        macros.put("modify", new Macro(){

            public String doMacro() {
                return "with  ";
            }
        });
        macroProcessor.setMacros(macros);
        String mvelCode = macroProcessor.parse(consequence.toString());
        Map<String, Class<?>> inputs = DialectUtil.getInputs(context, mvelCode, bindings, parentVars);
        inputs.putAll(parentVars);
        parentBlock.setInputs(inputs);
        for (JavaBlockDescr block : parentBlock.getJavaBlockDescrs()) {
            if (block.getType() == JavaBlockDescr.BlockType.TRY) {
                JavaTryBlockDescr tryBlock = (JavaTryBlockDescr)block;
                DialectUtil.setContainerBlockInputs(context, descrs, tryBlock, originalCode.substring(tryBlock.getTextStart() - offset, tryBlock.getEnd() - 1 - offset), bindings, inputs, tryBlock.getTextStart());
                for (JavaCatchBlockDescr catchBlock : tryBlock.getCatches()) {
                    DialectUtil.setContainerBlockInputs(context, descrs, catchBlock, catchBlock.getClause() + "=null;" + originalCode.substring(catchBlock.getTextStart() - offset, catchBlock.getEnd() - 1 - offset), bindings, inputs, tryBlock.getTextStart());
                }
                if (tryBlock.getFinal() == null) continue;
                JavaFinalBlockDescr finalBlock = tryBlock.getFinal();
                DialectUtil.setContainerBlockInputs(context, descrs, finalBlock, originalCode.substring(finalBlock.getTextStart() - offset, finalBlock.getEnd() - 1 - offset), bindings, inputs, tryBlock.getTextStart());
                continue;
            }
            if (block.getType() == JavaBlockDescr.BlockType.IF) {
                JavaIfBlockDescr ifBlock = (JavaIfBlockDescr)block;
                int adjustBlock = originalCode.charAt(ifBlock.getTextStart() - offset - 1) == '{' ? 0 : 1;
                DialectUtil.setContainerBlockInputs(context, descrs, ifBlock, originalCode.substring(ifBlock.getTextStart() - offset + adjustBlock, ifBlock.getEnd() - 1 - offset - adjustBlock), bindings, inputs, ifBlock.getTextStart());
                continue;
            }
            if (block.getType() == JavaBlockDescr.BlockType.ELSE) {
                JavaElseBlockDescr elseBlock = (JavaElseBlockDescr)block;
                int adjustBlock = originalCode.charAt(elseBlock.getTextStart() - offset - 1) == '{' ? 0 : 1;
                DialectUtil.setContainerBlockInputs(context, descrs, elseBlock, originalCode.substring(elseBlock.getTextStart() - offset + adjustBlock, elseBlock.getEnd() - 1 - offset - adjustBlock), bindings, inputs, elseBlock.getTextStart());
                continue;
            }
            if (block.getType() == JavaBlockDescr.BlockType.WHILE) {
                JavaWhileBlockDescr whileBlock = (JavaWhileBlockDescr)block;
                int adjustBlock = originalCode.charAt(whileBlock.getTextStart() - offset - 1) == '{' ? 0 : 1;
                DialectUtil.setContainerBlockInputs(context, descrs, whileBlock, originalCode.substring(whileBlock.getTextStart() - offset + adjustBlock, whileBlock.getEnd() - 1 - offset - adjustBlock), bindings, inputs, whileBlock.getTextStart());
                continue;
            }
            if (block.getType() == JavaBlockDescr.BlockType.FOR) {
                JavaForBlockDescr forBlock = (JavaForBlockDescr)block;
                int adjustBlock = originalCode.charAt(forBlock.getTextStart() - offset - 1) == '{' ? 0 : 1;
                DialectUtil.setContainerBlockInputs(context, descrs, forBlock, originalCode.substring(forBlock.getStartParen() - offset, forBlock.getInitEnd() - offset) + originalCode.substring(forBlock.getTextStart() - offset + adjustBlock, forBlock.getEnd() - 1 - offset - adjustBlock), bindings, inputs, forBlock.getTextStart() - (forBlock.getInitEnd() - forBlock.getStartParen()));
                continue;
            }
            block.setInputs(inputs);
            descrs.add(block);
        }
    }

    private static Map<String, Class<?>> getInputs(RuleBuildContext context, String code, BoundIdentifiers bindings, Map<String, Class<?>> parentVars) {
        MVELDialect mvel = (MVELDialect)context.getDialect("mvel");
        MVELAnalysisResult mvelAnalysis = null;
        try {
            mvelAnalysis = (MVELAnalysisResult)mvel.analyzeBlock(context, code, bindings, parentVars, "drools", KnowledgeHelper.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mvelAnalysis != null ? mvelAnalysis.getMvelVariables() : new HashMap();
    }

    private static void addWhiteSpaces(String original, StringBuilder consequence, int start, int end) {
        block3: for (int i = start; i < end; ++i) {
            switch (original.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    consequence.append(original.charAt(i));
                    continue block3;
                }
                default: {
                    consequence.append(" ");
                }
            }
        }
    }

    private static void stripTryDescr(String originalCode, StringBuilder consequence, JavaTryBlockDescr block, int offset) {
        DialectUtil.addWhiteSpaces(originalCode, consequence, consequence.length(), block.getTextStart() - offset);
        DialectUtil.addWhiteSpaces(originalCode, consequence, consequence.length(), block.getEnd() - offset);
        for (JavaCatchBlockDescr catchBlock : block.getCatches()) {
            DialectUtil.addWhiteSpaces(originalCode, consequence, consequence.length(), catchBlock.getTextStart() - offset);
            DialectUtil.addWhiteSpaces(originalCode, consequence, consequence.length(), catchBlock.getEnd() - offset);
        }
        if (block.getFinal() != null) {
            DialectUtil.addWhiteSpaces(originalCode, consequence, consequence.length(), block.getFinal().getTextStart() - offset);
            DialectUtil.addWhiteSpaces(originalCode, consequence, consequence.length(), block.getFinal().getEnd() - offset);
        }
    }

    private static void stripBlockDescr(String originalCode, StringBuilder consequence, JavaBlockDescr block, int offset) {
        DialectUtil.addWhiteSpaces(originalCode, consequence, consequence.length(), block.getEnd() - offset);
    }

    private static void rewriteInterfacePoint(RuleBuildContext context, String originalCode, StringBuilder consequence, JavaInterfacePointsDescr ep) {
        consequence.append("drools.get");
        if (ep.getType() == JavaBlockDescr.BlockType.EXIT) {
            consequence.append("ExitPoint( ");
        } else if (ep.getType() == JavaBlockDescr.BlockType.ENTRY) {
            consequence.append("EntryPoint( ");
        } else if (ep.getType() == JavaBlockDescr.BlockType.CHANNEL) {
            consequence.append("Channel( ");
        } else {
            context.addError(new DescrBuildError(context.getParentDescr(), context.getRuleDescr(), ep, "Unable to rewrite code block: " + ep + "\n"));
            return;
        }
        consequence.append(ep.getId());
        consequence.append(" )");
        String originalBlock = originalCode.substring(ep.getStart() - 1, ep.getEnd());
        int end = originalBlock.indexOf("]");
        DialectUtil.addLineBreaks(consequence, originalBlock.substring(0, end));
    }

    private static boolean rewriteDescr(RuleBuildContext context, String originalCode, MVELDialect mvel, StringBuilder consequence, JavaBlockDescr d, BoundIdentifiers bindings, Map<String, Declaration> decls) {
        if (d.getEnd() == 0) {
            return false;
        }
        boolean typeSafety = context.isTypesafe();
        context.setTypesafe(false);
        Map<String, Class<?>> localTypes = d.getInputs();
        if (d.getInScopeLocalVars() != null && !d.getInScopeLocalVars().isEmpty()) {
            localTypes = new HashMap(d.getInputs() != null ? d.getInputs() : Collections.EMPTY_MAP);
            for (JavaLocalDeclarationDescr local : d.getInScopeLocalVars()) {
                try {
                    Class type = context.getDialect("java").getPackageRegistry().getTypeResolver().resolveType(local.getRawType());
                    for (JavaLocalDeclarationDescr.IdentifierDescr id : local.getIdentifiers()) {
                        localTypes.put(id.getIdentifier(), type);
                    }
                }
                catch (ClassNotFoundException e) {
                    context.addError(new DescrBuildError(context.getRuleDescr(), context.getParentDescr(), null, "Unable to resolve type " + local.getRawType() + ":\n" + e.getMessage()));
                }
            }
        }
        MVELAnalysisResult mvelAnalysis = (MVELAnalysisResult)mvel.analyzeBlock(context, d.getTargetExpression(), bindings, localTypes, "drools", KnowledgeHelper.class);
        context.setTypesafe(typeSafety);
        if (mvelAnalysis == null) {
            return false;
        }
        Class ret = mvelAnalysis.getReturnType();
        if (ret == null) {
            context.addError(new DescrBuildError(context.getParentDescr(), context.getRuleDescr(), originalCode, "Unable to determine the resulting type of the expression: " + d.getTargetExpression() + "\n"));
            return false;
        }
        String retString = ClassUtils.canonicalName((Class)ret);
        String declrString = d.getTargetExpression().charAt(0) == '(' ? d.getTargetExpression().substring(1, d.getTargetExpression().length() - 1).trim() : d.getTargetExpression();
        String obj = declrString;
        Declaration declr = decls.get(declrString);
        consequence.append("{ ");
        if (declr == null) {
            obj = "__obj__";
            consequence.append(retString);
            consequence.append(" ");
            consequence.append(obj);
            consequence.append(" = ");
            consequence.append(d.getTargetExpression());
            consequence.append("; ");
        }
        if (declr == null || declr.isInternalFact()) {
            consequence.append("org.kie.api.runtime.rule.FactHandle ");
            consequence.append(obj);
            consequence.append("__Handle2__ = drools.getFactHandle(");
            consequence.append(obj);
            consequence.append(");");
        }
        String originalBlock = originalCode.substring(d.getStart() - 1, d.getEnd());
        switch (d.getType()) {
            case MODIFY: {
                DialectUtil.rewriteModifyDescr(context, d, originalBlock, consequence, declr, obj);
                break;
            }
            case UPDATE: {
                DialectUtil.rewriteUpdateDescr(context, d, consequence, declr, obj);
                break;
            }
            case DELETE: {
                DialectUtil.rewriteDeleteDescr(context, d, consequence, declr, obj);
            }
        }
        return declr != null;
    }

    private static void rewriteModifyDescr(RuleBuildContext context, JavaBlockDescr d, String originalBlock, StringBuilder consequence, Declaration declr, String obj) {
        boolean isPropertyReactive;
        List settableProperties = null;
        Class<?> typeClass = DialectUtil.findModifiedClass(context, d, declr);
        TypeDeclaration typeDeclaration = typeClass == null ? null : context.getKnowledgeBuilder().getTypeDeclaration(typeClass);
        boolean bl = isPropertyReactive = typeDeclaration != null && typeDeclaration.isPropertyReactive();
        if (isPropertyReactive) {
            typeDeclaration.setTypeClass(typeClass);
            settableProperties = typeDeclaration.getSettableProperties();
        }
        ConsequenceMetaData.Statement statement = null;
        if (typeDeclaration != null) {
            statement = new ConsequenceMetaData.Statement(ConsequenceMetaData.Statement.Type.MODIFY, typeClass);
            context.getRule().getConsequenceMetaData().addStatement(statement);
        }
        BitMask modificationMask = isPropertyReactive ? PropertySpecificUtil.getEmptyPropertyReactiveMask((int)settableProperties.size()) : PropertySpecificUtil.allSetButTraitBitMask();
        int end = originalBlock.indexOf("{");
        if (end == -1) {
            context.addError(new DescrBuildError(context.getParentDescr(), context.getRuleDescr(), null, "Block missing after modify" + d.getTargetExpression() + " ?\n"));
            return;
        }
        DialectUtil.addLineBreaks(consequence, originalBlock.substring(0, end));
        int start = end + 1;
        for (String exprStr : ((JavaModifyBlockDescr)d).getExpressions()) {
            end = originalBlock.indexOf(exprStr, start);
            DialectUtil.addLineBreaks(consequence, originalBlock.substring(start, end));
            consequence.append(obj).append(".");
            consequence.append(exprStr);
            consequence.append("; ");
            start = end + exprStr.length();
            if (typeDeclaration == null) continue;
            modificationMask = DialectUtil.parseModifiedProperties(statement, settableProperties, typeDeclaration, isPropertyReactive, modificationMask, exprStr);
        }
        DialectUtil.addLineBreaks(consequence, originalBlock.substring(end));
        DialectUtil.appendUpdateStatement(consequence, declr, obj, modificationMask, typeClass);
    }

    private static void rewriteUpdateDescr(RuleBuildContext context, JavaBlockDescr d, StringBuilder consequence, Declaration declr, String obj) {
        TypeDeclaration typeDeclaration;
        AllSetBitMask modificationMask = AllSetBitMask.get();
        Class<?> typeClass = DialectUtil.findModifiedClass(context, d, declr);
        TypeDeclaration typeDeclaration2 = typeDeclaration = typeClass == null ? null : context.getKnowledgeBuilder().getTypeDeclaration(typeClass);
        if (typeDeclaration != null) {
            boolean isPropertyReactive = typeDeclaration.isPropertyReactive();
            List settableProperties = null;
            if (isPropertyReactive) {
                typeDeclaration.setTypeClass(typeClass);
                settableProperties = typeDeclaration.getSettableProperties();
                modificationMask = PropertySpecificUtil.getEmptyPropertyReactiveMask((int)settableProperties.size());
            }
            ConsequenceMetaData.Statement statement = new ConsequenceMetaData.Statement(ConsequenceMetaData.Statement.Type.MODIFY, typeClass);
            context.getRule().getConsequenceMetaData().addStatement(statement);
            for (String expr : StringUtils.splitStatements((CharSequence)consequence)) {
                String updateExpr = expr.replaceFirst("^\\Q" + obj + "\\E\\s*\\.", "");
                if (updateExpr.equals(expr)) continue;
                modificationMask = DialectUtil.parseModifiedProperties(statement, settableProperties, typeDeclaration, isPropertyReactive, (BitMask)modificationMask, updateExpr);
            }
        }
        DialectUtil.appendUpdateStatement(consequence, declr, obj, (BitMask)modificationMask, typeClass);
    }

    private static void appendUpdateStatement(StringBuilder consequence, Declaration declr, String obj, BitMask modificationMask, Class<?> typeClass) {
        boolean isInternalFact = declr == null || declr.isInternalFact();
        consequence.append("drools.update( ").append(obj).append(isInternalFact ? "__Handle2__, " : "__Handle__, ").append(modificationMask.getInstancingStatement()).append(", ").append(typeClass != null ? typeClass.getCanonicalName() : "java.lang.Object").append(".class").append(" ); }");
    }

    private static BitMask parseModifiedProperties(ConsequenceMetaData.Statement statement, List<String> settableProperties, TypeDeclaration typeDeclaration, boolean propertyReactive, BitMask modificationMask, String exprStr) {
        int endMethodName = exprStr.indexOf(40);
        if (endMethodName >= 0) {
            String methodName = exprStr.substring(0, endMethodName).trim();
            String propertyName = ClassUtils.setter2property((String)methodName);
            int endMethodArgs = StringUtils.findEndOfMethodArgsIndex((CharSequence)exprStr, (int)endMethodName);
            String methodParams = exprStr.substring(endMethodName + 1, endMethodArgs).trim();
            List args = StringUtils.splitArgumentsList((CharSequence)methodParams);
            int argsNr = args.size();
            if (propertyName == null && exprStr.length() > endMethodArgs + 1 && exprStr.substring(endMethodArgs + 1).trim().startsWith(".")) {
                propertyName = ClassUtils.getter2property((String)methodName);
            }
            if (propertyName != null) {
                modificationMask = DialectUtil.updateModificationMask(settableProperties, propertyReactive, modificationMask, propertyName);
                statement.addField(propertyName, argsNr > 0 ? (String)args.get(0) : null);
            }
            String methodWithArgsNr = methodName + "_" + argsNr;
            List modifiedProps = typeDeclaration.getTypeClassDef().getModifiedPropsByMethod(methodWithArgsNr);
            if (modifiedProps != null) {
                for (String modifiedProp : modifiedProps) {
                    modificationMask = DialectUtil.updateModificationMask(settableProperties, propertyReactive, modificationMask, modifiedProp);
                    statement.addField(modifiedProp, argsNr > 0 ? (String)args.get(0) : null);
                }
            }
        } else {
            String propertyName = StringUtils.extractFirstIdentifier((String)exprStr, (int)0);
            modificationMask = DialectUtil.updateModificationMask(settableProperties, propertyReactive, modificationMask, propertyName);
            int equalPos = exprStr.indexOf(61);
            if (equalPos >= 0) {
                String value = exprStr.substring(equalPos + 1).trim();
                statement.addField(propertyName, value);
            }
        }
        return modificationMask;
    }

    private static BitMask updateModificationMask(List<String> settableProperties, boolean propertyReactive, BitMask modificationMask, String propertyName) {
        int index;
        if (propertyReactive && (index = settableProperties.indexOf(propertyName)) >= 0) {
            modificationMask = PropertySpecificUtil.setPropertyOnMask((BitMask)modificationMask, (int)index);
        }
        return modificationMask;
    }

    private static Class<?> findModifiedClass(RuleBuildContext context, JavaBlockDescr d, Declaration declr) {
        int endCast;
        if (declr != null) {
            return ((ClassWireable)declr.getPattern().getObjectType()).getClassType();
        }
        String targetId = d.getTargetExpression().trim();
        while (targetId.charAt(0) == '(' && targetId.charAt(targetId.length() - 1) == ')') {
            targetId = targetId.substring(1, targetId.length() - 1).trim();
        }
        if (targetId.charAt(0) == '(' && (endCast = targetId.indexOf(41)) > 0) {
            String castName = targetId.substring(1, endCast).trim();
            Class<?> cast = DialectUtil.findClassByName(context, castName);
            if (cast != null) {
                return cast;
            }
            targetId = targetId.substring(endCast + 1).trim();
        }
        return targetId.contains("(") ? DialectUtil.findFunctionReturnedClass(context, targetId) : DialectUtil.findDeclarationClass(context, d, targetId);
    }

    private static Class<?> findDeclarationClass(RuleBuildContext context, JavaBlockDescr d, String statement) {
        Class<?> inputClass;
        Class<?> clazz = inputClass = d.getInputs() == null ? null : d.getInputs().get(statement);
        if (inputClass != null) {
            return inputClass;
        }
        List<JavaLocalDeclarationDescr> localDeclarationDescrs = d.getInScopeLocalVars();
        if (localDeclarationDescrs == null) {
            return null;
        }
        String className = null;
        for (JavaLocalDeclarationDescr localDeclr : localDeclarationDescrs) {
            for (JavaLocalDeclarationDescr.IdentifierDescr idDescr : localDeclr.getIdentifiers()) {
                if (!statement.equals(idDescr.getIdentifier())) continue;
                className = localDeclr.getType();
                break;
            }
            if (className == null) continue;
            break;
        }
        return DialectUtil.findClassByName(context, className);
    }

    public static Class<?> findClassByName(RuleBuildContext context, String className) {
        if (className == null) {
            return null;
        }
        String namespace = context.getRuleDescr().getNamespace();
        KnowledgeBuilderImpl packageBuilder = context.getKnowledgeBuilder();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className.indexOf(46) < 0 ? namespace + "." + className : className, false, packageBuilder.getRootClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz != null) {
            return clazz;
        }
        HashSet<String> imports = new HashSet<String>();
        List<PackageDescr> pkgDescrs = packageBuilder.getPackageDescrs(namespace);
        if (pkgDescrs == null) {
            return null;
        }
        for (PackageDescr pkgDescr : pkgDescrs) {
            for (ImportDescr importDescr : pkgDescr.getImports()) {
                imports.add(importDescr.getTarget());
            }
        }
        return ClassUtils.findClass((String)className, imports, (ClassLoader)packageBuilder.getRootClassLoader());
    }

    private static Class<?> findFunctionReturnedClass(RuleBuildContext context, String statement) {
        String functionName = statement.substring(0, statement.indexOf(40));
        FunctionDescr function = DialectUtil.lookupFunction(context, functionName);
        return function == null ? null : DialectUtil.findClassByName(context, function.getReturnType());
    }

    private static boolean rewriteDeleteDescr(RuleBuildContext context, JavaBlockDescr d, StringBuilder consequence, Declaration declr, String obj) {
        Class<?> typeClass = DialectUtil.findModifiedClass(context, d, declr);
        if (typeClass != null) {
            ConsequenceMetaData.Statement statement = new ConsequenceMetaData.Statement(ConsequenceMetaData.Statement.Type.RETRACT, typeClass);
            context.getRule().getConsequenceMetaData().addStatement(statement);
        }
        if (declr != null && !declr.isInternalFact()) {
            consequence.append("drools.delete( ").append(obj).append("__Handle__ ); }");
        } else {
            consequence.append("drools.delete( ").append(obj).append("__Handle2__ ); }");
        }
        return declr != null;
    }

    private static void parseInsertDescr(RuleBuildContext context, JavaBlockDescr block) {
        int argsStart;
        String expr = block.getTargetExpression();
        if (expr.startsWith("new ") && (argsStart = expr.indexOf(40)) > 0) {
            TypeDeclaration typeDeclaration;
            String className = expr.substring(4, argsStart).trim();
            Class<?> typeClass = DialectUtil.findClassByName(context, className);
            TypeDeclaration typeDeclaration2 = typeDeclaration = typeClass == null ? null : context.getKnowledgeBuilder().getTypeDeclaration(typeClass);
            if (typeDeclaration != null) {
                ConsequenceMetaData.Statement statement = new ConsequenceMetaData.Statement(ConsequenceMetaData.Statement.Type.INSERT, typeClass);
                context.getRule().getConsequenceMetaData().addStatement(statement);
                String constructorParams = expr.substring(argsStart + 1, expr.indexOf(41)).trim();
                List args = StringUtils.splitArgumentsList((CharSequence)constructorParams);
                ClassDefinition classDefinition = typeDeclaration.getTypeClassDef();
                List fields = classDefinition.getFields();
                if (args.size() == fields.size()) {
                    for (int i = 0; i < args.size(); ++i) {
                        statement.addField(((FactField)fields.get(i)).getName(), (String)args.get(i));
                    }
                }
            }
        }
    }

    private static void addLineBreaks(StringBuilder consequence, String chunk) {
        Matcher m = LINE_BREAK_FINDER.matcher(chunk);
        while (m.find()) {
            consequence.append("\n");
        }
    }

    public static void copyErrorLocation(Exception e, BaseDescr descr) {
        if (e instanceof CompileException) {
            CompileException compileException = (CompileException)e;
            compileException.setLineNumber(descr.getLine());
            compileException.setColumn(descr.getColumn());
        }
    }

    private static FunctionDescr lookupFunction(RuleBuildContext context, String functionName) {
        String packageName = context.getRule().getPackageName();
        List<PackageDescr> pkgDescrs = context.getKnowledgeBuilder().getPackageDescrs(packageName);
        for (PackageDescr pkgDescr : pkgDescrs) {
            for (FunctionDescr function : pkgDescr.getFunctions()) {
                if (!function.getName().equals(functionName)) continue;
                return function;
            }
        }
        return null;
    }

    static String normalizeRuleName(String name) {
        String normalized = name.replace(' ', '_');
        if (!NON_ALPHA_REGEX.matcher(normalized).find()) {
            return normalized;
        }
        StringBuilder sb = new StringBuilder(normalized.length());
        for (char ch : normalized.toCharArray()) {
            if (ch == '$') {
                sb.append("_dollar_");
                continue;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                sb.append(ch);
                continue;
            }
            sb.append("$u").append((int)ch).append("$");
        }
        return sb.toString();
    }
}

