/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.bytecode;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.reflect.Method;
import org.jboss.classfilewriter.util.DescriptorUtils;
import org.jboss.weld.util.bytecode.MethodInformation;

public class RuntimeMethodInformation
implements MethodInformation {
    private final Method method;
    private final String descriptor;
    private final String[] parameterTypes;
    private final String returnType;
    private final String declaringClass;
    private final int modifier;

    public RuntimeMethodInformation(Method method) {
        this.method = method;
        this.parameterTypes = DescriptorUtils.parameterDescriptors((Method)method);
        this.returnType = DescriptorUtils.makeDescriptor(method.getReturnType());
        this.descriptor = DescriptorUtils.methodDescriptor((String[])this.parameterTypes, (String)this.returnType);
        this.declaringClass = method.getDeclaringClass().getName();
        int modifier = method.isBridge() ? 4161 : 1;
        if (method.isVarArgs()) {
            modifier |= 0x80;
        }
        this.modifier = modifier;
    }

    @Override
    public String getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public String getDescriptor() {
        return this.descriptor;
    }

    @Override
    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public String getReturnType() {
        return this.returnType;
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public int getModifiers() {
        return this.modifier;
    }
}

