/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.browser;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.authenticators.browser.ScriptBasedAuthenticator;
import org.keycloak.common.Profile;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;

public class ScriptBasedAuthenticatorFactory
implements AuthenticatorFactory,
EnvironmentDependentProviderFactory {
    private static final Logger LOGGER = Logger.getLogger(ScriptBasedAuthenticatorFactory.class);
    public static final String PROVIDER_ID = "auth-script-based";
    static final AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.OPTIONAL, AuthenticationExecutionModel.Requirement.DISABLED};
    static final ScriptBasedAuthenticator SINGLETON = new ScriptBasedAuthenticator();

    public Authenticator create(KeycloakSession session) {
        return SINGLETON;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getReferenceCategory() {
        return "script";
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean isUserSetupAllowed() {
        return true;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public String getDisplayType() {
        return "Script";
    }

    public String getHelpText() {
        return "Script based authentication. Allows to define custom authentication logic via JavaScript.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        ProviderConfigProperty name = new ProviderConfigProperty();
        name.setType("String");
        name.setName("scriptName");
        name.setLabel("Script Name");
        name.setHelpText("The name of the script used to authenticate.");
        ProviderConfigProperty description = new ProviderConfigProperty();
        description.setType("String");
        description.setName("scriptDescription");
        description.setLabel("Script Description");
        description.setHelpText("The description of the script used to authenticate.");
        ProviderConfigProperty script = new ProviderConfigProperty();
        script.setType("Script");
        script.setName("scriptCode");
        script.setLabel("Script Source");
        String scriptTemplate = "//enter your script code here";
        try {
            scriptTemplate = StreamUtil.readString((InputStream)this.getClass().getResourceAsStream("/scripts/authenticator-template.js"));
        }
        catch (IOException ioe) {
            LOGGER.warn((Object)ioe);
        }
        script.setDefaultValue((Object)scriptTemplate);
        script.setHelpText("The script used to authenticate. Scripts must at least define a function with the name 'authenticate(context)' that accepts a context (AuthenticationFlowContext) parameter.\nThis authenticator exposes the following additional variables: 'script', 'realm', 'user', 'session', 'httpRequest', 'LOG'");
        return Arrays.asList(name, description, script);
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.SCRIPTS);
    }
}

