/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc.mappers;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.broker.provider.AbstractIdentityProviderMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderConfigProperty;

public abstract class AbstractJsonUserAttributeMapper
extends AbstractIdentityProviderMapper {
    protected static final Logger logger = Logger.getLogger(AbstractJsonUserAttributeMapper.class);
    protected static final Logger LOGGER_DUMP_USER_PROFILE = Logger.getLogger((String)"org.keycloak.social.user_profile_dump");
    private static final String JSON_PATH_DELIMITER = ".";
    public static final String CONF_JSON_FIELD = "jsonField";
    public static final String CONF_USER_ATTRIBUTE = "userAttribute";
    public static final String CONTEXT_JSON_NODE = "UserInfo";
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public static void storeUserProfileForMapper(BrokeredIdentityContext user, JsonNode profile, String provider) {
        user.getContextData().put(CONTEXT_JSON_NODE, profile);
        if (LOGGER_DUMP_USER_PROFILE.isDebugEnabled()) {
            LOGGER_DUMP_USER_PROFILE.debug((Object)("User Profile JSON Data for provider " + provider + ": " + profile));
        }
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getDisplayCategory() {
        return "Attribute Importer";
    }

    public String getDisplayType() {
        return "Attribute Importer";
    }

    public String getHelpText() {
        return "Import user profile information if it exists in Social provider JSON data into the specified user attribute.";
    }

    public void preprocessFederatedIdentity(KeycloakSession session, RealmModel realm, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String attribute = (String)mapperModel.getConfig().get(CONF_USER_ATTRIBUTE);
        if (attribute == null || attribute.trim().isEmpty()) {
            logger.warnf("Attribute is not configured for mapper %s", (Object)mapperModel.getName());
            return;
        }
        attribute = attribute.trim();
        Object value = AbstractJsonUserAttributeMapper.getJsonValue(mapperModel, context);
        if (value != null) {
            if (value instanceof List) {
                context.setUserAttribute(attribute, (List)value);
            } else {
                context.setUserAttribute(attribute, value.toString());
            }
        }
    }

    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
    }

    protected static Object getJsonValue(IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String jsonField = (String)mapperModel.getConfig().get(CONF_JSON_FIELD);
        if (jsonField == null || jsonField.trim().isEmpty()) {
            logger.warnf("JSON field path is not configured for mapper %s", (Object)mapperModel.getName());
            return null;
        }
        if ((jsonField = jsonField.trim()).startsWith(JSON_PATH_DELIMITER) || jsonField.endsWith(JSON_PATH_DELIMITER) || jsonField.startsWith("[")) {
            logger.warnf("JSON field path is invalid %s", (Object)jsonField);
            return null;
        }
        JsonNode profileJsonNode = (JsonNode)context.getContextData().get(CONTEXT_JSON_NODE);
        Object value = AbstractJsonUserAttributeMapper.getJsonValue(profileJsonNode, jsonField);
        if (value == null) {
            logger.debugf("User profile JSON value '%s' is not available.", (Object)jsonField);
        }
        return value;
    }

    public static Object getJsonValue(JsonNode baseNode, String fieldPath) {
        logger.debug((Object)("Going to process JsonNode path " + fieldPath + " on data " + baseNode));
        if (baseNode != null) {
            int idx = fieldPath.indexOf(JSON_PATH_DELIMITER);
            String currentFieldName = fieldPath;
            if (idx > 0 && (currentFieldName = fieldPath.substring(0, idx).trim()).isEmpty()) {
                logger.debug((Object)("JSON path is invalid " + fieldPath));
                return null;
            }
            String currentNodeName = currentFieldName;
            int arrayIndex = -1;
            if (currentFieldName.endsWith("]")) {
                int bi = currentFieldName.indexOf("[");
                if (bi == -1) {
                    logger.debug((Object)("Invalid array index construct in " + currentFieldName));
                    return null;
                }
                try {
                    String is = currentFieldName.substring(bi + 1, currentFieldName.length() - 1).trim();
                    arrayIndex = Integer.parseInt(is);
                }
                catch (Exception e) {
                    logger.debug((Object)("Invalid array index construct in " + currentFieldName));
                    return null;
                }
                currentNodeName = currentFieldName.substring(0, bi).trim();
            }
            JsonNode currentNode = baseNode.get(currentNodeName);
            if (arrayIndex > -1 && currentNode.isArray()) {
                logger.debug((Object)("Going to take array node at index " + arrayIndex));
                currentNode = currentNode.get(arrayIndex);
            }
            if (currentNode == null) {
                logger.debug((Object)("JsonNode not found for name " + currentFieldName));
                return null;
            }
            if (idx < 0) {
                if (currentNode.isArray()) {
                    ArrayList<String> values = new ArrayList<String>();
                    for (JsonNode childNode : currentNode) {
                        if (childNode.isTextual()) {
                            values.add(childNode.textValue());
                            continue;
                        }
                        logger.warn((Object)("JsonNode in array is not text value " + childNode));
                    }
                    if (values.isEmpty()) {
                        return null;
                    }
                    return arrayIndex == idx ? values : null;
                }
                if (!currentNode.isValueNode()) {
                    logger.debug((Object)("JsonNode is not value node for name " + currentFieldName));
                    return null;
                }
                String ret = currentNode.asText();
                if (ret != null && !ret.trim().isEmpty()) {
                    return ret.trim();
                }
            } else {
                return AbstractJsonUserAttributeMapper.getJsonValue(currentNode, fieldPath.substring(idx + 1));
            }
        }
        return null;
    }

    static {
        ProviderConfigProperty property1 = new ProviderConfigProperty();
        property1.setName(CONF_JSON_FIELD);
        property1.setLabel("Social Profile JSON Field Path");
        property1.setHelpText("Path of field in Social provider User Profile JSON data to get value from. You can use dot notation for nesting and square brackets for array index. Eg. 'contact.address[0].country'.");
        property1.setType("String");
        configProperties.add(property1);
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(CONF_USER_ATTRIBUTE);
        property.setLabel("User Attribute Name");
        property.setHelpText("User attribute name to store information into.");
        property.setType("String");
        configProperties.add(property);
    }
}

