/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.sssd.api;

import cx.ath.matthew.LibraryLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.Variant;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.sssd.infopipe.InfoPipe;
import org.jboss.logging.Logger;
import org.keycloak.federation.sssd.api.SSSDException;

public class Sssd {
    private static DBusConnection dBusConnection;
    private String username;
    private static final Logger logger;

    public static void disconnect() {
        dBusConnection.disconnect();
    }

    private Sssd() {
    }

    public Sssd(String username) {
        this.username = username;
        try {
            if (LibraryLoader.load().succeed()) {
                dBusConnection = DBusConnection.getConnection(0);
            }
        }
        catch (DBusException e) {
            e.printStackTrace();
        }
    }

    public static String getRawAttribute(Variant variant) {
        Vector value;
        if (variant != null && (value = (Vector)variant.getValue()).size() >= 1) {
            return value.get(0).toString();
        }
        return null;
    }

    public Map<String, Variant> getUserAttributes() {
        String[] attr = new String[]{"mail", "givenname", "sn", "telephoneNumber"};
        Map<String, Variant> attributes = null;
        try {
            InfoPipe infoPipe = dBusConnection.getRemoteObject("org.freedesktop.sssd.infopipe", "/org/freedesktop/sssd/infopipe", InfoPipe.class);
            attributes = infoPipe.getUserAttributes(this.username, Arrays.asList(attr));
        }
        catch (Exception e) {
            throw new SSSDException("Failed to retrieve user's attributes. Check if SSSD service is active.");
        }
        return attributes;
    }

    public List<String> getUserGroups() {
        List<String> userGroups;
        try {
            InfoPipe infoPipe = dBusConnection.getRemoteObject("org.freedesktop.sssd.infopipe", "/org/freedesktop/sssd/infopipe", InfoPipe.class);
            userGroups = infoPipe.getUserGroups(this.username);
        }
        catch (Exception e) {
            throw new SSSDException("Failed to retrieve user's groups from SSSD. Check if SSSD service is active.");
        }
        return userGroups;
    }

    public static boolean isAvailable() {
        boolean sssdAvailable = false;
        try {
            if (LibraryLoader.load().succeed()) {
                DBusConnection connection = DBusConnection.getConnection(0);
                InfoPipe infoPipe = connection.getRemoteObject("org.freedesktop.sssd.infopipe", "/org/freedesktop/sssd/infopipe", InfoPipe.class);
                if (infoPipe.ping("PING") == null || infoPipe.ping("PING").isEmpty()) {
                    logger.debugv("SSSD is not available in your system. Federation provider will be disabled.", new Object[0]);
                } else {
                    sssdAvailable = true;
                }
            } else {
                logger.debugv("The RPM libunix-dbus-java is not installed. SSSD Federation provider will be disabled.", new Object[0]);
            }
        }
        catch (Exception e) {
            logger.debugv("SSSD is not available in your system. Federation provider will be disabled.", (Object)e);
        }
        return sssdAvailable;
    }

    static {
        logger = Logger.getLogger(Sssd.class);
    }
}

