/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.console.command.CommandException;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.keycloak.client.admin.cli.commands.GetCmd;
import org.keycloak.client.admin.cli.config.ConfigData;
import org.keycloak.client.admin.cli.operations.ClientOperations;
import org.keycloak.client.admin.cli.operations.GroupOperations;
import org.keycloak.client.admin.cli.operations.RoleOperations;
import org.keycloak.client.admin.cli.operations.UserOperations;
import org.keycloak.client.admin.cli.util.AuthUtil;
import org.keycloak.client.admin.cli.util.ConfigUtil;
import org.keycloak.client.admin.cli.util.HttpUtil;
import org.keycloak.client.admin.cli.util.OsUtil;

@CommandDefinition(name="get-roles", description="[ARGUMENTS]")
public class GetRolesCmd
extends GetCmd {
    @Option(name="uusername", description="Target user's 'username'")
    String uusername;
    @Option(name="uid", description="Target user's 'id'")
    String uid;
    @Option(name="cclientid", description="Target client's 'clientId'")
    String cclientid;
    @Option(name="cid", description="Target client's 'id'")
    String cid;
    @Option(name="rolename", description="Target role's 'name'")
    String rname;
    @Option(name="roleid", description="Target role's 'id'")
    String rid;
    @Option(name="gname", description="Target group's 'name'")
    String gname;
    @Option(name="gpath", description="Target group's 'path'")
    String gpath;
    @Option(name="gid", description="Target group's 'id'")
    String gid;
    @Option(name="available", description="List only available roles", hasValue=false)
    boolean available;
    @Option(name="effective", description="List assigned roles including transitively included roles", hasValue=false)
    boolean effective;
    @Option(name="all", description="List roles for all clients in addition to realm roles", hasValue=false)
    boolean all;

    @Override
    void initOptions() {
        super.initOptions();
        if (this.args == null) {
            this.args = new ArrayList();
        }
        if (this.args.size() == 0) {
            this.args.add("uri");
        } else {
            this.args.add(0, "uri");
        }
    }

    @Override
    void processOptions(CommandInvocation commandInvocation) {
        if (this.uid != null && this.uusername != null) {
            throw new IllegalArgumentException("Incompatible options: --uid and --uusername are mutually exclusive");
        }
        if (this.gid != null && this.gname != null || this.gid != null && this.gpath != null || this.gname != null && this.gpath != null) {
            throw new IllegalArgumentException("Incompatible options: --gid, --gname and --gpath are mutually exclusive");
        }
        if (this.rid != null && this.rname != null) {
            throw new IllegalArgumentException("Incompatible options: --roleid and --rolename are mutually exclusive");
        }
        if (this.cid != null && this.cclientid != null) {
            throw new IllegalArgumentException("Incompatible options: --cid and --cclientid are mutually exclusive");
        }
        if (this.isUserSpecified() && this.isGroupSpecified()) {
            throw new IllegalArgumentException("Incompatible options: --uusername / --uid can't be used at the same time as --gname / --gid / --gpath");
        }
        super.processOptions(commandInvocation);
    }

    @Override
    public CommandResult process(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        String adminRoot;
        ConfigData config = ConfigUtil.loadConfig();
        config = this.copyWithServerInfo(config);
        this.setupTruststore(config, commandInvocation);
        String auth = null;
        config = this.ensureAuthInfo(config, commandInvocation);
        config = this.copyWithServerInfo(config);
        if (ConfigUtil.credentialsAvailable(config)) {
            auth = AuthUtil.ensureToken(config);
        }
        auth = auth != null ? "Bearer " + auth : null;
        String server = config.getServerUrl();
        String realm = this.getTargetRealm(config);
        String string = adminRoot = this.adminRestRoot != null ? this.adminRestRoot : this.composeAdminRoot(server);
        if (this.isUserSpecified()) {
            if (this.uid == null) {
                this.uid = UserOperations.getIdFromUsername(adminRoot, realm, auth, this.uusername);
            }
            if (this.isClientSpecified()) {
                if (this.cid == null) {
                    this.cid = ClientOperations.getIdFromClientId(adminRoot, realm, auth, this.cclientid);
                }
                this.url = this.available ? HttpUtil.composeResourceUrl(adminRoot, realm, "users/" + this.uid + "/role-mappings/clients/" + this.cid + "/available") : (this.effective ? HttpUtil.composeResourceUrl(adminRoot, realm, "users/" + this.uid + "/role-mappings/clients/" + this.cid + "/composite") : HttpUtil.composeResourceUrl(adminRoot, realm, "users/" + this.uid + "/role-mappings/clients/" + this.cid));
            } else {
                this.url = this.available ? HttpUtil.composeResourceUrl(adminRoot, realm, "users/" + this.uid + "/role-mappings/realm/available") : (this.effective ? HttpUtil.composeResourceUrl(adminRoot, realm, "users/" + this.uid + "/role-mappings/realm/composite") : HttpUtil.composeResourceUrl(adminRoot, realm, "users/" + this.uid + "/role-mappings/realm"));
            }
        } else if (this.isGroupSpecified()) {
            if (this.gname != null) {
                this.gid = GroupOperations.getIdFromName(adminRoot, realm, auth, this.gname);
            } else if (this.gpath != null) {
                this.gid = GroupOperations.getIdFromPath(adminRoot, realm, auth, this.gpath);
            }
            if (this.isClientSpecified()) {
                if (this.cid == null) {
                    this.cid = ClientOperations.getIdFromClientId(adminRoot, realm, auth, this.cclientid);
                }
                this.url = this.available ? HttpUtil.composeResourceUrl(adminRoot, realm, "groups/" + this.gid + "/role-mappings/clients/" + this.cid + "/available") : (this.effective ? HttpUtil.composeResourceUrl(adminRoot, realm, "groups/" + this.gid + "/role-mappings/clients/" + this.cid + "/composite") : HttpUtil.composeResourceUrl(adminRoot, realm, "groups/" + this.gid + "/role-mappings/clients/" + this.cid));
            } else {
                this.url = this.available ? HttpUtil.composeResourceUrl(adminRoot, realm, "groups/" + this.gid + "/role-mappings/realm/available") : (this.effective ? HttpUtil.composeResourceUrl(adminRoot, realm, "groups/" + this.gid + "/role-mappings/realm/composite") : HttpUtil.composeResourceUrl(adminRoot, realm, "groups/" + this.gid + "/role-mappings/realm"));
            }
        } else if (this.isClientSpecified()) {
            if (this.cid == null) {
                this.cid = ClientOperations.getIdFromClientId(adminRoot, realm, auth, this.cclientid);
            }
            if (this.isRoleSpecified()) {
                if (this.rname == null) {
                    this.rname = RoleOperations.getClientRoleNameFromId(adminRoot, realm, auth, this.cid, this.rid);
                }
                this.url = HttpUtil.composeResourceUrl(adminRoot, realm, "clients/" + this.cid + "/roles/" + this.rname);
            } else {
                this.url = HttpUtil.composeResourceUrl(adminRoot, realm, "clients/" + this.cid + "/roles");
            }
        } else if (this.isRoleSpecified()) {
            if (this.rname == null) {
                this.rname = RoleOperations.getClientRoleNameFromId(adminRoot, realm, auth, this.cid, this.rid);
            }
            this.url = HttpUtil.composeResourceUrl(adminRoot, realm, "roles/" + this.rname);
        } else {
            this.url = HttpUtil.composeResourceUrl(adminRoot, realm, "roles");
        }
        return super.process(commandInvocation);
    }

    private boolean isRoleSpecified() {
        return this.rid != null || this.rname != null;
    }

    private boolean isClientSpecified() {
        return this.cid != null || this.cclientid != null;
    }

    private boolean isGroupSpecified() {
        return this.gid != null || this.gname != null || this.gpath != null;
    }

    private boolean isUserSpecified() {
        return this.uid != null || this.uusername != null;
    }

    @Override
    protected String suggestHelp() {
        return "";
    }

    @Override
    protected boolean nothingToDo() {
        return false;
    }

    @Override
    protected String help() {
        return GetRolesCmd.usage();
    }

    public static String usage() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + OsUtil.CMD + " get-roles [--cclientid CLIENT_ID | --cid ID] [ARGUMENTS]");
        out.println("Usage: " + OsUtil.CMD + " get-roles (--uusername USERNAME | --uid ID) [--cclientid CLIENT_ID | --cid ID] [--available | --effective] (ARGUMENTS)");
        out.println("Usage: " + OsUtil.CMD + " get-roles (--gname NAME | --gpath PATH | --gid ID) [--cclientid CLIENT_ID | --cid ID] [--available | --effective] [ARGUMENTS]");
        out.println();
        out.println("Command to list realm or client roles on a realm, user or group.");
        out.println();
        out.println("Use `" + OsUtil.CMD + " config credentials` to establish an authenticated session, or use CREDENTIALS OPTIONS");
        out.println("to perform one time authentication.");
        out.println();
        out.println("If client is specified using --cclientid or --cid then client roles are listed, otherwise realm roles are listed.");
        out.println("If user is specified using --uusername or --uid then roles are listed for a specific user.");
        out.println("If group is specified using --gname, --gpath or --gid then roles are listed for a specific group.");
        out.println("If neither user nor group is specified then defined roles are listed for a realm or specific client");
        out.println("If role is specified using --rolename or --roleid then only that specific role is returned.");
        out.println("If --available is specified, then only roles not yet added to the target user or group are returned.");
        out.println("If --effective is specified, then roles added to the target user or group are transitively resolved and a full");
        out.println("set of roles in effect for that user or group is returned.");
        out.println();
        out.println("Arguments:");
        out.println();
        out.println("  Global options:");
        out.println("    -x                    Print full stack trace when exiting with error");
        out.println("    --config              Path to the config file (" + ConfigUtil.DEFAULT_CONFIG_FILE_STRING + " by default)");
        out.println("    --truststore PATH     Path to a truststore containing trusted certificates");
        out.println("    --trustpass PASSWORD  Truststore password (prompted for if not specified and --truststore is used)");
        out.println("    CREDENTIALS OPTIONS   Same set of options as accepted by '" + OsUtil.CMD + " config credentials' in order to establish");
        out.println("                          an authenticated sessions. This allows on-the-fly transient authentication that does");
        out.println("                          not touch a config file.");
        out.println();
        out.println("  Command specific options:");
        out.println("    --uusername               User's 'username'. If more than one user exists with the same username");
        out.println("                              you'll have to use --uid to specify the target user");
        out.println("    --uid                     User's 'id' attribute");
        out.println("    --gname                   Group's 'name'. If more than one group exists with the same name you'll have");
        out.println("                              to use --gid, or --gpath to specify the target group");
        out.println("    --gpath                   Group's 'path' attribute");
        out.println("    --gid                     Group's 'id' attribute");
        out.println("    --cclientid               Client's 'clientId' attribute");
        out.println("    --cid                     Client's 'id' attribute");
        out.println("    --rolename                Role's 'name' attribute");
        out.println("    --roleid                  Role's 'id' attribute");
        out.println("    -a, --admin-root URL      URL of Admin REST endpoint root if not default - e.g. http://localhost:8080/auth/admin");
        out.println("    -r, --target-realm REALM  Target realm to issue requests against if not the one authenticated against");
        out.println();
        out.println("Examples:");
        out.println();
        out.println("Get all realm roles defined on a realm:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " get-roles -r demorealm");
        out.println();
        out.println("Get all client roles defined on a specific client, displaying only 'id' and 'name':");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " get-roles -r demorealm --cclientid realm-management --fields id,name");
        out.println();
        out.println("List all realm roles for a specific user:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " get-roles -r demorealm --uusername testuser");
        out.println();
        out.println("List effective client roles for 'realm-management' client for a specific user:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " get-roles -r demorealm --uusername testuser --cclientid realm-management --effective");
        out.println();
        out.println();
        out.println("Use '" + OsUtil.CMD + " help' for general information and a list of commands");
        return sb.toString();
    }
}

