/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.connections.mongo.api.MongoStore;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.UserCredentialStore;
import org.keycloak.models.ClientModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.mongo.keycloak.entities.CredentialEntity;
import org.keycloak.models.mongo.keycloak.entities.FederatedIdentityEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.federated.UserFederatedStorageProvider;
import org.keycloak.storage.mongo.entity.FederatedUser;

public class MongoUserFederatedStorageProvider
implements UserFederatedStorageProvider,
UserCredentialStore {
    private final MongoStoreInvocationContext invocationContext;
    private final KeycloakSession session;

    public MongoUserFederatedStorageProvider(KeycloakSession session, MongoStoreInvocationContext invocationContext) {
        this.session = session;
        this.invocationContext = invocationContext;
    }

    protected MongoStore getMongoStore() {
        return this.invocationContext.getMongoStore();
    }

    protected FederatedUser addUserEntity(RealmModel realm, String id) {
        FederatedUser userEntity = new FederatedUser();
        userEntity.setId(id);
        userEntity.setStorageId(StorageId.providerId((String)id));
        userEntity.setRealmId(realm.getId());
        this.getMongoStore().insertEntity(userEntity, this.invocationContext);
        return userEntity;
    }

    protected FederatedUser getUserById(String id) {
        return this.getMongoStore().loadEntity(FederatedUser.class, id, this.invocationContext);
    }

    protected FederatedUser findOrCreate(RealmModel realm, String id) {
        FederatedUser user = this.getUserById(id);
        if (user != null) {
            return user;
        }
        return this.addUserEntity(realm, id);
    }

    public boolean removeStoredCredential(RealmModel realm, String userId, String id) {
        FederatedUser userEntity = this.getUserById(userId);
        if (userEntity == null) {
            return false;
        }
        CredentialEntity ce = this.getCredentialEntity(id, userEntity);
        if (ce != null) {
            return this.getMongoStore().pullItemFromList(userEntity, "credentials", ce, this.invocationContext);
        }
        return false;
    }

    private CredentialEntity getCredentialEntity(String id, FederatedUser userEntity) {
        CredentialEntity ce = null;
        if (userEntity.getCredentials() != null) {
            for (CredentialEntity credentialEntity : userEntity.getCredentials()) {
                if (!credentialEntity.getId().equals(id)) continue;
                ce = credentialEntity;
                break;
            }
        }
        return ce;
    }

    protected CredentialModel toModel(CredentialEntity entity) {
        CredentialModel model = new CredentialModel();
        model.setId(entity.getId());
        model.setHashIterations(entity.getHashIterations());
        model.setType(entity.getType());
        model.setValue(entity.getValue());
        model.setAlgorithm(entity.getAlgorithm());
        model.setSalt(entity.getSalt());
        model.setPeriod(entity.getPeriod());
        model.setCounter(entity.getCounter());
        model.setCreatedDate(entity.getCreatedDate());
        model.setDevice(entity.getDevice());
        model.setDigits(entity.getDigits());
        MultivaluedHashMap config = new MultivaluedHashMap();
        model.setConfig(config);
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        return model;
    }

    public CredentialModel getStoredCredentialById(RealmModel realm, String userId, String id) {
        FederatedUser userEntity = this.getUserById(id);
        if (userEntity != null && userEntity.getCredentials() != null) {
            for (CredentialEntity credentialEntity : userEntity.getCredentials()) {
                if (!credentialEntity.getId().equals(id)) continue;
                return this.toModel(credentialEntity);
            }
        }
        return null;
    }

    public List<CredentialModel> getStoredCredentials(RealmModel realm, String userId) {
        FederatedUser userEntity = this.getUserById(userId);
        if (userEntity != null && userEntity.getCredentials() != null) {
            LinkedList<CredentialModel> list = new LinkedList<CredentialModel>();
            for (CredentialEntity credentialEntity : userEntity.getCredentials()) {
                list.add(this.toModel(credentialEntity));
            }
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public List<CredentialModel> getStoredCredentialsByType(RealmModel realm, String userId, String type) {
        FederatedUser userEntity = this.getUserById(userId);
        if (userEntity != null && userEntity.getCredentials() != null) {
            LinkedList<CredentialModel> list = new LinkedList<CredentialModel>();
            for (CredentialEntity credentialEntity : userEntity.getCredentials()) {
                if (!type.equals(credentialEntity.getType())) continue;
                list.add(this.toModel(credentialEntity));
            }
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public CredentialModel getStoredCredentialByNameAndType(RealmModel realm, String userId, String name, String type) {
        FederatedUser userEntity = this.getUserById(userId);
        if (userEntity != null && userEntity.getCredentials() != null) {
            for (CredentialEntity credentialEntity : userEntity.getCredentials()) {
                if (!credentialEntity.getDevice().equals(name) || !type.equals(credentialEntity.getType())) continue;
                return this.toModel(credentialEntity);
            }
        }
        return null;
    }

    public List<String> getStoredUsers(RealmModel realm, int first, int max) {
        QueryBuilder queryBuilder = new QueryBuilder().and("realmId").is((Object)realm.getId());
        DBObject query = queryBuilder.get();
        List<FederatedUser> users = this.getMongoStore().loadEntities(FederatedUser.class, query, null, first, max, this.invocationContext);
        LinkedList<String> ids = new LinkedList<String>();
        for (FederatedUser user : users) {
            ids.add(user.getId());
        }
        return ids;
    }

    public void preRemove(RealmModel realm) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).get();
        this.getMongoStore().removeEntities(FederatedUser.class, query, true, this.invocationContext);
    }

    public void preRemove(RealmModel realm, GroupModel group) {
        DBObject query = new QueryBuilder().and("groupIds").is((Object)group.getId()).get();
        BasicDBObject pull = new BasicDBObject("$pull", (Object)query);
        this.getMongoStore().updateEntities(FederatedUser.class, query, (DBObject)pull, this.invocationContext);
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        DBObject query = new QueryBuilder().and("roleIds").is((Object)role.getId()).get();
        BasicDBObject pull = new BasicDBObject("$pull", (Object)query);
        this.getMongoStore().updateEntities(FederatedUser.class, query, (DBObject)pull, this.invocationContext);
    }

    public void preRemove(RealmModel realm, ClientModel client) {
    }

    public void preRemove(ProtocolMapperModel protocolMapper) {
    }

    public void preRemove(RealmModel realm, UserModel user) {
        this.getMongoStore().removeEntity(FederatedUser.class, user.getId(), this.invocationContext);
    }

    public void preRemove(RealmModel realm, ComponentModel model) {
        if (!model.getProviderType().equals(UserStorageProvider.class.getName())) {
            return;
        }
        DBObject query = new QueryBuilder().and("storageId").is((Object)model.getId()).get();
        this.getMongoStore().removeEntities(FederatedUser.class, query, true, this.invocationContext);
    }

    public void close() {
    }

    public void setSingleAttribute(RealmModel realm, String userId, String name, String value) {
        FederatedUser userEntity = this.findOrCreate(realm, userId);
        if (userEntity.getAttributes() == null) {
            userEntity.setAttributes(new HashMap<String, List<String>>());
        }
        LinkedList<String> attrValues = new LinkedList<String>();
        attrValues.add(value);
        userEntity.getAttributes().put(name, attrValues);
        this.getMongoStore().updateEntity(userEntity, this.invocationContext);
    }

    public void setAttribute(RealmModel realm, String userId, String name, List<String> values) {
        FederatedUser userEntity = this.findOrCreate(realm, userId);
        if (userEntity.getAttributes() == null) {
            userEntity.setAttributes(new HashMap<String, List<String>>());
        }
        userEntity.getAttributes().put(name, values);
        this.getMongoStore().updateEntity(userEntity, this.invocationContext);
    }

    public void removeAttribute(RealmModel realm, String userId, String name) {
        FederatedUser userEntity = this.getUserById(userId);
        if (userEntity == null || userEntity.getAttributes() == null) {
            return;
        }
        userEntity.getAttributes().remove(name);
        this.getMongoStore().updateEntity(userEntity, this.invocationContext);
    }

    public MultivaluedHashMap<String, String> getAttributes(RealmModel realm, String userId) {
        FederatedUser userEntity = this.getUserById(userId);
        if (userEntity == null || userEntity.getAttributes() == null) {
            return new MultivaluedHashMap();
        }
        MultivaluedHashMap result = new MultivaluedHashMap();
        result.putAll(userEntity.getAttributes());
        return result;
    }

    public List<String> getUsersByUserAttribute(RealmModel realm, String name, String value) {
        QueryBuilder queryBuilder = new QueryBuilder().and("realmId").is((Object)realm.getId());
        queryBuilder.and("attributes." + name).is((Object)value);
        List<FederatedUser> users = this.getMongoStore().loadEntities(FederatedUser.class, queryBuilder.get(), this.invocationContext);
        LinkedList<String> ids = new LinkedList<String>();
        for (FederatedUser user : users) {
            ids.add(user.getId());
        }
        return ids;
    }

    public String getUserByFederatedIdentity(FederatedIdentityModel socialLink, RealmModel realm) {
        DBObject query = new QueryBuilder().and("federatedIdentities.identityProvider").is((Object)socialLink.getIdentityProvider()).and("federatedIdentities.userId").is((Object)socialLink.getUserId()).and("realmId").is((Object)realm.getId()).get();
        FederatedUser userEntity = this.getMongoStore().loadSingleEntity(FederatedUser.class, query, this.invocationContext);
        return userEntity != null ? userEntity.getId() : null;
    }

    public void addFederatedIdentity(RealmModel realm, String userId, FederatedIdentityModel socialLink) {
        FederatedUser userEntity = this.findOrCreate(realm, userId);
        FederatedIdentityEntity federatedIdentityEntity = new FederatedIdentityEntity();
        federatedIdentityEntity.setIdentityProvider(socialLink.getIdentityProvider());
        federatedIdentityEntity.setUserId(socialLink.getUserId());
        federatedIdentityEntity.setUserName(socialLink.getUserName().toLowerCase());
        federatedIdentityEntity.setToken(socialLink.getToken());
        this.getMongoStore().pushItemToList(userEntity, "federatedIdentities", federatedIdentityEntity, true, this.invocationContext);
    }

    public boolean removeFederatedIdentity(RealmModel realm, String userId, String socialProvider) {
        FederatedUser userEntity = this.getUserById(userId);
        if (userEntity == null) {
            return false;
        }
        FederatedIdentityEntity federatedIdentityEntity = this.findFederatedIdentityLink(userEntity, socialProvider);
        if (federatedIdentityEntity == null) {
            return false;
        }
        return this.getMongoStore().pullItemFromList(userEntity, "federatedIdentities", federatedIdentityEntity, this.invocationContext);
    }

    private FederatedIdentityEntity findFederatedIdentityLink(FederatedUser userEntity, String identityProvider) {
        List<FederatedIdentityEntity> linkEntities = userEntity.getFederatedIdentities();
        if (linkEntities == null) {
            return null;
        }
        for (FederatedIdentityEntity federatedIdentityEntity : linkEntities) {
            if (!federatedIdentityEntity.getIdentityProvider().equals(identityProvider)) continue;
            return federatedIdentityEntity;
        }
        return null;
    }

    public void updateFederatedIdentity(RealmModel realm, String userId, FederatedIdentityModel federatedIdentityModel) {
        FederatedUser userEntity = this.getUserById(userId);
        if (userEntity == null) {
            return;
        }
        FederatedIdentityEntity federatedIdentityEntity = this.findFederatedIdentityLink(userEntity, federatedIdentityModel.getIdentityProvider());
        if (federatedIdentityEntity == null) {
            return;
        }
        userEntity.getFederatedIdentities().remove(federatedIdentityEntity);
        federatedIdentityEntity.setToken(federatedIdentityModel.getToken());
        this.getMongoStore().pushItemToList(userEntity, "federatedIdentities", federatedIdentityEntity, true, this.invocationContext);
    }

    public Set<FederatedIdentityModel> getFederatedIdentities(String userId, RealmModel realm) {
        FederatedUser userEntity = this.getUserById(userId);
        if (userEntity == null) {
            return Collections.EMPTY_SET;
        }
        List<FederatedIdentityEntity> linkEntities = userEntity.getFederatedIdentities();
        if (linkEntities == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<FederatedIdentityModel> result = new HashSet<FederatedIdentityModel>();
        for (FederatedIdentityEntity federatedIdentityEntity : linkEntities) {
            FederatedIdentityModel model = new FederatedIdentityModel(federatedIdentityEntity.getIdentityProvider(), federatedIdentityEntity.getUserId(), federatedIdentityEntity.getUserName(), federatedIdentityEntity.getToken());
            result.add(model);
        }
        return result;
    }

    public FederatedIdentityModel getFederatedIdentity(String userId, String socialProvider, RealmModel realm) {
        FederatedUser userEntity = this.getUserById(userId);
        if (userEntity == null) {
            return null;
        }
        FederatedIdentityEntity federatedIdentityEntity = this.findFederatedIdentityLink(userEntity, socialProvider);
        return federatedIdentityEntity != null ? new FederatedIdentityModel(federatedIdentityEntity.getIdentityProvider(), federatedIdentityEntity.getUserId(), federatedIdentityEntity.getUserName(), federatedIdentityEntity.getToken()) : null;
    }

    public void addConsent(RealmModel realm, String userId, UserConsentModel consent) {
        this.session.userLocalStorage().addConsent(realm, userId, consent);
    }

    public UserConsentModel getConsentByClient(RealmModel realm, String userId, String clientInternalId) {
        return this.session.userLocalStorage().getConsentByClient(realm, userId, clientInternalId);
    }

    public List<UserConsentModel> getConsents(RealmModel realm, String userId) {
        return this.session.userLocalStorage().getConsents(realm, userId);
    }

    public void updateConsent(RealmModel realm, String userId, UserConsentModel consent) {
        this.session.userLocalStorage().updateConsent(realm, userId, consent);
    }

    public boolean revokeConsentForClient(RealmModel realm, String userId, String clientInternalId) {
        return this.session.userLocalStorage().revokeConsentForClient(realm, userId, clientInternalId);
    }

    public void updateCredential(RealmModel realm, String userId, CredentialModel cred) {
        FederatedUser userEntity = this.getUserById(userId);
        if (userEntity == null) {
            return;
        }
        CredentialEntity entity = this.getCredentialEntity(cred.getId(), userEntity);
        if (entity == null) {
            return;
        }
        this.toEntity(cred, entity);
        userEntity.getCredentials().remove(entity);
        this.getMongoStore().pushItemToList(userEntity, "credentials", entity, true, this.invocationContext);
    }

    private void toEntity(CredentialModel cred, CredentialEntity entity) {
        entity.setAlgorithm(cred.getAlgorithm());
        entity.setCounter(cred.getCounter());
        entity.setCreatedDate(cred.getCreatedDate());
        entity.setDevice(cred.getDevice());
        entity.setDigits(cred.getDigits());
        entity.setHashIterations(cred.getHashIterations());
        entity.setPeriod(cred.getPeriod());
        entity.setSalt(cred.getSalt());
        entity.setType(cred.getType());
        entity.setValue(cred.getValue());
        if (cred.getConfig() == null) {
            entity.setConfig(null);
        } else {
            MultivaluedHashMap newConfig = new MultivaluedHashMap();
            newConfig.putAll((Map)cred.getConfig());
            entity.setConfig((Map<String, List<String>>)newConfig);
        }
    }

    public CredentialModel createCredential(RealmModel realm, String userId, CredentialModel cred) {
        FederatedUser userEntity = this.findOrCreate(realm, userId);
        CredentialEntity entity = new CredentialEntity();
        entity.setId(KeycloakModelUtils.generateId());
        this.toEntity(cred, entity);
        this.getMongoStore().pushItemToList(userEntity, "credentials", entity, true, this.invocationContext);
        cred.setId(entity.getId());
        return cred;
    }

    public Set<GroupModel> getGroups(RealmModel realm, String userId) {
        FederatedUser userEntity = this.getUserById(userId);
        if (userEntity == null || userEntity.getGroupIds() == null || userEntity.getGroupIds().isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<GroupModel> groups = new HashSet<GroupModel>();
        for (String groupId : userEntity.getGroupIds()) {
            GroupModel group = this.session.realms().getGroupById(groupId, realm);
            if (group == null) continue;
            groups.add(group);
        }
        return groups;
    }

    public void joinGroup(RealmModel realm, String userId, GroupModel group) {
        FederatedUser userEntity = this.findOrCreate(realm, userId);
        this.getMongoStore().pushItemToList(userEntity, "groupIds", group.getId(), true, this.invocationContext);
    }

    public void leaveGroup(RealmModel realm, String userId, GroupModel group) {
        FederatedUser userEntity = this.getUserById(userId);
        if (userEntity == null || group == null) {
            return;
        }
        this.getMongoStore().pullItemFromList(userEntity, "groupIds", group.getId(), this.invocationContext);
    }

    public List<String> getMembership(RealmModel realm, GroupModel group, int firstResult, int max) {
        QueryBuilder queryBuilder = new QueryBuilder().and("realmId").is((Object)realm.getId());
        queryBuilder.and("groupIds").is((Object)group.getId());
        List<FederatedUser> users = this.getMongoStore().loadEntities(FederatedUser.class, queryBuilder.get(), null, firstResult, max, this.invocationContext);
        LinkedList<String> ids = new LinkedList<String>();
        for (FederatedUser user : users) {
            ids.add(user.getId());
        }
        return ids;
    }

    public Set<String> getRequiredActions(RealmModel realm, String userId) {
        FederatedUser userEntity = this.getUserById(userId);
        if (userEntity == null || userEntity.getRequiredActions() == null || userEntity.getRequiredActions().isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> set = new HashSet<String>();
        set.addAll(userEntity.getRequiredActions());
        return set;
    }

    public void addRequiredAction(RealmModel realm, String userId, String action) {
        FederatedUser userEntity = this.findOrCreate(realm, userId);
        this.getMongoStore().pushItemToList(userEntity, "requiredActions", action, true, this.invocationContext);
    }

    public void removeRequiredAction(RealmModel realm, String userId, String action) {
        FederatedUser userEntity = this.getUserById(userId);
        if (userEntity == null || userEntity.getRequiredActions() == null || userEntity.getRequiredActions().isEmpty()) {
            return;
        }
        this.getMongoStore().pullItemFromList(userEntity, "requiredActions", action, this.invocationContext);
    }

    public void grantRole(RealmModel realm, String userId, RoleModel role) {
        FederatedUser userEntity = this.findOrCreate(realm, userId);
        this.getMongoStore().pushItemToList(userEntity, "roleIds", role.getId(), true, this.invocationContext);
    }

    public Set<RoleModel> getRoleMappings(RealmModel realm, String userId) {
        FederatedUser userEntity = this.getUserById(userId);
        if (userEntity == null || userEntity.getRoleIds() == null || userEntity.getRoleIds().isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (String roleId : userEntity.getRoleIds()) {
            RoleModel role = realm.getRoleById(roleId);
            if (role == null) continue;
            roles.add(role);
        }
        return roles;
    }

    public void deleteRoleMapping(RealmModel realm, String userId, RoleModel role) {
        FederatedUser userEntity = this.getUserById(userId);
        if (userEntity == null || userEntity.getRoleIds() == null || userEntity.getRoleIds().isEmpty()) {
            return;
        }
        this.getMongoStore().pullItemFromList(userEntity, "roleIds", role.getId(), this.invocationContext);
    }

    public void updateCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        this.updateCredential(realm, user.getId(), cred);
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        return this.createCredential(realm, user.getId(), cred);
    }

    public boolean removeStoredCredential(RealmModel realm, UserModel user, String id) {
        return this.removeStoredCredential(realm, user.getId(), id);
    }

    public CredentialModel getStoredCredentialById(RealmModel realm, UserModel user, String id) {
        return this.getStoredCredentialById(realm, user.getId(), id);
    }

    public List<CredentialModel> getStoredCredentials(RealmModel realm, UserModel user) {
        return this.getStoredCredentials(realm, user.getId());
    }

    public List<CredentialModel> getStoredCredentialsByType(RealmModel realm, UserModel user, String type) {
        return this.getStoredCredentialsByType(realm, user.getId(), type);
    }

    public CredentialModel getStoredCredentialByNameAndType(RealmModel realm, UserModel user, String name, String type) {
        return this.getStoredCredentialByNameAndType(realm, user.getId(), name, type);
    }

    public int getStoredUsersCount(RealmModel realm) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).get();
        return this.getMongoStore().countEntities(FederatedUser.class, query, this.invocationContext);
    }
}

