/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.authorization.infinispan.entities;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;

public class CachedResource
implements Resource,
Serializable {
    private static final long serialVersionUID = -6886179034626995165L;
    private final String id;
    private String resourceServerId;
    private String iconUri;
    private String owner;
    private String type;
    private String name;
    private String uri;
    private Set<String> scopesIds;

    public CachedResource(Resource resource) {
        this.id = resource.getId();
        this.name = resource.getName();
        this.uri = resource.getUri();
        this.type = resource.getType();
        this.owner = resource.getOwner();
        this.iconUri = resource.getIconUri();
        this.resourceServerId = resource.getResourceServer().getId();
        this.scopesIds = resource.getScopes().stream().map(Scope::getId).collect(Collectors.toSet());
    }

    public CachedResource(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<Scope> getScopes() {
        throw new RuntimeException("Not implemented");
    }

    public String getIconUri() {
        return this.iconUri;
    }

    public void setIconUri(String iconUri) {
        this.iconUri = iconUri;
    }

    public ResourceServer getResourceServer() {
        throw new RuntimeException("Not implemented");
    }

    public String getOwner() {
        return this.owner;
    }

    public void updateScopes(Set<Scope> scopes) {
        this.scopesIds.clear();
        this.scopesIds.addAll(scopes.stream().map(Scope::getId).collect(Collectors.toSet()));
    }

    public String getResourceServerId() {
        return this.resourceServerId;
    }

    public Set<String> getScopesIds() {
        return this.scopesIds;
    }
}

