/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.jca;

import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.connector.deployers.ra.RaDeploymentActivator;
import org.jboss.as.connector.services.driver.registry.DriverRegistryService;
import org.jboss.as.connector.services.transactionintegration.TransactionIntegrationService;
import org.jboss.as.connector.subsystems.jca.ConnectionValidatorService;
import org.jboss.as.connector.subsystems.jca.IdleRemoverService;
import org.jboss.as.connector.subsystems.jca.JcaConfigService;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemConfiguration;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.tm.JBossXATerminator;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.jboss.tm.usertx.UserTransactionRegistry;

class JcaSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static final JcaSubsystemAdd INSTANCE = new JcaSubsystemAdd();

    JcaSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) {
        boolean appclient = context.getProcessType() == ProcessType.APPLICATION_CLIENT;
        final RaDeploymentActivator raDeploymentActivator = new RaDeploymentActivator(appclient);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                raDeploymentActivator.activateProcessors(processorTarget);
            }
        }, OperationContext.Stage.RUNTIME);
        ServiceTarget serviceTarget = context.getServiceTarget();
        TransactionIntegrationService tiService = new TransactionIntegrationService();
        serviceTarget.addService(ConnectorServices.TRANSACTION_INTEGRATION_SERVICE, (Service)tiService).addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, TransactionManager.class, tiService.getTmInjector()).addDependency(TxnServices.JBOSS_TXN_SYNCHRONIZATION_REGISTRY, TransactionSynchronizationRegistry.class, tiService.getTsrInjector()).addDependency(TxnServices.JBOSS_TXN_USER_TRANSACTION_REGISTRY, UserTransactionRegistry.class, tiService.getUtrInjector()).addDependency(TxnServices.JBOSS_TXN_XA_TERMINATOR, JBossXATerminator.class, tiService.getTerminatorInjector()).addDependency(TxnServices.JBOSS_TXN_ARJUNA_RECOVERY_MANAGER, XAResourceRecoveryRegistry.class, tiService.getRrInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
        JcaSubsystemConfiguration config = new JcaSubsystemConfiguration();
        JcaConfigService connectorConfigService = new JcaConfigService(config);
        serviceTarget.addService(ConnectorServices.CONNECTOR_CONFIG_SERVICE, (Service)connectorConfigService).setInitialMode(ServiceController.Mode.ACTIVE).install();
        IdleRemoverService idleRemoverService = new IdleRemoverService();
        serviceTarget.addService(ConnectorServices.IDLE_REMOVER_SERVICE, (Service)idleRemoverService).setInitialMode(ServiceController.Mode.ACTIVE).install();
        ConnectionValidatorService connectionValidatorService = new ConnectionValidatorService();
        serviceTarget.addService(ConnectorServices.CONNECTION_VALIDATOR_SERVICE, (Service)connectionValidatorService).setInitialMode(ServiceController.Mode.ACTIVE).install();
        DriverRegistryService driverRegistryService = new DriverRegistryService();
        serviceTarget.addService(ConnectorServices.JDBC_DRIVER_REGISTRY_SERVICE, (Service)driverRegistryService).install();
        raDeploymentActivator.activateServices(serviceTarget);
    }
}

