/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.protection;

import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.admin.ResourceSetService;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.protection.permission.PermissionService;
import org.keycloak.authorization.protection.permission.PermissionsService;
import org.keycloak.authorization.protection.resource.ResourceService;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.ErrorResponseException;

public class ProtectionService {
    private final AuthorizationProvider authorization;

    public ProtectionService(AuthorizationProvider authorization) {
        this.authorization = authorization;
    }

    @Path(value="/resource_set")
    public Object resource() {
        KeycloakIdentity identity = this.createIdentity();
        ResourceServer resourceServer = this.getResourceServer(identity);
        ResourceSetService resourceManager = new ResourceSetService(resourceServer, this.authorization, null);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resourceManager);
        ResourceService resource = new ResourceService(resourceServer, identity, resourceManager, this.authorization);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="/permission")
    public Object permission() {
        KeycloakIdentity identity = this.createIdentity();
        PermissionService resource = new PermissionService(identity, this.getResourceServer(identity), this.authorization);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="/permissions")
    public Object permissions() {
        KeycloakIdentity identity = this.createIdentity();
        PermissionsService resource = new PermissionsService(identity, this.getResourceServer(identity), this.authorization);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    private KeycloakIdentity createIdentity() {
        KeycloakIdentity identity = new KeycloakIdentity(this.authorization.getKeycloakSession());
        ResourceServer resourceServer = this.getResourceServer(identity);
        KeycloakSession keycloakSession = this.authorization.getKeycloakSession();
        RealmModel realm = keycloakSession.getContext().getRealm();
        ClientModel client = realm.getClientById(resourceServer.getClientId());
        if (!identity.hasClientRole(client.getClientId(), "uma_protection")) {
            throw new ErrorResponseException("invalid_scope", "Requires uma_protection scope.", Response.Status.FORBIDDEN);
        }
        return identity;
    }

    private ResourceServer getResourceServer(Identity identity) {
        RealmModel realm = this.authorization.getKeycloakSession().getContext().getRealm();
        ClientModel clientApplication = realm.getClientById(identity.getId());
        if (clientApplication == null) {
            throw new ErrorResponseException("invalid_clientId", "Client application with id [" + identity.getId() + "] does not exist in realm [" + realm.getName() + "]", Response.Status.BAD_REQUEST);
        }
        ResourceServer resourceServer = this.authorization.getStoreFactory().getResourceServerStore().findByClient(identity.getId());
        if (resourceServer == null) {
            throw new ErrorResponseException("invalid_clientId", "Client application [" + clientApplication.getClientId() + "] is not registered as resource server.", Response.Status.FORBIDDEN);
        }
        return resourceServer;
    }
}

