/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.profile.ecp.authenticator;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.common.util.Base64;
import org.keycloak.credential.CredentialInput;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderConfigProperty;

public class HttpBasicAuthenticator
implements AuthenticatorFactory {
    public static final String PROVIDER_ID = "http-basic-authenticator";

    public String getDisplayType() {
        return "HTTP Basic Authentication";
    }

    public String getReferenceCategory() {
        return null;
    }

    public boolean isConfigurable() {
        return false;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return new AuthenticationExecutionModel.Requirement[0];
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public String getHelpText() {
        return "Validates username and password from Authorization HTTP header";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return null;
    }

    public Authenticator create(KeycloakSession session) {
        return new Authenticator(){
            private static final String BASIC = "Basic";
            private static final String BASIC_PREFIX = "Basic ";

            public void authenticate(AuthenticationFlowContext context) {
                HttpRequest httpRequest = context.getHttpRequest();
                HttpHeaders httpHeaders = httpRequest.getHttpHeaders();
                String[] usernameAndPassword = this.getUsernameAndPassword(httpHeaders);
                context.attempted();
                if (usernameAndPassword != null) {
                    RealmModel realm = context.getRealm();
                    UserModel user = context.getSession().users().getUserByUsername(usernameAndPassword[0], realm);
                    if (user != null) {
                        String password = usernameAndPassword[1];
                        boolean valid = context.getSession().userCredentialManager().isValid(realm, user, new CredentialInput[]{UserCredentialModel.password((String)password)});
                        if (valid) {
                            context.getClientSession().setAuthenticatedUser(user);
                            context.success();
                        } else {
                            context.getEvent().user(user);
                            context.getEvent().error("invalid_user_credentials");
                            context.failure(AuthenticationFlowError.INVALID_USER, Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)("Basic realm=\"" + realm.getName() + "\"")).build());
                        }
                    }
                }
            }

            private String[] getUsernameAndPassword(HttpHeaders httpHeaders) {
                List authHeaders = httpHeaders.getRequestHeader("Authorization");
                if (authHeaders == null || authHeaders.size() == 0) {
                    return null;
                }
                String credentials = null;
                for (String authHeader : authHeaders) {
                    if (!authHeader.startsWith(BASIC_PREFIX)) continue;
                    String[] split = authHeader.trim().split("\\s+");
                    if (split == null || split.length != 2) {
                        return null;
                    }
                    credentials = split[1];
                }
                try {
                    return new String(Base64.decode(credentials)).split(":");
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to parse credentials.", e);
                }
            }

            public void action(AuthenticationFlowContext context) {
            }

            public boolean requiresUser() {
                return false;
            }

            public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
                return false;
            }

            public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
            }

            public void close() {
            }
        };
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

