/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.idp;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.picketlink.federation.model.idp.TrustDomainResourceDefinition;
import org.wildfly.extension.picketlink.federation.service.IdentityProviderService;
import org.wildfly.extension.picketlink.federation.service.TrustDomainService;

public class TrustDomainAddHandler
extends AbstractAddStepHandler {
    static final TrustDomainAddHandler INSTANCE = new TrustDomainAddHandler();

    static void launchServices(OperationContext context, PathAddress pathAddress, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String identityProviderName = pathAddress.subAddress(0, pathAddress.size() - 1).getLastElement().getValue();
        String domainName = pathAddress.getLastElement().getValue();
        TrustDomainAddHandler.launchServices(context, identityProviderName, domainName, verificationHandler, newControllers);
    }

    static void launchServices(OperationContext context, String identityProviderName, String domainName, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        TrustDomainService service = new TrustDomainService(domainName);
        ServiceName serviceName = TrustDomainService.createServiceName(identityProviderName, domainName);
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(serviceName, (Service)service);
        serviceBuilder.addDependency(IdentityProviderService.createServiceName(identityProviderName), IdentityProviderService.class, service.getIdentityProviderService());
        if (verificationHandler != null) {
            serviceBuilder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController controller = serviceBuilder.setInitialMode(ServiceController.Mode.PASSIVE).install();
        if (newControllers != null) {
            newControllers.add(controller);
        }
    }

    static void restartServices(OperationContext context, String identityProviderName, String domainName) {
        ServiceName serviceName = TrustDomainService.createServiceName(identityProviderName, domainName);
        context.removeService(serviceName);
        TrustDomainAddHandler.launchServices(context, identityProviderName, domainName, null, null);
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        for (SimpleAttributeDefinition attribute : TrustDomainResourceDefinition.INSTANCE.getAttributes()) {
            attribute.validateAndSet(operation, model);
        }
        TrustDomainResourceDefinition.validateModelInOperation(context, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        TrustDomainAddHandler.launchServices(context, PathAddress.pathAddress((ModelNode)operation.get("address")), model, verificationHandler, newControllers);
    }
}

