/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.impl.AbstractInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;

public abstract class AbstractTxInvocationContext<T extends AbstractCacheTransaction>
extends AbstractInvocationContext
implements TxInvocationContext<T> {
    private final T cacheTransaction;

    protected AbstractTxInvocationContext(T cacheTransaction, Address origin) {
        super(origin);
        if (cacheTransaction == null) {
            throw new NullPointerException("CacheTransaction cannot be null");
        }
        this.cacheTransaction = cacheTransaction;
    }

    @Override
    public Object getLockOwner() {
        return ((AbstractCacheTransaction)this.cacheTransaction).getGlobalTransaction();
    }

    @Override
    public void setLockOwner(Object lockOwner) {
    }

    @Override
    public final Set<Object> getLockedKeys() {
        return ((AbstractCacheTransaction)this.cacheTransaction).getLockedKeys();
    }

    @Override
    public final void addLockedKey(Object key) {
        ((AbstractCacheTransaction)this.cacheTransaction).registerLockedKey(key);
    }

    @Override
    public final GlobalTransaction getGlobalTransaction() {
        return ((AbstractCacheTransaction)this.cacheTransaction).getGlobalTransaction();
    }

    @Override
    public final boolean hasModifications() {
        List<WriteCommand> replicableModifications = this.getModifications();
        return replicableModifications != null && !replicableModifications.isEmpty();
    }

    @Override
    public final List<WriteCommand> getModifications() {
        return ((AbstractCacheTransaction)this.cacheTransaction).getModifications();
    }

    @Override
    public final CacheEntry lookupEntry(Object key) {
        return ((AbstractCacheTransaction)this.cacheTransaction).lookupEntry(key);
    }

    @Override
    public final Map<Object, CacheEntry> getLookedUpEntries() {
        return ((AbstractCacheTransaction)this.cacheTransaction).getLookedUpEntries();
    }

    @Override
    public final Set<Object> getAffectedKeys() {
        return ((AbstractCacheTransaction)this.cacheTransaction).getAffectedKeys();
    }

    @Override
    public final void addAllAffectedKeys(Collection<?> keys) {
        if (keys != null && !keys.isEmpty()) {
            ((AbstractCacheTransaction)this.cacheTransaction).addAllAffectedKeys(keys);
        }
    }

    @Override
    public final void addAffectedKey(Object key) {
        ((AbstractCacheTransaction)this.cacheTransaction).addAffectedKey(key);
    }

    @Override
    public final void putLookedUpEntry(Object key, CacheEntry e) {
        this.cacheTransaction.putLookedUpEntry(key, e);
    }

    @Override
    public final void removeLookedUpEntry(Object key) {
        ((AbstractCacheTransaction)this.cacheTransaction).removeLookedUpEntry(key);
    }

    @Override
    public final boolean isInTxScope() {
        return true;
    }

    @Override
    public final void clearLockedKeys() {
        ((AbstractCacheTransaction)this.cacheTransaction).clearLockedKeys();
    }

    @Override
    public final T getCacheTransaction() {
        return this.cacheTransaction;
    }
}

