/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.Config;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.common.util.UriUtils;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.protocol.oidc.utils.WebOriginsUtils;
import org.keycloak.services.util.CacheControlUtil;
import org.keycloak.services.util.P3PHelper;

public class LoginStatusIframeEndpoint {
    @Context
    private UriInfo uriInfo;
    @Context
    private KeycloakSession session;
    private RealmModel realm;

    public LoginStatusIframeEndpoint(RealmModel realm) {
        this.realm = realm;
    }

    @GET
    @Produces(value={"text/html; charset=utf-8"})
    public Response getLoginStatusIframe(@QueryParam(value="client_id") String client_id, @QueryParam(value="origin") String origin) {
        if (client_id != null && origin != null) {
            return this.getLoginStatusIframeDeprecated(client_id, origin);
        }
        InputStream resource = this.getClass().getClassLoader().getResourceAsStream("login-status-iframe.html");
        if (resource != null) {
            P3PHelper.addP3PHeader(this.session);
            return Response.ok((Object)resource).cacheControl(CacheControlUtil.getDefaultCacheControl()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="init")
    public Response preCheck(@QueryParam(value="client_id") String clientId, @QueryParam(value="origin") String origin) {
        try {
            RealmModel realm = this.session.getContext().getRealm();
            ClientModel client = this.session.realms().getClientByClientId(clientId, realm);
            if (client != null) {
                Set<String> validWebOrigins = WebOriginsUtils.resolveValidWebOrigins(this.uriInfo, client);
                validWebOrigins.add(UriUtils.getOrigin((URI)this.uriInfo.getRequestUri()));
                if (validWebOrigins.contains("*") || validWebOrigins.contains(origin)) {
                    return Response.noContent().build();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    private Response getLoginStatusIframeDeprecated(@QueryParam(value="client_id") String client_id, @QueryParam(value="origin") String origin) {
        if (!UriUtils.isOrigin((String)origin)) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        ClientModel client = this.realm.getClientByClientId(client_id);
        if (client == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("login-status-iframe-deprecated.html");
        if (is == null) {
            throw new NotFoundException("Could not find login-status-iframe-deprecated.html ");
        }
        boolean valid = false;
        for (String o : client.getWebOrigins()) {
            if (!o.equals("*") && !o.equals(origin)) continue;
            valid = true;
            break;
        }
        for (String r : RedirectUtils.resolveValidRedirects(this.uriInfo, client.getRootUrl(), client.getRedirectUris())) {
            int i = r.indexOf(47, 8);
            if (i != -1) {
                r = r.substring(0, i);
            }
            if (!r.equals(origin)) continue;
            valid = true;
            break;
        }
        if (!valid) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        try {
            String file = StreamUtil.readString((InputStream)is);
            file = file.replace("ORIGIN", origin);
            P3PHelper.addP3PHeader(this.session);
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoTransform(false);
            cacheControl.setMaxAge(Config.scope((String[])new String[]{"theme"}).getInt("staticMaxAge", Integer.valueOf(-1)).intValue());
            return Response.ok((Object)file).cacheControl(cacheControl).build();
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
    }
}

