/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds;

import java.util.Map;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.common.CredentialImpl;

public class DsSecurityImpl
extends CredentialImpl
implements DsSecurity {
    private static final long serialVersionUID = -5782260654400841898L;
    private final Extension reauthPlugin;

    public DsSecurityImpl(String userName, String password, String securityDomain, Extension reauthPlugin) throws ValidateException {
        super(userName, password, securityDomain);
        this.reauthPlugin = reauthPlugin;
    }

    public Extension getReauthPlugin() {
        return this.reauthPlugin;
    }

    @Override
    public void validate() throws ValidateException {
        super.validate();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.reauthPlugin == null ? 0 : this.reauthPlugin.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DsSecurityImpl)) {
            return false;
        }
        DsSecurityImpl other = (DsSecurityImpl)obj;
        return !(this.reauthPlugin == null ? other.reauthPlugin != null : !this.reauthPlugin.equals((Object)other.reauthPlugin));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<security>");
        if (this.getUserName() != null) {
            sb.append("<").append(DsSecurity.Tag.USER_NAME).append(">");
            sb.append(this.getUserName());
            sb.append("</").append(DsSecurity.Tag.USER_NAME).append(">");
            sb.append("<").append(DsSecurity.Tag.PASSWORD).append(">");
            sb.append(this.getPassword());
            sb.append("</").append(DsSecurity.Tag.PASSWORD).append(">");
        } else if (this.getSecurityDomain() != null) {
            sb.append("<").append(DsSecurity.Tag.SECURITY_DOMAIN).append(">");
            sb.append(this.getSecurityDomain());
            sb.append("</").append(DsSecurity.Tag.SECURITY_DOMAIN).append(">");
        }
        if (this.getReauthPlugin() != null) {
            sb.append("<").append(DsSecurity.Tag.REAUTH_PLUGIN);
            sb.append(" ").append(Extension.Attribute.CLASS_NAME).append("=\"");
            sb.append(this.getReauthPlugin().getClassName()).append("\"");
            sb.append(">");
            if (this.getReauthPlugin().getConfigPropertiesMap().size() > 0) {
                for (Map.Entry entry : this.getReauthPlugin().getConfigPropertiesMap().entrySet()) {
                    sb.append("<").append(Extension.Tag.CONFIG_PROPERTY);
                    sb.append(" name=\"").append((String)entry.getKey()).append("\">");
                    sb.append((String)entry.getValue());
                    sb.append("</").append(Extension.Tag.CONFIG_PROPERTY).append(">");
                }
            }
            sb.append("</").append(DsSecurity.Tag.REAUTH_PLUGIN).append(">");
        }
        sb.append("</security>");
        return sb.toString();
    }
}

