/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core.management;

import java.text.DateFormat;
import java.util.Date;
import org.apache.activemq.artemis.core.messagecounter.MessageCounter;
import org.apache.activemq.artemis.utils.json.JSONObject;

public final class MessageCounterInfo {
    private final String name;
    private final String subscription;
    private final boolean durable;
    private final long count;
    private final long countDelta;
    private final int depth;
    private final int depthDelta;
    private final String lastAddTimestamp;
    private final String udpateTimestamp;

    public static String toJSon(MessageCounter counter) throws Exception {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
        JSONObject json = new JSONObject((Object)counter);
        String lastAddTimestamp = dateFormat.format(new Date(counter.getLastAddedMessageTime()));
        json.put("lastAddTimestamp", (Object)lastAddTimestamp);
        String updateTimestamp = dateFormat.format(new Date(counter.getLastUpdate()));
        json.put("updateTimestamp", (Object)updateTimestamp);
        return json.toString();
    }

    public static MessageCounterInfo fromJSON(String jsonString) throws Exception {
        JSONObject data = new JSONObject(jsonString);
        String name = data.getString("destinationName");
        String subscription = data.getString("destinationSubscription");
        boolean durable = data.getBoolean("destinationDurable");
        long count = data.getLong("count");
        long countDelta = data.getLong("countDelta");
        int depth = data.getInt("messageCount");
        int depthDelta = data.getInt("messageCountDelta");
        String lastAddTimestamp = data.getString("lastAddTimestamp");
        String updateTimestamp = data.getString("updateTimestamp");
        return new MessageCounterInfo(name, subscription, durable, count, countDelta, depth, depthDelta, lastAddTimestamp, updateTimestamp);
    }

    public MessageCounterInfo(String name, String subscription, boolean durable, long count, long countDelta, int depth, int depthDelta, String lastAddTimestamp, String udpateTimestamp) {
        this.name = name;
        this.subscription = subscription;
        this.durable = durable;
        this.count = count;
        this.countDelta = countDelta;
        this.depth = depth;
        this.depthDelta = depthDelta;
        this.lastAddTimestamp = lastAddTimestamp;
        this.udpateTimestamp = udpateTimestamp;
    }

    public String getName() {
        return this.name;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public long getCount() {
        return this.count;
    }

    public long getCountDelta() {
        return this.countDelta;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getDepthDelta() {
        return this.depthDelta;
    }

    public String getLastAddTimestamp() {
        return this.lastAddTimestamp;
    }

    public String getUdpateTimestamp() {
        return this.udpateTimestamp;
    }
}

