/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.spnego;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.security.auth.Subject;

class SecurityActions {
    SecurityActions() {
    }

    static void addPrivateCredential(Subject subject, Object credential) {
        SecurityActions.loginModuleActions().addPrivateCredential(subject, credential);
    }

    static void removePrivateCredential(Subject subject, Object credential) {
        SecurityActions.loginModuleActions().removePrivateCredential(subject, credential);
    }

    private static LoginModuleActions loginModuleActions() {
        return System.getSecurityManager() != null ? LoginModuleActions.PRIVILEGED : LoginModuleActions.NON_PRIVILEGED;
    }

    private static interface LoginModuleActions {
        public static final LoginModuleActions NON_PRIVILEGED = new LoginModuleActions(){

            @Override
            public void addPrivateCredential(Subject subject, Object credential) {
                Set<Object> privateCredentials = subject.getPrivateCredentials();
                privateCredentials.add(credential);
            }

            @Override
            public void removePrivateCredential(Subject subject, Object credential) {
                Set<Object> privateCredentials = subject.getPrivateCredentials();
                privateCredentials.remove(credential);
            }
        };
        public static final LoginModuleActions PRIVILEGED = new LoginModuleActions(){

            @Override
            public void addPrivateCredential(final Subject subject, final Object credential) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        NON_PRIVILEGED.addPrivateCredential(subject, credential);
                        return null;
                    }
                });
            }

            @Override
            public void removePrivateCredential(final Subject subject, final Object credential) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        NON_PRIVILEGED.removePrivateCredential(subject, credential);
                        return null;
                    }
                });
            }
        };

        public void addPrivateCredential(Subject var1, Object var2);

        public void removePrivateCredential(Subject var1, Object var2);
    }
}

