/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.common.util;

import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.validation.Validator;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.util.DocumentUtil;
import org.picketlink.common.util.SecurityActions;
import org.picketlink.common.util.StringUtil;
import org.picketlink.common.util.SystemPropertiesUtil;
import org.picketlink.common.util.TransformerUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StaxParserUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected static Validator validator = null;

    public static void bypassElementBlock(XMLEventReader xmlEventReader, String tag) throws ParsingException {
        while (xmlEventReader.hasNext()) {
            EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
            if (endElement == null) {
                return;
            }
            if (!StaxParserUtil.matches(endElement, tag)) continue;
            return;
        }
    }

    public static String getAttributeValue(Attribute attribute) {
        String str = StaxParserUtil.trim(attribute.getValue());
        str = StringUtil.getSystemPropertyAsString(str);
        return str;
    }

    public static String getAttributeValue(StartElement startElement, String tag) {
        String result = null;
        Attribute attr = startElement.getAttributeByName(new QName(tag));
        if (attr != null) {
            result = StaxParserUtil.getAttributeValue(attr);
        }
        return result;
    }

    public static Element getDOMElement(XMLEventReader xmlEventReader) throws ParsingException {
        Transformer transformer = null;
        String JDK_TRANSFORMER_PROPERTY = "picketlink.jdk.transformer";
        boolean useJDKTransformer = Boolean.parseBoolean(SecurityActions.getSystemProperty("picketlink.jdk.transformer", "false"));
        try {
            transformer = useJDKTransformer ? TransformerUtil.getTransformer() : TransformerUtil.getStaxSourceToDomResultTransformer();
            Document resultDocument = DocumentUtil.createDocument();
            DOMResult domResult = new DOMResult(resultDocument);
            StAXSource source = new StAXSource(xmlEventReader);
            TransformerUtil.transform(transformer, (Source)source, domResult);
            Document doc = (Document)domResult.getNode();
            return doc.getDocumentElement();
        }
        catch (ConfigurationException e) {
            throw logger.parserException(e);
        }
        catch (XMLStreamException e) {
            throw logger.parserException(e);
        }
    }

    public static String getElementText(XMLEventReader xmlEventReader) throws ParsingException {
        String str = null;
        try {
            str = xmlEventReader.getElementText().trim();
            str = StringUtil.getSystemPropertyAsString(str);
        }
        catch (XMLStreamException e) {
            throw logger.parserException(e);
        }
        return str;
    }

    public static XMLEventReader getXMLEventReader(InputStream is) {
        XMLInputFactory xmlInputFactory = null;
        XMLEventReader xmlEventReader = null;
        try {
            xmlInputFactory = StaxParserUtil.getXMLInputFactory();
            xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
            xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            xmlInputFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
            xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
            xmlEventReader = xmlInputFactory.createXMLEventReader(is);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return xmlEventReader;
    }

    public static String getLineColumnNumber(Location location) {
        StringBuilder builder = new StringBuilder("[");
        builder.append(location.getLineNumber()).append(",").append(location.getColumnNumber()).append("]");
        return builder.toString();
    }

    public static XMLEvent getNextEvent(XMLEventReader xmlEventReader) throws ParsingException {
        try {
            return xmlEventReader.nextEvent();
        }
        catch (XMLStreamException e) {
            throw logger.parserException(e);
        }
    }

    public static StartElement getNextStartElement(XMLEventReader xmlEventReader) throws ParsingException {
        try {
            while (xmlEventReader.hasNext()) {
                XMLEvent xmlEvent = xmlEventReader.nextEvent();
                if (xmlEvent != null && !xmlEvent.isStartElement()) continue;
                return (StartElement)xmlEvent;
            }
        }
        catch (XMLStreamException e) {
            throw logger.parserException(e);
        }
        return null;
    }

    public static EndElement getNextEndElement(XMLEventReader xmlEventReader) throws ParsingException {
        try {
            while (xmlEventReader.hasNext()) {
                XMLEvent xmlEvent = xmlEventReader.nextEvent();
                if (xmlEvent != null && !xmlEvent.isEndElement()) continue;
                return (EndElement)xmlEvent;
            }
        }
        catch (XMLStreamException e) {
            throw logger.parserException(e);
        }
        return null;
    }

    public static String getStartElementName(StartElement startElement) {
        return StaxParserUtil.trim(startElement.getName().getLocalPart());
    }

    public static String getEndElementName(EndElement endElement) {
        return StaxParserUtil.trim(endElement.getName().getLocalPart());
    }

    public static String getXSITypeValue(StartElement startElement) {
        Attribute xsiType = startElement.getAttributeByName(new QName(JBossSAMLURIConstants.XSI_NSURI.get(), JBossSAMLConstants.TYPE.get()));
        if (xsiType == null) {
            throw logger.parserExpectedXSI("PL00072: Parser: Expected xsi:type");
        }
        return StaxParserUtil.getAttributeValue(xsiType);
    }

    public static boolean hasTextAhead(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent event = StaxParserUtil.peek(xmlEventReader);
        return event.getEventType() == 4;
    }

    public static boolean matches(StartElement startElement, String tag) {
        String elementTag = StaxParserUtil.getStartElementName(startElement);
        return tag.equals(elementTag);
    }

    public static boolean matches(EndElement endElement, String tag) {
        String elementTag = StaxParserUtil.getEndElementName(endElement);
        return tag.equals(elementTag);
    }

    public static XMLEvent peek(XMLEventReader xmlEventReader) throws ParsingException {
        try {
            return xmlEventReader.peek();
        }
        catch (XMLStreamException e) {
            throw logger.parserException(e);
        }
    }

    public static StartElement peekNextStartElement(XMLEventReader xmlEventReader) throws ParsingException {
        try {
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = xmlEventReader.peek()) == null || xmlEvent.isStartElement()) {
                    return (StartElement)xmlEvent;
                }
                xmlEvent = xmlEventReader.nextEvent();
            }
        }
        catch (XMLStreamException e) {
            throw logger.parserException(e);
        }
    }

    public static EndElement peekNextEndElement(XMLEventReader xmlEventReader) throws ParsingException {
        try {
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = xmlEventReader.peek()) == null || xmlEvent.isEndElement()) {
                    return (EndElement)xmlEvent;
                }
                xmlEvent = xmlEventReader.nextEvent();
            }
        }
        catch (XMLStreamException e) {
            throw logger.parserException(e);
        }
    }

    public static final String trim(String str) {
        if (str == null) {
            throw logger.nullArgumentError("String to trim");
        }
        return str.trim();
    }

    public static void validate(StartElement startElement, String tag) {
        String foundElementTag = StaxParserUtil.getStartElementName(startElement);
        if (!tag.equals(foundElementTag)) {
            throw logger.parserExpectedTag(tag, foundElementTag);
        }
    }

    public static void validate(EndElement endElement, String tag) {
        String elementTag = StaxParserUtil.getEndElementName(endElement);
        if (!tag.equals(elementTag)) {
            throw new RuntimeException(logger.parserExpectedEndTag("</" + tag + ">.  Found </" + elementTag + ">"));
        }
    }

    private static XMLInputFactory getXMLInputFactory() {
        boolean tccl_jaxp = SystemPropertiesUtil.getSystemProperty("picketlink.jaxp.tccl", "false").equalsIgnoreCase("true");
        ClassLoader prevTCCL = SecurityActions.getTCCL();
        try {
            if (tccl_jaxp) {
                SecurityActions.setTCCL(StaxParserUtil.class.getClassLoader());
            }
            XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
            return xMLInputFactory;
        }
        finally {
            if (tccl_jaxp) {
                SecurityActions.setTCCL(prevTCCL);
            }
        }
    }
}

